/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.helper.content;

import com.install4j.api.context.Context;
import com.install4j.api.context.UserCanceledException;
import com.install4j.runtime.installer.helper.Logger;
import com.install4j.runtime.installer.helper.content.Downloader;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Objects;

public class Md5Checker {
    private static final char[] hexChars = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    public static String getHexStringFromBytes(byte[] bytes) {
        StringBuilder buffer = new StringBuilder();
        for (byte b : bytes) {
            int msb = (b & 0xFF) / 16;
            int lsb = (b & 0xFF) % 16;
            buffer.append(hexChars[msb]);
            buffer.append(hexChars[lsb]);
        }
        return buffer.toString();
    }

    public static String getExpectedMd5(Context context, String urlString, String expectedFileName) throws MalformedURLException, UserCanceledException {
        Downloader downloader = new Downloader(context, null);
        downloader.setAskForProxy(true);
        return Md5Checker.getExpectedMd5(downloader, context, urlString, expectedFileName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getExpectedMd5(Downloader downloader, Context context, String urlString, String expectedFileName) throws UserCanceledException {
        try {
            File md5File = File.createTempFile("md5", ".tmp");
            downloader.connect(urlString).download(md5File, -1L, true);
            try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(md5File), "UTF-8"));){
                String line = reader.readLine();
                while (line != null) {
                    int spaceIndex = line.indexOf(32);
                    if (spaceIndex > -1) {
                        String md5Sum = line.substring(0, spaceIndex);
                        String fileName = line.substring(spaceIndex + 1);
                        while (fileName.startsWith("*") || fileName.startsWith(" ")) {
                            fileName = fileName.substring(1);
                        }
                        if (Objects.equals(fileName, expectedFileName)) {
                            String string = md5Sum;
                            return string;
                        }
                    }
                    line = reader.readLine();
                }
                return "";
            }
            finally {
                md5File.delete();
            }
        }
        catch (IOException e) {
            Logger.getInstance().error(Md5Checker.class, "could not get md5sums");
            Logger.getInstance().log(e);
            return "";
        }
        catch (UserCanceledException e) {
            Logger.getInstance().error(Md5Checker.class, "could not get md5sums");
            Logger.getInstance().log(e);
            if (context == null) return "";
            if (!context.isCancelling()) return "";
            throw e;
        }
    }

    public static String createMd5Url(String mainSpec) throws MalformedURLException {
        int index;
        String path;
        URL mainUrl = new URL(mainSpec);
        String urlString = mainUrl.getProtocol() + ":";
        if (mainUrl.getAuthority() != null && mainUrl.getAuthority().length() > 0) {
            urlString = urlString + "//" + mainUrl.getAuthority();
        }
        if ((path = mainUrl.getPath()) != null && (index = path.lastIndexOf(47)) > -1) {
            urlString = urlString + path.substring(0, index);
        }
        if (!urlString.endsWith("/")) {
            urlString = urlString + "/";
        }
        urlString = urlString + "md5sums";
        if (mainUrl.getQuery() != null) {
            urlString = urlString + "?" + mainUrl.getQuery();
        }
        if (mainUrl.getRef() != null) {
            urlString = urlString + "#" + mainUrl.getRef();
        }
        return urlString;
    }
}

