/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.helper.content;

import com.install4j.api.Util;
import com.install4j.api.context.Context;
import com.install4j.api.context.UserCanceledException;
import com.install4j.runtime.installer.frontend.GUIHelper;
import com.install4j.runtime.installer.frontend.Messages;
import com.install4j.runtime.installer.frontend.VariableResourceBundleWrapper;
import com.install4j.runtime.installer.helper.comm.ExecutionContext;
import com.install4j.runtime.installer.helper.comm.HelperCommunication;
import com.install4j.runtime.installer.helper.comm.actions.FetchBooleanAction;
import com.install4j.runtime.installer.helper.comm.actions.FetchStringAction;
import com.install4j.runtime.installer.helper.comm.actions.RunAction;
import com.install4j.runtime.installer.helper.console.ConsoleImpl;
import com.install4j.runtime.installer.helper.content.ProxyDialog;
import com.install4j.runtime.installer.helper.registry.InstallRegistry;
import com.install4j.runtime.installer.helper.versionspecific.ProxyHostInfo;
import com.install4j.runtime.util.Base64;
import java.awt.Window;
import java.io.IOException;
import java.net.URLConnection;
import java.util.Objects;
import java.util.Properties;

public class ProxyConfig {
    private static ProxyConfig proxyConfig = new ProxyConfig();
    public static final String PROXY_SET = "proxySet";
    public static final String PROXY_HOST = "proxyHost";
    public static final String PROXY_PORT = "proxyPort";
    public static final String PROXY_AUTH = "proxyAuth";
    public static final String PROXY_AUTH_USER = "proxyAuthUser";
    public static final String PROXY_AUTH_PASSWORD = "proxyAuthPassword";
    public static final String PASSWORD_REQUIRED_VALUE = "i4j_pw_required";
    private static final String SYSPROP_CLEAR_PROXY_CACHE = "install4j.clearProxyCache";
    private static final String SYSPROP_DISABLE_PROXY_CONFIG = "install4j.disableProxyConfig";
    private static final String EXTERNAL_PROXY_SET = System.getProperty("proxySet");
    private ProxyDialog proxyDialog;
    private boolean proxySet = false;
    private boolean savedProxySet = false;
    private boolean auth = false;
    private String host = "";
    private String savedHost = "";
    private String port = "";
    private String savedPort = "";
    private String authPassword = "";
    private String authUser = "";
    private boolean passwordRequired = false;

    private ProxyConfig() {
        if (Boolean.getBoolean(SYSPROP_DISABLE_PROXY_CONFIG) || HelperCommunication.getInstance().isElevatedHelper()) {
            return;
        }
        if (Boolean.getBoolean(SYSPROP_CLEAR_PROXY_CACHE)) {
            this.setPropertiesInternal();
            this.saveConfig();
            return;
        }
        String val = EXTERNAL_PROXY_SET;
        if (val != null) {
            this.proxySet = Boolean.parseBoolean(val);
        }
        if ((val = InstallRegistry.getValue(PROXY_SET)) != null) {
            this.savedProxySet = Boolean.parseBoolean(val);
        }
        if ((val = System.getProperty(PROXY_HOST)) != null) {
            this.host = val;
        }
        if ((val = InstallRegistry.getValue(PROXY_HOST)) != null) {
            this.savedHost = val;
        }
        if ((val = System.getProperty(PROXY_PORT)) != null) {
            this.port = val;
        }
        if ((val = InstallRegistry.getValue(PROXY_PORT)) != null) {
            this.savedPort = val;
        }
        if ((val = System.getProperty(PROXY_AUTH)) == null) {
            val = InstallRegistry.getValue(PROXY_AUTH);
        }
        if (val != null) {
            this.auth = Boolean.parseBoolean(val);
        }
        if ((val = System.getProperty(PROXY_AUTH_USER)) == null) {
            val = InstallRegistry.getValue(PROXY_AUTH_USER);
        }
        if (val != null) {
            this.authUser = val;
        }
        if ((val = System.getProperty(PROXY_AUTH_PASSWORD)) == null) {
            if (Objects.equals(PASSWORD_REQUIRED_VALUE, InstallRegistry.getValue(PROXY_AUTH_PASSWORD))) {
                this.passwordRequired = true;
            }
        } else {
            this.authPassword = val;
        }
        this.setPropertiesInternal();
    }

    public static boolean isPasswordRequired() {
        return HelperCommunication.getInstance().fetchBoolean(ExecutionContext.UNELEVATED, new FetchBooleanAction(){

            @Override
            protected boolean fetchValue(Context context) throws Exception {
                return proxyConfig.passwordRequired;
            }
        });
    }

    public static boolean isProxySet() {
        return HelperCommunication.getInstance().fetchBoolean(ExecutionContext.UNELEVATED, new FetchBooleanAction(){

            @Override
            protected boolean fetchValue(Context context) throws Exception {
                return proxyConfig.proxySet;
            }
        });
    }

    public static boolean isAuth() {
        return HelperCommunication.getInstance().fetchBoolean(ExecutionContext.UNELEVATED, new FetchBooleanAction(){

            @Override
            protected boolean fetchValue(Context context) throws Exception {
                return proxyConfig.auth;
            }
        });
    }

    public static String getAuthUser() {
        return HelperCommunication.getInstance().fetchString(ExecutionContext.UNELEVATED, new FetchStringAction(){

            @Override
            protected String fetchValue(Context context) throws Exception {
                return proxyConfig.authUser;
            }
        });
    }

    public static String getAuthPassword() {
        return HelperCommunication.getInstance().fetchString(ExecutionContext.UNELEVATED, new FetchStringAction(){

            @Override
            protected String fetchValue(Context context) throws Exception {
                return proxyConfig.authPassword;
            }
        });
    }

    public static String getHost() {
        return HelperCommunication.getInstance().fetchString(ExecutionContext.UNELEVATED, new FetchStringAction(){

            @Override
            protected String fetchValue(Context context) throws Exception {
                return proxyConfig.host;
            }
        });
    }

    public static String getPort() {
        return HelperCommunication.getInstance().fetchString(ExecutionContext.UNELEVATED, new FetchStringAction(){

            @Override
            protected String fetchValue(Context context) throws Exception {
                return proxyConfig.port;
            }
        });
    }

    public static void setProxySet(final boolean proxySet) {
        HelperCommunication.getInstance().executeAction(ExecutionContext.UNELEVATED, new RunAction(){

            @Override
            protected void run(Context context) throws Exception {
                proxyConfig.proxySet = proxySet;
            }
        });
    }

    public static void setAuth(final boolean auth) {
        HelperCommunication.getInstance().executeAction(ExecutionContext.UNELEVATED, new RunAction(){

            @Override
            protected void run(Context context) throws Exception {
                proxyConfig.auth = auth;
            }
        });
    }

    public static void setHost(final String host) {
        HelperCommunication.getInstance().executeAction(ExecutionContext.UNELEVATED, new RunAction(){

            @Override
            protected void run(Context context) throws Exception {
                proxyConfig.host = host;
            }
        });
    }

    public static void setPort(final String port) {
        HelperCommunication.getInstance().executeAction(ExecutionContext.UNELEVATED, new RunAction(){

            @Override
            protected void run(Context context) throws Exception {
                proxyConfig.port = port;
            }
        });
    }

    public static void setAuthPassword(final String authPassword) {
        HelperCommunication.getInstance().executeAction(ExecutionContext.UNELEVATED, new RunAction(){

            @Override
            protected void run(Context context) throws Exception {
                proxyConfig.authPassword = authPassword;
            }
        });
    }

    public static void setAuthUser(final String authUser) {
        HelperCommunication.getInstance().executeAction(ExecutionContext.UNELEVATED, new RunAction(){

            @Override
            protected void run(Context context) throws Exception {
                proxyConfig.authUser = authUser;
            }
        });
    }

    public static boolean isCanceled() {
        return HelperCommunication.getInstance().fetchBoolean(ExecutionContext.UNELEVATED, new FetchBooleanAction(){

            @Override
            protected boolean fetchValue(Context context) throws Exception {
                return proxyConfig.proxyDialog != null ? proxyConfig.proxyDialog.isCanceled() : false;
            }
        });
    }

    private void showInternal(boolean consoleMode, final boolean passwordOnly, final Window parent) throws UserCanceledException {
        if (consoleMode) {
            ConsoleImpl console = ConsoleImpl.getInstance();
            VariableResourceBundleWrapper resourceBundle = Messages.getMessages();
            if (passwordOnly) {
                console.println(resourceBundle.getString("ProxyAuthentication"));
                this.authPassword = console.askPassword(resourceBundle.getString("Password"), "");
            } else {
                console.println(resourceBundle.getString("DownloadError"));
                console.println(resourceBundle.getString("ConnectionParametersRequest"));
                this.proxySet = console.askYesNo(resourceBundle.getString("ProxyConnection"), this.proxySet);
                if (this.proxySet) {
                    this.host = console.askString(resourceBundle.getString("ProxyHost"), this.host);
                    this.port = console.askString(resourceBundle.getString("ProxyPort"), this.port);
                    this.auth = console.askYesNo(resourceBundle.getString("ProxyAuthentication"), this.auth);
                    if (this.auth) {
                        this.authUser = console.askString(resourceBundle.getString("UserName"), this.authUser);
                        this.authPassword = console.askPassword(resourceBundle.getString("Password"), "");
                    }
                }
            }
        } else {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    Window usedParent;
                    Window window = usedParent = parent != null ? parent : Util.getParentWindow();
                    if (ProxyConfig.this.proxyDialog == null || ProxyConfig.this.proxyDialog.getParentWindow() != usedParent) {
                        if (ProxyConfig.this.proxyDialog != null) {
                            ProxyConfig.this.proxyDialog.dispose();
                        }
                        ProxyConfig.this.proxyDialog = new ProxyDialog(usedParent);
                    }
                    ProxyConfig.this.proxyDialog.setPasswordOnly(passwordOnly);
                    ProxyConfig.this.proxyDialog.setVisible(true);
                }
            };
            if (Boolean.getBoolean("install4j.proxyDialogOnEDT")) {
                GUIHelper.invokeOnEDT(runnable);
            } else {
                runnable.run();
            }
        }
        this.passwordRequired = false;
        ProxyConfig.setProperties();
        this.saveConfig();
    }

    public static void setProperties() {
        HelperCommunication.getInstance().executeAction(ExecutionContext.ALL, new RunAction(){

            @Override
            protected void run(Context context) throws Exception {
                proxyConfig.setPropertiesInternal();
            }
        });
    }

    private void setPropertiesInternal() {
        System.setProperty(PROXY_SET, String.valueOf(this.proxySet));
        if (this.proxySet) {
            System.setProperty(PROXY_HOST, this.host);
            System.setProperty(PROXY_PORT, this.port);
        } else {
            Properties properties = System.getProperties();
            properties.remove(PROXY_HOST);
            properties.remove(PROXY_PORT);
        }
    }

    private void saveConfig() {
        InstallRegistry.setValue(PROXY_SET, String.valueOf(this.proxySet));
        InstallRegistry.setValue(PROXY_HOST, this.host);
        InstallRegistry.setValue(PROXY_PORT, this.port);
        this.savedProxySet = this.proxySet;
        this.savedHost = this.host;
        this.savedPort = this.port;
        InstallRegistry.setValue(PROXY_AUTH, String.valueOf(this.auth));
        InstallRegistry.setValue(PROXY_AUTH_USER, this.authUser);
        if (this.auth && this.authPassword.length() > 0) {
            InstallRegistry.setValue(PROXY_AUTH_PASSWORD, PASSWORD_REQUIRED_VALUE);
        } else {
            InstallRegistry.setValue(PROXY_AUTH_PASSWORD, "");
        }
    }

    public static void updateConnection(URLConnection connection) {
        if (ProxyConfig.isProxySet() && ProxyConfig.isAuth()) {
            String credentials = ProxyConfig.getAuthUser() + ":" + ProxyConfig.getAuthPassword();
            String encodedCredentials = Base64.encode(credentials.getBytes());
            connection.setRequestProperty("Proxy-Authorization", "Basic " + encodedCredentials);
        }
    }

    public static void update(final ProxyHostInfo proxyHostInfo) {
        HelperCommunication.getInstance().executeAction(ExecutionContext.UNELEVATED, new RunAction(){

            @Override
            protected void run(Context context) throws Exception {
                if (EXTERNAL_PROXY_SET != null && Objects.equals(EXTERNAL_PROXY_SET.toLowerCase(), "true")) {
                    return;
                }
                if (proxyHostInfo != null) {
                    proxyConfig.host = proxyHostInfo.getHost();
                    proxyConfig.port = String.valueOf(proxyHostInfo.getPort());
                    proxyConfig.proxySet = true;
                    proxyConfig.auth = false;
                } else {
                    proxyConfig.proxySet = false;
                }
            }
        });
        ProxyConfig.setProperties();
    }

    public static boolean shouldTrySavedValues() {
        return HelperCommunication.getInstance().fetchBoolean(ExecutionContext.UNELEVATED, new FetchBooleanAction(){

            @Override
            protected boolean fetchValue(Context context) throws Exception {
                return proxyConfig.shouldTrySavedValuesInternal();
            }
        });
    }

    private boolean shouldTrySavedValuesInternal() {
        return this.savedProxySet && !Objects.equals(this.savedHost, this.host) && !Objects.equals(this.savedPort, this.port);
    }

    public static void applySavedValues() {
        HelperCommunication.getInstance().executeAction(ExecutionContext.UNELEVATED, new RunAction(){

            @Override
            protected void run(Context context) throws Exception {
                proxyConfig.applySavedValuesInternal();
            }
        });
        ProxyConfig.setProperties();
    }

    private void applySavedValuesInternal() {
        this.proxySet = this.savedProxySet;
        this.host = this.savedHost;
        this.port = this.savedPort;
    }

    public static void show(boolean consoleMode, boolean passwordOnly) throws UserCanceledException, IOException {
        ProxyConfig.show(consoleMode, passwordOnly, null);
    }

    public static void show(final boolean consoleMode, final boolean passwordOnly, final Window parent) throws UserCanceledException, IOException {
        HelperCommunication.getInstance().executeActionChecked(ExecutionContext.UNELEVATED, new RunAction(){

            @Override
            protected void run(Context context) throws Exception {
                proxyConfig.showInternal(consoleMode, passwordOnly, parent);
            }
        });
    }
}

