/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.launcher;

import com.exe4j.runtime.LauncherEngine;
import com.exe4j.runtime.splash.SplashEngine;
import com.exe4j.runtime.splash.SplashScreenConfig;
import com.install4j.runtime.launcher.LauncherHelper;
import com.install4j.runtime.launcher.util.ErrorHandler;
import com.install4j.runtime.launcher.util.LauncherUtil;
import com.install4j.runtime.util.StringUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public class MacLauncher {
    public static final String CONFIG_FILENAME = "Contents/Resources/i4jlauncher.config";
    private static String exeBaseDir;

    public static void main(String[] args) {
        LauncherHelper.INSTANCE.initIntegration();
        try {
            args = LauncherHelper.INSTANCE.initVariables(MacLauncher.class, args);
            String appPackageDir = System.getProperty("exe4j.moduleName");
            LauncherEngine.setProperties(MacLauncher.readProperties(appPackageDir + "/" + CONFIG_FILENAME));
            ErrorHandler.setIsGuiApplication(!LauncherEngine.getBooleanProperty(10007));
            exeBaseDir = LauncherEngine.getBooleanProperty(10006) ? appPackageDir + "/Contents/Resources/app/" + LauncherEngine.getProperty(10001) : appPackageDir + "/../";
            if (!exeBaseDir.endsWith("/")) {
                exeBaseDir = exeBaseDir + "/";
            }
            String className = LauncherEngine.getProperty(122);
            if (LauncherEngine.getBooleanProperty(133)) {
                className = "/" + className;
            }
            String stdErrFile = MacLauncher.getRedirectionFileName(102, 103);
            String stdOutFile = MacLauncher.getRedirectionFileName(104, 105);
            boolean failOnMainMethodException = LauncherEngine.getBooleanProperty(106);
            SplashEngine.setJavaSplashScreenConfig(new SplashScreenConfig().initFromLauncherEngine());
            LauncherEngine.launch(className, args, stdErrFile, stdOutFile, failOnMainMethodException, true, ClassLoader.getSystemClassLoader());
        }
        catch (Exception e) {
            StringBuilder builder = new StringBuilder(e.toString()).append('\n');
            for (StackTraceElement stackTraceElement : e.getStackTrace()) {
                builder.append(stackTraceElement).append('\n');
            }
            ErrorHandler.reportError("error2: " + builder.toString());
            System.exit(1);
        }
    }

    private static String getRedirectionFileName(int propertyRedirect, int propertyFile) {
        String redirectionFile = "";
        if (LauncherEngine.getBooleanProperty(propertyRedirect)) {
            String file = LauncherHelper.INSTANCE.replaceVariables(LauncherEngine.getProperty(propertyFile), new StringUtil.ReplacementCallback(){

                @Override
                public String getReplacement(String token, Object memento) {
                    if (token.equals("launcher:sys.launcherDirectory")) {
                        try {
                            return new File(exeBaseDir).getCanonicalPath();
                        }
                        catch (IOException e) {
                            return exeBaseDir;
                        }
                    }
                    if (token.equals("launcher:sys.pathlistSeparator")) {
                        return ":";
                    }
                    if (token.equals("launcher:sys.tempDir")) {
                        return System.getProperty("java.io.tmpdir");
                    }
                    if (token.equals("launcher:sys.jvmHome")) {
                        return System.getProperty("java.home");
                    }
                    return null;
                }
            });
            if (!file.startsWith(File.separator)) {
                redirectionFile = exeBaseDir;
            }
            redirectionFile = redirectionFile + file;
        }
        return redirectionFile;
    }

    private static Properties readProperties(String fileName) throws IOException {
        FileInputStream is = new FileInputStream(fileName);
        Properties properties = new Properties();
        properties.load(is);
        ((InputStream)is).close();
        return LauncherUtil.replaceVariables(properties);
    }
}

