/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.launcher.integration;

import com.install4j.runtime.launcher.integration.AutomaticUpdate;
import com.install4j.runtime.launcher.integration.LockFile;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class SingleBundleUpdater {
    public static void main(String[] args) {
        File sourceBundle = new File(args[0]);
        File destinationDirectory = new File(args[1]);
        boolean restartLauncher = Boolean.parseBoolean(args[2]);
        List<String> launcherArguments = Arrays.asList(args).subList(3, args.length);
        LockFile.waitForLockFile();
        try {
            Thread.sleep(200L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        boolean success = false;
        try {
            SingleBundleUpdater.moveBundle(sourceBundle, destinationDirectory);
            success = true;
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        AutomaticUpdate.checkRegularExit(success, false);
        if (restartLauncher) {
            File launchBundle;
            File file = launchBundle = success ? new File(destinationDirectory, sourceBundle.getName()) : AutomaticUpdate.getCurrentSingleBundle();
            if (launchBundle != null) {
                ArrayList<String> command = new ArrayList<String>();
                command.add("/usr/bin/open");
                command.add(launchBundle.getAbsolutePath());
                if (!launcherArguments.isEmpty()) {
                    command.add("--args");
                    command.addAll(launcherArguments);
                }
                try {
                    new ProcessBuilder(command).start();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        System.exit(0);
    }

    private static void moveBundle(File sourceBundle, File destinationDirectory) throws IOException, InterruptedException {
        ArrayList<String> command = new ArrayList<String>();
        command.add("/usr/bin/osascript");
        command.add("-e");
        command.add("tell application \"Finder\"");
        command.add("-e");
        command.add("move POSIX file \"" + sourceBundle + "\" to POSIX file \"" + destinationDirectory + "\" with replacing");
        command.add("-e");
        command.add("end tell");
        Process process = new ProcessBuilder(command).start();
        int returnCode = process.waitFor();
        if (returnCode != 0) {
            throw new IOException("osascript returned " + returnCode);
        }
    }
}

