/*
 * Decompiled with CFR 0.152.
 */
package jsyntaxpane;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.event.DocumentEvent;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.PlainDocument;
import javax.swing.text.Segment;
import javax.swing.undo.UndoManager;
import jsyntaxpane.CompoundUndoManager;
import jsyntaxpane.Lexer;
import jsyntaxpane.Token;
import jsyntaxpane.TokenType;

public class SyntaxDocument
extends PlainDocument {
    public static final String CAN_UNDO = "can-undo";
    public static final String CAN_REDO = "can-redo";
    private static final Logger logger = Logger.getLogger(SyntaxDocument.class.getName());
    Lexer lexer;
    List<Token> tokens;
    UndoManager undo;
    private final PropertyChangeSupport propSupport;
    private boolean canUndoState = false;
    private boolean canRedoState = false;
    private static final Logger log = Logger.getLogger(SyntaxDocument.class.getName());

    public SyntaxDocument(Lexer lexer) {
        this.putProperty("tabSize", 4);
        this.lexer = lexer;
        this.undo = new CompoundUndoManager(this);
        this.propSupport = new PropertyChangeSupport(this);
    }

    public void setUndoManager(UndoManager undo) {
        logger.fine("setUndoManager(" + undo + ")");
        if (this.undo != null) {
            logger.finer("remove old manager " + this.undo);
            this.removeUndoableEditListener(this.undo);
        }
        this.undo = undo;
        this.addUndoableEditListener(this.undo);
    }

    public void resetUndo() {
        this.undo.discardAllEdits();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parse() {
        ArrayList<Token> toks;
        block6: {
            if (this.lexer == null) {
                this.tokens = null;
                return;
            }
            toks = new ArrayList<Token>(this.getLength() / 10);
            long ts = System.nanoTime();
            int len = this.getLength();
            try {
                Segment seg = new Segment();
                this.getText(0, this.getLength(), seg);
                this.lexer.parse(seg, 0, toks);
                if (!log.isLoggable(Level.FINEST)) break block6;
            }
            catch (BadLocationException ex) {
                block7: {
                    try {
                        log.log(Level.SEVERE, null, ex);
                        if (!log.isLoggable(Level.FINEST)) break block7;
                    }
                    catch (Throwable throwable) {
                        if (log.isLoggable(Level.FINEST)) {
                            log.finest(String.format("Parsed %d in %d ms, giving %d tokens\n", len, (System.nanoTime() - ts) / 1000000L, toks.size()));
                        }
                        this.tokens = toks;
                        throw throwable;
                    }
                    log.finest(String.format("Parsed %d in %d ms, giving %d tokens\n", len, (System.nanoTime() - ts) / 1000000L, toks.size()));
                }
                this.tokens = toks;
            }
            log.finest(String.format("Parsed %d in %d ms, giving %d tokens\n", len, (System.nanoTime() - ts) / 1000000L, toks.size()));
        }
        this.tokens = toks;
    }

    @Override
    protected void fireChangedUpdate(DocumentEvent e) {
        this.parse();
        super.fireChangedUpdate(e);
    }

    @Override
    protected void fireInsertUpdate(DocumentEvent e) {
        this.parse();
        super.fireInsertUpdate(e);
    }

    @Override
    protected void fireRemoveUpdate(DocumentEvent e) {
        this.parse();
        super.fireRemoveUpdate(e);
    }

    public void replaceToken(Token token, String replacement) {
        try {
            this.replace(token.start, token.length, replacement, null);
        }
        catch (BadLocationException ex) {
            log.log(Level.WARNING, "unable to replace token: " + token, ex);
        }
    }

    public Iterator<Token> getTokens(int start, int end) {
        return new TokenIterator(start, end);
    }

    public Token getTokenAt(int pos) {
        if (this.tokens == null || this.tokens.isEmpty() || pos > this.getLength()) {
            return null;
        }
        Token tok = null;
        Token tKey = new Token(TokenType.DEFAULT, pos, 1);
        int ndx = Collections.binarySearch(this.tokens, tKey);
        if (ndx < 0) {
            ndx = -ndx - 1 - 1 < 0 ? 0 : -ndx - 1 - 1;
            Token t = this.tokens.get(ndx);
            if (t.start <= pos && pos <= t.end()) {
                tok = t;
            }
        } else {
            tok = this.tokens.get(ndx);
        }
        return tok;
    }

    public Token getWordAt(int offs, Pattern p) {
        Token word;
        block4: {
            word = null;
            try {
                Element line = this.getParagraphElement(offs);
                if (line == null) {
                    return null;
                }
                int lineStart = line.getStartOffset();
                int lineEnd = Math.min(line.getEndOffset(), this.getLength());
                Segment seg = new Segment();
                this.getText(lineStart, lineEnd - lineStart, seg);
                if (seg.count <= 0) break block4;
                Matcher m = p.matcher(seg);
                int o = offs - lineStart;
                while (m.find()) {
                    if (m.start() > o || o > m.end()) continue;
                    word = new Token(TokenType.DEFAULT, m.start() + lineStart, m.end() - m.start());
                    break;
                }
            }
            catch (BadLocationException ex) {
                Logger.getLogger(SyntaxDocument.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return word;
    }

    public Token getNextToken(Token tok) {
        int n = this.tokens.indexOf(tok);
        if (n >= 0 && n < this.tokens.size() - 1) {
            return this.tokens.get(n + 1);
        }
        return null;
    }

    public Token getPrevToken(Token tok) {
        int n = this.tokens.indexOf(tok);
        if (n > 0 && !this.tokens.isEmpty()) {
            return this.tokens.get(n - 1);
        }
        return null;
    }

    public Token getPairFor(Token t) {
        if (t == null || t.pairValue == 0) {
            return null;
        }
        Token p = null;
        int ndx = this.tokens.indexOf(t);
        int w = t.pairValue;
        int direction = t.pairValue > 0 ? 1 : -1;
        boolean done = false;
        int v = Math.abs(t.pairValue);
        while (!done && (ndx += direction) >= 0 && ndx < this.tokens.size()) {
            Token current = this.tokens.get(ndx);
            if (Math.abs(current.pairValue) != v || (w += current.pairValue) != 0) continue;
            p = current;
            done = true;
        }
        return p;
    }

    public void setCanUndo(boolean value) {
        if (this.canUndoState != value) {
            this.canUndoState = value;
            this.propSupport.firePropertyChange(CAN_UNDO, !value, value);
        }
    }

    public void setCanRedo(boolean value) {
        if (this.canRedoState != value) {
            this.canRedoState = value;
            this.propSupport.firePropertyChange(CAN_REDO, !value, value);
        }
    }

    public void addPropertyChangeListener(String property, PropertyChangeListener listener) {
        this.propSupport.addPropertyChangeListener(property, listener);
    }

    public void removePropertyChangeListener(String property, PropertyChangeListener listener) {
        this.propSupport.removePropertyChangeListener(property, listener);
    }

    public void doUndo() {
        if (this.undo.canUndo()) {
            this.undo.undo();
            this.parse();
        }
    }

    public boolean canUndo() {
        return this.undo.canUndo();
    }

    public void doRedo() {
        if (this.undo.canRedo()) {
            this.undo.redo();
            this.parse();
        }
    }

    public boolean canRedo() {
        return this.undo.canRedo();
    }

    public void clearUndos() {
        this.undo.discardAllEdits();
    }

    public Matcher getMatcher(Pattern pattern) {
        return this.getMatcher(pattern, 0, this.getLength());
    }

    public Matcher getMatcher(Pattern pattern, int start) {
        return this.getMatcher(pattern, start, this.getLength() - start);
    }

    public Matcher getMatcher(Pattern pattern, int start, int length) {
        Matcher matcher = null;
        if (this.getLength() == 0) {
            return null;
        }
        if (start >= this.getLength()) {
            return null;
        }
        try {
            if (start < 0) {
                start = 0;
            }
            if (start + length > this.getLength()) {
                length = this.getLength() - start;
            }
            Segment seg = new Segment();
            this.getText(start, length, seg);
            matcher = pattern.matcher(seg);
        }
        catch (BadLocationException ex) {
            log.log(Level.SEVERE, "Requested offset: " + ex.offsetRequested(), ex);
        }
        return matcher;
    }

    public String getLineAt(int pos) throws BadLocationException {
        Element e = this.getParagraphElement(pos);
        Segment seg = new Segment();
        this.getText(e.getStartOffset(), e.getEndOffset() - e.getStartOffset(), seg);
        char last = seg.last();
        if (last == '\n' || last == '\r') {
            --seg.count;
        }
        return seg.toString();
    }

    public void removeLineAt(int pos) throws BadLocationException {
        Element e = this.getParagraphElement(pos);
        this.remove(e.getStartOffset(), this.getElementLength(e));
    }

    public void replaceLineAt(int pos, String newLines) throws BadLocationException {
        Element e = this.getParagraphElement(pos);
        this.replace(e.getStartOffset(), this.getElementLength(e), newLines, null);
    }

    private int getElementLength(Element e) {
        int end = e.getEndOffset();
        if (end >= this.getLength() - 1) {
            --end;
        }
        return end - e.getStartOffset();
    }

    public synchronized String getUncommentedText(int aStart, int anEnd) {
        this.readLock();
        StringBuilder result = new StringBuilder();
        Iterator<Token> iter = this.getTokens(aStart, anEnd);
        while (iter.hasNext()) {
            Token t = iter.next();
            if (TokenType.isComment(t)) continue;
            result.append(t.getText(this));
        }
        this.readUnlock();
        return result.toString();
    }

    public int getLineStartOffset(int pos) {
        return this.getParagraphElement(pos).getStartOffset();
    }

    public int getLineEndOffset(int pos) {
        int end = 0;
        end = this.getParagraphElement(pos).getEndOffset();
        if (end >= this.getLength()) {
            end = this.getLength();
        }
        return end;
    }

    public int getLineCount() {
        Element e = this.getDefaultRootElement();
        return e.getElementCount();
    }

    public int getLineNumberAt(int pos) {
        return this.getDefaultRootElement().getElementIndex(pos);
    }

    public String toString() {
        return "SyntaxDocument(" + this.lexer + ", " + (this.tokens == null ? 0 : this.tokens.size()) + " tokens)@" + this.hashCode();
    }

    @Override
    public void replace(int offset, int length, String text, AttributeSet attrs) throws BadLocationException {
        this.remove(offset, length);
        if (this.undo instanceof CompoundUndoManager) {
            ((CompoundUndoManager)this.undo).startCombine();
        }
        this.insertString(offset, text, attrs);
    }

    public SyntaxDocument append(String str) {
        try {
            this.insertString(this.getLength(), str, null);
        }
        catch (BadLocationException ex) {
            log.log(Level.WARNING, "Error appending str", ex);
        }
        return this;
    }

    class TokenIterator
    implements ListIterator<Token> {
        int start;
        int end;
        int ndx = 0;

        private TokenIterator(int start, int end) {
            this.start = start;
            this.end = end;
            if (SyntaxDocument.this.tokens != null && !SyntaxDocument.this.tokens.isEmpty()) {
                Token token = new Token(TokenType.COMMENT, start, end - start);
                this.ndx = Collections.binarySearch(SyntaxDocument.this.tokens, token);
                if (this.ndx < 0) {
                    this.ndx = -this.ndx - 1 - 1 < 0 ? 0 : -this.ndx - 1 - 1;
                    Token t = SyntaxDocument.this.tokens.get(this.ndx);
                    if (t.end() <= start) {
                        ++this.ndx;
                    }
                }
            }
        }

        @Override
        public boolean hasNext() {
            if (SyntaxDocument.this.tokens == null) {
                return false;
            }
            if (this.ndx >= SyntaxDocument.this.tokens.size()) {
                return false;
            }
            Token t = SyntaxDocument.this.tokens.get(this.ndx);
            return t.start < this.end;
        }

        @Override
        public Token next() {
            return SyntaxDocument.this.tokens.get(this.ndx++);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean hasPrevious() {
            if (SyntaxDocument.this.tokens == null) {
                return false;
            }
            if (this.ndx <= 0) {
                return false;
            }
            Token t = SyntaxDocument.this.tokens.get(this.ndx);
            return t.end() > this.start;
        }

        @Override
        public Token previous() {
            return SyntaxDocument.this.tokens.get(this.ndx--);
        }

        @Override
        public int nextIndex() {
            return this.ndx + 1;
        }

        @Override
        public int previousIndex() {
            return this.ndx - 1;
        }

        @Override
        public void set(Token e) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(Token e) {
            throw new UnsupportedOperationException();
        }
    }
}

