/*
 * Decompiled with CFR 0.152.
 */
package jsyntaxpane;

import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.GeneralPath;
import javax.swing.text.Segment;
import javax.swing.text.TabExpander;
import javax.swing.text.Utilities;

public final class SyntaxStyle {
    private Color color;
    private int fontStyle;
    private boolean drawTabs = true;
    public static final String PROP_DRAWTABS = "drawTabs";

    public SyntaxStyle() {
    }

    public SyntaxStyle(Color color, boolean bold, boolean italic) {
        this.color = color;
        this.setBold(bold);
        this.setItalic(italic);
    }

    public SyntaxStyle(Color color, int fontStyle) {
        this.color = color;
        this.fontStyle = fontStyle;
    }

    public SyntaxStyle(String str) {
        String[] parts = str.split("\\s*,\\s*");
        if (parts.length != 2) {
            throw new IllegalArgumentException("style not correct format: " + str);
        }
        this.color = new Color(Integer.decode(parts[0]));
        this.fontStyle = Integer.decode(parts[1]);
    }

    public boolean isBold() {
        return (this.fontStyle & 1) != 0;
    }

    public void setBold(Boolean bold) {
        if (bold.booleanValue()) {
            this.fontStyle |= 1;
        } else {
            int mask = -2;
            this.fontStyle &= mask;
        }
    }

    public String getColorString() {
        return String.format("0x%06x", this.color.getRGB() & 0xFFFFFF);
    }

    public void setColorString(String color) {
        this.color = Color.decode(color);
    }

    public Boolean isItalic() {
        return (this.fontStyle & 2) != 0;
    }

    public void setItalic(Boolean italic) {
        this.fontStyle = italic.booleanValue() ? (this.fontStyle |= 2) : (this.fontStyle &= 0xFFFFFFFD);
    }

    public boolean isDrawTabs() {
        return this.drawTabs;
    }

    public void setDrawTabs(boolean drawTabs) {
        this.drawTabs = drawTabs;
    }

    public int getFontStyle() {
        return this.fontStyle;
    }

    public Color getColor() {
        return this.color;
    }

    static final int drawTabbedTextWidth(Graphics2D g, Segment s, FontMetrics metrics, int x, int y, TabExpander e, int startOffset) {
        int nextX = x;
        char[] txt = s.array;
        int txtOffset = s.offset;
        int n = s.offset + s.count;
        int charCount = 0;
        int spaceAddon = 0;
        int spaceAddonLeftoverEnd = -1;
        int startJustifiableContent = 0;
        int endJustifiableContent = 0;
        int currentX = x;
        for (int i = txtOffset; i < n; ++i) {
            if (txt[i] == '\t' || (spaceAddon != 0 || i <= spaceAddonLeftoverEnd) && txt[i] == ' ' && startJustifiableContent <= i && i <= endJustifiableContent) {
                nextX += metrics.charsWidth(txt, i - charCount, charCount);
                charCount = 0;
                if (txt[i] == '\t') {
                    nextX = e != null ? (int)e.nextTabStop(nextX, startOffset + i - txtOffset) : (nextX += metrics.charWidth(' '));
                } else if (txt[i] == ' ') {
                    nextX += metrics.charWidth(' ') + spaceAddon;
                    if (i <= spaceAddonLeftoverEnd) {
                        ++nextX;
                    }
                }
                g.setColor(Color.LIGHT_GRAY);
                int dx = 3;
                int hy = y;
                int hx = nextX - 2;
                GeneralPath p = new GeneralPath();
                p.moveTo(hx, hy);
                p.lineTo(hx - 2 * dx, hy - dx - 1);
                p.lineTo(hx - 2 * dx, hy + dx + 1);
                p.lineTo(hx, hy);
                g.fill(p);
                g.drawLine(currentX + 2, y, hx - 2, y);
                currentX = nextX;
                continue;
            }
            if (txt[i] == '\n') {
                nextX += metrics.charsWidth(txt, i - charCount, charCount);
                charCount = 0;
                currentX = 0;
                continue;
            }
            currentX += metrics.charsWidth(txt, i, 1);
            ++charCount;
        }
        return (nextX += metrics.charsWidth(txt, n - charCount, charCount)) - x;
    }

    public int drawText(Segment segment, int x, int y, Graphics graphics, TabExpander e, int startOffset) {
        graphics.setFont(graphics.getFont().deriveFont(this.getFontStyle()));
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int a = fontMetrics.getAscent();
        int h = a + fontMetrics.getDescent();
        int w = Utilities.getTabbedTextWidth(segment, fontMetrics, 0, e, startOffset);
        int rX = x - 1;
        int rY = y - a;
        int rW = w + 2;
        int rH = h;
        if ((this.getFontStyle() & 0x10) != 0) {
            graphics.setColor(Color.decode("#EEEEEE"));
            graphics.fillRect(rX, rY, rW, rH);
        }
        if (this.drawTabs) {
            SyntaxStyle.drawTabbedTextWidth((Graphics2D)graphics.create(), segment, fontMetrics, x, y - fontMetrics.getAscent() / 2, e, startOffset);
        }
        graphics.setColor(this.getColor());
        x = Utilities.drawTabbedText(segment, x, y, graphics, e, startOffset);
        if ((this.getFontStyle() & 8) != 0) {
            graphics.setColor(Color.RED);
            graphics.drawRect(rX, rY, rW, rH);
        }
        return x;
    }
}

