/*
 * Decompiled with CFR 0.152.
 */
package proguard.evaluation;

import proguard.evaluation.Stack;
import proguard.evaluation.value.Value;

public class TracedStack
extends Stack {
    private Value producerValue;
    private Stack producerStack;

    public TracedStack(int n) {
        super(n);
        this.producerStack = new Stack(n);
    }

    public TracedStack(TracedStack tracedStack) {
        super(tracedStack);
        this.producerStack = new Stack(tracedStack.producerStack);
    }

    public void setProducerValue(Value value) {
        this.producerValue = value;
    }

    public Value getBottomProducerValue(int n) {
        return this.producerStack.getBottom(n);
    }

    public void setBottomProducerValue(int n, Value value) {
        this.producerStack.setBottom(n, value);
    }

    public Value getTopProducerValue(int n) {
        return this.producerStack.getTop(n);
    }

    public void setTopProducerValue(int n, Value value) {
        this.producerStack.setTop(n, value);
    }

    @Override
    public void reset(int n) {
        super.reset(n);
        this.producerStack.reset(n);
    }

    public void copy(TracedStack tracedStack) {
        super.copy(tracedStack);
        this.producerStack.copy(tracedStack.producerStack);
    }

    public boolean generalize(TracedStack tracedStack) {
        return super.generalize(tracedStack) | this.producerStack.generalize(tracedStack.producerStack);
    }

    @Override
    public void clear() {
        super.clear();
        this.producerStack.clear();
    }

    @Override
    public void removeTop(int n) {
        super.removeTop(n);
        this.producerStack.removeTop(n);
    }

    @Override
    public void push(Value value) {
        super.push(value);
        this.producerPush();
        if (value.isCategory2()) {
            this.producerPush();
        }
    }

    @Override
    public Value pop() {
        Value value = super.pop();
        this.producerPop();
        if (value.isCategory2()) {
            this.producerPop();
        }
        return value;
    }

    @Override
    public void pop1() {
        super.pop1();
        this.producerPop();
    }

    @Override
    public void pop2() {
        super.pop2();
        this.producerPop();
        this.producerPop();
    }

    @Override
    public void dup() {
        super.dup();
        this.producerPop();
        this.producerPush();
        this.producerPush();
    }

    @Override
    public void dup_x1() {
        super.dup_x1();
        this.producerPop();
        this.producerPop();
        this.producerPush();
        this.producerPush();
        this.producerPush();
    }

    @Override
    public void dup_x2() {
        super.dup_x2();
        this.producerPop();
        this.producerPop();
        this.producerPop();
        this.producerPush();
        this.producerPush();
        this.producerPush();
        this.producerPush();
    }

    @Override
    public void dup2() {
        super.dup2();
        this.producerPop();
        this.producerPop();
        this.producerPush();
        this.producerPush();
        this.producerPush();
        this.producerPush();
    }

    @Override
    public void dup2_x1() {
        super.dup2_x1();
        this.producerPop();
        this.producerPop();
        this.producerPop();
        this.producerPush();
        this.producerPush();
        this.producerPush();
        this.producerPush();
        this.producerPush();
    }

    @Override
    public void dup2_x2() {
        super.dup2_x2();
        this.producerPop();
        this.producerPop();
        this.producerPop();
        this.producerPop();
        this.producerPush();
        this.producerPush();
        this.producerPush();
        this.producerPush();
        this.producerPush();
        this.producerPush();
    }

    @Override
    public void swap() {
        super.swap();
        this.producerPop();
        this.producerPop();
        this.producerPush();
        this.producerPush();
    }

    @Override
    public boolean equals(Object object) {
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        TracedStack tracedStack = (TracedStack)object;
        return super.equals(object) && this.producerStack.equals(tracedStack.producerStack);
    }

    @Override
    public int hashCode() {
        return super.hashCode() ^ this.producerStack.hashCode();
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.size(); ++i) {
            Value value = this.values[i];
            Value value2 = this.producerStack.getBottom(i);
            stringBuffer = stringBuffer.append('[').append(value2 == null ? "empty:" : value2.toString()).append(value == null ? "empty" : value.toString()).append(']');
        }
        return stringBuffer.toString();
    }

    private void producerPush() {
        this.producerStack.push(this.producerValue);
    }

    private void producerPop() {
        this.producerStack.pop();
    }
}

