/*
 * Decompiled with CFR 0.152.
 */
package proguard.optimize.evaluation;

import proguard.classfile.Clazz;
import proguard.classfile.Member;
import proguard.classfile.Method;
import proguard.classfile.ProgramClass;
import proguard.classfile.ProgramMethod;
import proguard.classfile.attribute.Attribute;
import proguard.classfile.attribute.CodeAttribute;
import proguard.classfile.attribute.visitor.AttributeVisitor;
import proguard.classfile.editor.CodeAttributeEditor;
import proguard.classfile.instruction.BranchInstruction;
import proguard.classfile.instruction.ConstantInstruction;
import proguard.classfile.instruction.Instruction;
import proguard.classfile.instruction.InstructionFactory;
import proguard.classfile.instruction.SimpleInstruction;
import proguard.classfile.instruction.SwitchInstruction;
import proguard.classfile.instruction.VariableInstruction;
import proguard.classfile.instruction.visitor.InstructionVisitor;
import proguard.classfile.util.SimplifiedVisitor;
import proguard.classfile.visitor.MemberVisitor;
import proguard.classfile.visitor.ReferencedMemberVisitor;
import proguard.evaluation.TracedStack;
import proguard.evaluation.TracedVariables;
import proguard.evaluation.value.InstructionOffsetValue;
import proguard.evaluation.value.Value;
import proguard.optimize.evaluation.PartialEvaluator;
import proguard.optimize.info.ParameterUsageMarker;
import proguard.optimize.info.SideEffectInstructionChecker;

public class EvaluationSimplifier
extends SimplifiedVisitor
implements AttributeVisitor {
    private static final boolean DEBUG_RESULTS = false;
    private static final boolean DEBUG_ANALYSIS = false;
    private static final boolean DEBUG = false;
    private final InstructionVisitor extraPushInstructionVisitor;
    private final InstructionVisitor extraBranchInstructionVisitor;
    private final InstructionVisitor extraDeletedInstructionVisitor;
    private final InstructionVisitor extraAddedInstructionVisitor;
    private final PartialEvaluator partialEvaluator;
    private final PartialEvaluator simplePartialEvaluator = new PartialEvaluator();
    private final SideEffectInstructionChecker sideEffectInstructionChecker = new SideEffectInstructionChecker(true);
    private final MyInstructionSimplifier instructionSimplifier = new MyInstructionSimplifier();
    private final MyProducerMarker producerMarker = new MyProducerMarker();
    private final MyStackConsistencyFixer stackConsistencyFixer = new MyStackConsistencyFixer();
    private final CodeAttributeEditor codeAttributeEditor = new CodeAttributeEditor(false);
    private boolean[][] variablesNecessaryAfter = new boolean[1024][64];
    private boolean[][] stacksNecessaryAfter = new boolean[1024][16];
    private boolean[][] stacksSimplifiedBefore = new boolean[1024][16];
    private boolean[] instructionsNecessary = new boolean[1024];
    private boolean[] instructionsSimplified = new boolean[1024];
    private int[] aliasingVariables = new int[1024];
    private int maxMarkedOffset;

    public EvaluationSimplifier() {
        this(new PartialEvaluator(), null, null, null, null);
    }

    public EvaluationSimplifier(PartialEvaluator partialEvaluator, InstructionVisitor instructionVisitor, InstructionVisitor instructionVisitor2, InstructionVisitor instructionVisitor3, InstructionVisitor instructionVisitor4) {
        this.partialEvaluator = partialEvaluator;
        this.extraPushInstructionVisitor = instructionVisitor;
        this.extraBranchInstructionVisitor = instructionVisitor2;
        this.extraDeletedInstructionVisitor = instructionVisitor3;
        this.extraAddedInstructionVisitor = instructionVisitor4;
    }

    @Override
    public void visitAnyAttribute(Clazz clazz, Attribute attribute) {
    }

    @Override
    public void visitCodeAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute) {
        try {
            this.visitCodeAttribute0(clazz, method, codeAttribute);
        }
        catch (RuntimeException runtimeException) {
            System.err.println("Unexpected error while optimizing after partial evaluation:");
            System.err.println("  Class       = [" + clazz.getName() + "]");
            System.err.println("  Method      = [" + method.getName(clazz) + method.getDescriptor(clazz) + "]");
            System.err.println("  Exception   = [" + runtimeException.getClass().getName() + "] (" + runtimeException.getMessage() + ")");
            System.err.println("Not optimizing this method");
        }
    }

    public void visitCodeAttribute0(Clazz clazz, Method method, CodeAttribute codeAttribute) {
        Instruction instruction;
        int n;
        int n2;
        this.initializeNecessary(codeAttribute);
        this.partialEvaluator.visitCodeAttribute(clazz, method, codeAttribute);
        int n3 = codeAttribute.u4codeLength;
        this.codeAttributeEditor.reset(n3);
        for (n2 = 0; n2 < n3; ++n2) {
            if (!this.partialEvaluator.isTraced(n2)) continue;
            Instruction instruction2 = InstructionFactory.create(codeAttribute.code, n2);
            instruction2.accept(clazz, method, codeAttribute, n2, this.instructionSimplifier);
        }
        this.maxMarkedOffset = -1;
        n2 = this.partialEvaluator.superInitializationOffset();
        if (n2 != -2) {
            this.markInstruction(n2);
        }
        for (n = 0; n < n3; ++n) {
            if (!this.partialEvaluator.isTraced(n)) continue;
            Instruction instruction3 = InstructionFactory.create(codeAttribute.code, n);
            if (instruction3.opcode == -89 && ((BranchInstruction)instruction3).branchOffset == 0) {
                this.markInstruction(n);
                continue;
            }
            if (!this.sideEffectInstructionChecker.hasSideEffects(clazz, method, codeAttribute, n, instruction3)) continue;
            this.markInstruction(n);
        }
        while (this.maxMarkedOffset >= 0) {
            n = this.maxMarkedOffset;
            this.maxMarkedOffset = n - 1;
            if (!this.partialEvaluator.isTraced(n)) continue;
            if (this.isInstructionNecessary(n)) {
                if (this.isInstructionSimplified(n)) {
                    int n4 = this.getAliasingVariable(n);
                    if (n4 >= 0) {
                        this.markVariableProducers(n, n4);
                    }
                } else {
                    Instruction instruction4 = InstructionFactory.create(codeAttribute.code, n);
                    instruction4.accept(clazz, method, codeAttribute, n, this.producerMarker);
                }
            }
            this.markStraddlingBranches(n, this.partialEvaluator.branchTargets(n), true);
            this.markStraddlingBranches(n, this.partialEvaluator.branchOrigins(n), false);
        }
        for (n = 0; n < n3; ++n) {
            int n5;
            if (!this.partialEvaluator.isTraced(n) || this.isInstructionNecessary(n) || (n5 = this.partialEvaluator.initializedVariable(n)) < 0 || !this.isVariableInitializationNecessary(clazz, method, codeAttribute, n, n5)) continue;
            this.markInstruction(n);
        }
        this.maxMarkedOffset = n3 - 1;
        while (this.maxMarkedOffset >= 0) {
            n = this.maxMarkedOffset;
            this.maxMarkedOffset = n - 1;
            if (!this.partialEvaluator.isTraced(n)) continue;
            Instruction instruction5 = InstructionFactory.create(codeAttribute.code, n);
            instruction5.accept(clazz, method, codeAttribute, n, this.stackConsistencyFixer);
            this.markStraddlingBranches(n, this.partialEvaluator.branchTargets(n), true);
            this.markStraddlingBranches(n, this.partialEvaluator.branchOrigins(n), false);
        }
        for (n = 0; n < n3; ++n) {
            if (!this.partialEvaluator.isTraced(n) || this.isInstructionNecessary(n) || !this.isAllSmallerThanOrEqual(this.partialEvaluator.branchTargets(n), n) || this.isAnyUnnecessaryInstructionBranchingOver(this.lastNecessaryInstructionOffset(n), n)) continue;
            Instruction instruction6 = InstructionFactory.create(codeAttribute.code, n);
            this.replaceByInfiniteLoop(clazz, n, instruction6);
        }
        n = 0;
        do {
            instruction = InstructionFactory.create(codeAttribute.code, n);
            if (this.isInstructionNecessary(n)) continue;
            this.codeAttributeEditor.deleteInstruction(n);
            this.codeAttributeEditor.insertBeforeInstruction(n, null);
            this.codeAttributeEditor.replaceInstruction(n, null);
            this.codeAttributeEditor.insertAfterInstruction(n, null);
            if (this.extraDeletedInstructionVisitor == null) continue;
            instruction.accept(clazz, method, codeAttribute, n, this.extraDeletedInstructionVisitor);
        } while ((n += instruction.length(n)) < n3);
        this.codeAttributeEditor.visitCodeAttribute(clazz, method, codeAttribute);
    }

    private void markVariableProducers(int n, int n2) {
        TracedVariables tracedVariables = this.partialEvaluator.getVariablesBefore(n);
        this.markVariableProducers(tracedVariables.getProducerValue(n2).instructionOffsetValue(), n2);
    }

    private void markVariableProducers(InstructionOffsetValue instructionOffsetValue, int n) {
        if (instructionOffsetValue != null) {
            int n2 = instructionOffsetValue.instructionOffsetCount();
            for (int i = 0; i < n2; ++i) {
                int n3 = instructionOffsetValue.instructionOffset(i);
                this.markVariableAfter(n3, n);
                this.markInstruction(n3);
            }
        }
    }

    private void markStackProducers(Clazz clazz, int n, Instruction instruction) {
        int n2 = instruction.stackPopCount(clazz);
        for (int i = 0; i < n2; ++i) {
            this.markStackEntryProducers(n, i);
        }
    }

    private void conditionallyMarkStackEntryProducers(int n, int n2, int n3) {
        int n4 = this.partialEvaluator.getStackAfter(n).size() - 1;
        if (this.isStackEntryNecessaryAfter(n, n4 - n2)) {
            this.markStackEntryProducers(n, n3);
        }
    }

    private void markStackEntryProducers(int n, int n2) {
        TracedStack tracedStack = this.partialEvaluator.getStackBefore(n);
        int n3 = tracedStack.size() - 1 - n2;
        if (!this.isStackSimplifiedBefore(n, n3)) {
            this.markStackEntryProducers(tracedStack.getTopProducerValue(n2).instructionOffsetValue(), n3);
        }
    }

    private void markStackEntryProducers(InstructionOffsetValue instructionOffsetValue, int n) {
        if (instructionOffsetValue != null) {
            int n2 = instructionOffsetValue.instructionOffsetCount();
            for (int i = 0; i < n2; ++i) {
                int n3 = instructionOffsetValue.instructionOffset(i);
                this.markStackEntryAfter(n3, n);
                this.markInstruction(n3);
            }
        }
    }

    private void markInitialization(int n) {
        int n2 = this.partialEvaluator.initializationOffset(n);
        TracedStack tracedStack = this.partialEvaluator.getStackAfter(n);
        this.markStackEntryAfter(n2, tracedStack.size() - 1);
        this.markInstruction(n2);
    }

    private void markStraddlingBranches(int n, InstructionOffsetValue instructionOffsetValue, boolean bl) {
        if (instructionOffsetValue != null) {
            int n2 = instructionOffsetValue.instructionOffsetCount();
            for (int i = 0; i < n2; ++i) {
                int n3 = instructionOffsetValue.instructionOffset(i);
                if (bl) {
                    this.markStraddlingBranch(n, n3, n, n3);
                    continue;
                }
                this.markStraddlingBranch(n, n3, n3, n);
            }
        }
    }

    private void markStraddlingBranch(int n, int n2, int n3, int n4) {
        if (!this.isInstructionNecessary(n3) && this.isAnyInstructionNecessary(n, n2)) {
            this.markInstruction(n3);
        }
    }

    private void fixDupInstruction(Clazz clazz, CodeAttribute codeAttribute, int n, Instruction instruction) {
        int n2 = this.partialEvaluator.getStackAfter(n).size() - 1;
        int n3 = instruction.opcode;
        int n4 = 0;
        switch (n3) {
            case 89: {
                boolean bl = this.isStackEntryNecessaryAfter(n, n2 - 0);
                boolean bl2 = this.isStackEntryNecessaryAfter(n, n2 - 1);
                if (!bl && !bl2 || !bl || !bl2) break;
                n4 = 89;
                break;
            }
            case 90: {
                int n5;
                boolean bl = this.isStackEntryNecessaryAfter(n, n2 - 0);
                boolean bl3 = this.isStackEntryNecessaryAfter(n, n2 - 1);
                boolean bl4 = this.isStackEntryNecessaryAfter(n, n2 - 2);
                if (!bl && !bl4 || !bl4) break;
                int n6 = n5 = bl3 ? 1 : 0;
                if (bl) {
                    n4 = (byte)(89 + n5);
                    break;
                }
                if (n5 != 1) break;
                n4 = 95;
                break;
            }
            case 91: {
                boolean bl = this.isStackEntryNecessaryAfter(n, n2 - 0);
                boolean bl5 = this.isStackEntryNecessaryAfter(n, n2 - 1);
                boolean bl6 = this.isStackEntryNecessaryAfter(n, n2 - 2);
                boolean bl7 = this.isStackEntryNecessaryAfter(n, n2 - 3);
                if (!bl && !bl7 || !bl7) break;
                int n7 = (bl5 ? 1 : 0) + (bl6 ? 1 : 0);
                if (bl) {
                    n4 = (byte)(89 + n7);
                    break;
                }
                if (n7 == 1) {
                    n4 = 95;
                    break;
                }
                if (n7 != 2) break;
                throw new UnsupportedOperationException("Can't handle dup_x2 instruction moving original element across two elements at [" + n + "]");
            }
            case 92: {
                boolean bl = this.isStackEntriesNecessaryAfter(n, n2 - 0, n2 - 1);
                boolean bl8 = this.isStackEntriesNecessaryAfter(n, n2 - 2, n2 - 3);
                if (!bl && !bl8 || !bl || !bl8) break;
                n4 = 92;
                break;
            }
            case 93: {
                int n8;
                boolean bl = this.isStackEntriesNecessaryAfter(n, n2 - 0, n2 - 1);
                boolean bl9 = this.isStackEntryNecessaryAfter(n, n2 - 2);
                boolean bl10 = this.isStackEntriesNecessaryAfter(n, n2 - 3, n2 - 4);
                if (!bl && !bl10 || !bl10) break;
                int n9 = n8 = bl9 ? 1 : 0;
                if (bl) {
                    n4 = (byte)(92 + n8);
                    break;
                }
                if (n8 <= 0) break;
                throw new UnsupportedOperationException("Can't handle dup2_x1 instruction moving original element across " + n8 + " elements at [" + n + "]");
            }
            case 94: {
                boolean bl = this.isStackEntriesNecessaryAfter(n, n2 - 0, n2 - 1);
                boolean bl11 = this.isStackEntryNecessaryAfter(n, n2 - 2);
                boolean bl12 = this.isStackEntryNecessaryAfter(n, n2 - 3);
                boolean bl13 = this.isStackEntriesNecessaryAfter(n, n2 - 4, n2 - 5);
                if (!bl && !bl13 || !bl13) break;
                int n10 = (bl11 ? 1 : 0) + (bl12 ? 1 : 0);
                if (bl) {
                    n4 = (byte)(92 + n10);
                    break;
                }
                if (n10 <= 0) break;
                throw new UnsupportedOperationException("Can't handle dup2_x2 instruction moving original element across " + n10 + " elements at [" + n + "]");
            }
            case 95: {
                boolean bl = this.isStackEntryNecessaryAfter(n, n2 - 0);
                boolean bl14 = this.isStackEntryNecessaryAfter(n, n2 - 1);
                if (!bl && !bl14 || !bl || !bl14) break;
                n4 = 95;
                break;
            }
        }
        if (n4 == 0) {
            this.codeAttributeEditor.deleteInstruction(n);
            if (this.extraDeletedInstructionVisitor != null) {
                this.extraDeletedInstructionVisitor.visitSimpleInstruction(null, null, null, n, null);
            }
        } else if (n4 == n3) {
            this.codeAttributeEditor.undeleteInstruction(n);
        } else {
            SimpleInstruction simpleInstruction = new SimpleInstruction((byte)n4);
            this.codeAttributeEditor.replaceInstruction(n, simpleInstruction);
        }
    }

    private void increaseStackSize(int n, int n2, boolean bl) {
        this.markInstruction(n);
        SimpleInstruction simpleInstruction = new SimpleInstruction(this.pushOpcode(n2));
        if (bl) {
            this.codeAttributeEditor.replaceInstruction(n, simpleInstruction);
        } else {
            this.codeAttributeEditor.insertBeforeInstruction(n, simpleInstruction);
            if (this.extraAddedInstructionVisitor != null) {
                ((Instruction)simpleInstruction).accept(null, null, null, n, this.extraAddedInstructionVisitor);
            }
        }
    }

    private byte pushOpcode(int n) {
        switch (n) {
            case 1: {
                return 3;
            }
            case 2: {
                return 9;
            }
            case 3: {
                return 11;
            }
            case 4: {
                return 14;
            }
            case 5: 
            case 6: {
                return 1;
            }
        }
        throw new IllegalArgumentException("No push opcode for computational type [" + n + "]");
    }

    private void decreaseStackSize(int n, int n2, boolean bl, boolean bl2) {
        SimpleInstruction simpleInstruction;
        byte by;
        int n3;
        this.markInstruction(n);
        boolean bl3 = !bl;
        int n4 = n2;
        if (bl2) {
            n3 = n4 == 1 ? 1 : 2;
            by = n3 == 1 ? (byte)87 : 88;
            simpleInstruction = new SimpleInstruction(by);
            this.codeAttributeEditor.replaceInstruction(n, simpleInstruction);
            n4 -= n3;
            bl = true;
            bl3 = true;
        }
        if (bl && n4 > 0) {
            n3 = n4 == 1 ? 1 : 2;
            by = n3 == 1 ? (byte)87 : 88;
            simpleInstruction = new SimpleInstruction(by);
            this.codeAttributeEditor.insertBeforeInstruction(n, simpleInstruction);
            n4 -= n3;
            if (this.extraAddedInstructionVisitor != null) {
                ((Instruction)simpleInstruction).accept(null, null, null, n, this.extraAddedInstructionVisitor);
            }
        }
        if (bl3 && n4 > 0) {
            n3 = n4 == 1 ? 1 : 2;
            by = n3 == 1 ? (byte)87 : 88;
            simpleInstruction = new SimpleInstruction(by);
            this.codeAttributeEditor.insertAfterInstruction(n, simpleInstruction);
            n4 -= n3;
            if (this.extraAddedInstructionVisitor != null) {
                ((Instruction)simpleInstruction).accept(null, null, null, n, this.extraAddedInstructionVisitor);
            }
        }
        if (n4 > 0) {
            throw new UnsupportedOperationException("Unsupported stack size reduction [" + n2 + "]");
        }
    }

    private void replaceAnyPushInstruction(Clazz clazz, int n, Instruction instruction) {
        Value value = this.partialEvaluator.getStackAfter(n).getTop(0);
        if (value.isParticular()) {
            switch (value.computationalType()) {
                case 1: {
                    this.replaceIntegerPushInstruction(clazz, n, instruction);
                    break;
                }
                case 2: {
                    this.replaceLongPushInstruction(clazz, n, instruction);
                    break;
                }
                case 3: {
                    this.replaceFloatPushInstruction(clazz, n, instruction);
                    break;
                }
                case 4: {
                    this.replaceDoublePushInstruction(clazz, n, instruction);
                    break;
                }
                case 5: {
                    this.replaceReferencePushInstruction(clazz, n, instruction);
                }
            }
        }
    }

    private void replaceIntegerPushInstruction(Clazz clazz, int n, Instruction instruction) {
        this.replaceIntegerPushInstruction(clazz, n, instruction, this.partialEvaluator.getVariablesBefore(n).size());
    }

    private void replaceIntegerPushInstruction(Clazz clazz, int n, Instruction instruction, int n2) {
        Value value = this.partialEvaluator.getStackAfter(n).getTop(0);
        if (value.isParticular()) {
            int n3 = value.integerValue().value();
            if (n3 << 16 >> 16 == n3) {
                this.replaceConstantPushInstruction(clazz, n, instruction, (byte)17, n3);
            }
        } else if (value.isSpecific()) {
            TracedVariables tracedVariables = this.partialEvaluator.getVariablesBefore(n);
            for (int i = 0; i < n2; ++i) {
                if (!value.equals(tracedVariables.load(i))) continue;
                this.replaceVariablePushInstruction(clazz, n, instruction, (byte)21, i);
            }
        }
    }

    private void replaceLongPushInstruction(Clazz clazz, int n, Instruction instruction) {
        this.replaceLongPushInstruction(clazz, n, instruction, this.partialEvaluator.getVariablesBefore(n).size());
    }

    private void replaceLongPushInstruction(Clazz clazz, int n, Instruction instruction, int n2) {
        Value value = this.partialEvaluator.getStackAfter(n).getTop(0);
        if (value.isParticular()) {
            long l = value.longValue().value();
            if (l == 0L || l == 1L) {
                this.replaceConstantPushInstruction(clazz, n, instruction, (byte)9, (int)l);
            }
        } else if (value.isSpecific()) {
            TracedVariables tracedVariables = this.partialEvaluator.getVariablesBefore(n);
            for (int i = 0; i < n2; ++i) {
                if (!value.equals(tracedVariables.load(i))) continue;
                this.replaceVariablePushInstruction(clazz, n, instruction, (byte)22, i);
            }
        }
    }

    private void replaceFloatPushInstruction(Clazz clazz, int n, Instruction instruction) {
        this.replaceFloatPushInstruction(clazz, n, instruction, this.partialEvaluator.getVariablesBefore(n).size());
    }

    private void replaceFloatPushInstruction(Clazz clazz, int n, Instruction instruction, int n2) {
        Value value = this.partialEvaluator.getStackAfter(n).getTop(0);
        if (value.isParticular()) {
            float f = value.floatValue().value();
            if (f == 0.0f || f == 1.0f || f == 2.0f) {
                this.replaceConstantPushInstruction(clazz, n, instruction, (byte)11, (int)f);
            }
        } else if (value.isSpecific()) {
            TracedVariables tracedVariables = this.partialEvaluator.getVariablesBefore(n);
            for (int i = 0; i < n2; ++i) {
                if (!value.equals(tracedVariables.load(i))) continue;
                this.replaceVariablePushInstruction(clazz, n, instruction, (byte)23, i);
            }
        }
    }

    private void replaceDoublePushInstruction(Clazz clazz, int n, Instruction instruction) {
        this.replaceDoublePushInstruction(clazz, n, instruction, this.partialEvaluator.getVariablesBefore(n).size());
    }

    private void replaceDoublePushInstruction(Clazz clazz, int n, Instruction instruction, int n2) {
        Value value = this.partialEvaluator.getStackAfter(n).getTop(0);
        if (value.isParticular()) {
            double d = value.doubleValue().value();
            if (d == 0.0 || d == 1.0) {
                this.replaceConstantPushInstruction(clazz, n, instruction, (byte)14, (int)d);
            }
        } else if (value.isSpecific()) {
            TracedVariables tracedVariables = this.partialEvaluator.getVariablesBefore(n);
            for (int i = 0; i < n2; ++i) {
                if (!value.equals(tracedVariables.load(i))) continue;
                this.replaceVariablePushInstruction(clazz, n, instruction, (byte)24, i);
            }
        }
    }

    private void replaceReferencePushInstruction(Clazz clazz, int n, Instruction instruction) {
        Value value = this.partialEvaluator.getStackAfter(n).getTop(0);
        if (value.isParticular()) {
            this.replaceConstantPushInstruction(clazz, n, instruction, (byte)1, 0);
        }
    }

    private void replaceConstantPushInstruction(Clazz clazz, int n, Instruction instruction, byte by, int n2) {
        this.replacePushInstruction(clazz, n, instruction, new SimpleInstruction(by, n2).shrink());
    }

    private void replaceVariablePushInstruction(Clazz clazz, int n, Instruction instruction, byte by, int n2) {
        this.replacePushInstruction(clazz, n, instruction, new VariableInstruction(by, n2).shrink());
        this.setAliasingVariable(n, n2);
    }

    private void replacePushInstruction(Clazz clazz, int n, Instruction instruction, Instruction instruction2) {
        this.codeAttributeEditor.replaceInstruction(n, instruction2);
        this.markSimplification(clazz, n, instruction);
        if (this.extraPushInstructionVisitor != null) {
            this.extraPushInstructionVisitor.visitSimpleInstruction(null, null, null, n, null);
        }
    }

    private void replaceInvocationInstruction(Clazz clazz, int n, ConstantInstruction constantInstruction) {
        Instruction instruction = new ConstantInstruction(-72, constantInstruction.constantIndex).shrink();
        this.codeAttributeEditor.replaceInstruction(n, instruction);
    }

    private void replaceJsrInstruction(Clazz clazz, int n, BranchInstruction branchInstruction) {
        if (!this.partialEvaluator.isSubroutineReturning(n + branchInstruction.branchOffset)) {
            this.replaceBranchInstruction(clazz, n, branchInstruction);
        } else if (!this.partialEvaluator.isTraced(n + branchInstruction.length(n))) {
            this.replaceByInfiniteLoop(clazz, n + branchInstruction.length(n), branchInstruction);
        }
    }

    private void replaceBranchInstruction(Clazz clazz, int n, Instruction instruction) {
        int n2;
        InstructionOffsetValue instructionOffsetValue = this.partialEvaluator.branchTargets(n);
        if (instructionOffsetValue != null && instructionOffsetValue.instructionOffsetCount() == 1 && (n2 = instructionOffsetValue.instructionOffset(0) - n) != instruction.length(n)) {
            Instruction instruction2 = new BranchInstruction(-56, n2).shrink();
            this.codeAttributeEditor.replaceInstruction(n, instruction2);
            this.markSimplification(clazz, n, instruction);
            if (this.extraBranchInstructionVisitor != null) {
                this.extraBranchInstructionVisitor.visitBranchInstruction(null, null, null, n, null);
            }
        }
    }

    private void replaceSwitchInstruction(Clazz clazz, int n, SwitchInstruction switchInstruction) {
        InstructionOffsetValue instructionOffsetValue = this.partialEvaluator.branchTargets(n);
        int n2 = instructionOffsetValue.instructionOffset(instructionOffsetValue.instructionOffsetCount() - 1) - n;
        SwitchInstruction switchInstruction2 = null;
        int[] nArray = switchInstruction.jumpOffsets;
        for (int i = 0; i < nArray.length; ++i) {
            if (instructionOffsetValue.contains(n + nArray[i])) continue;
            nArray[i] = n2;
            switchInstruction2 = switchInstruction;
        }
        if (!instructionOffsetValue.contains(n + switchInstruction.defaultOffset)) {
            switchInstruction.defaultOffset = n2;
            switchInstruction2 = switchInstruction;
        }
        if (switchInstruction2 != null) {
            this.codeAttributeEditor.replaceInstruction(n, switchInstruction2);
            if (this.extraBranchInstructionVisitor != null) {
                this.extraBranchInstructionVisitor.visitBranchInstruction(null, null, null, n, null);
            }
        }
    }

    private void replaceByInfiniteLoop(Clazz clazz, int n, Instruction instruction) {
        BranchInstruction branchInstruction = new BranchInstruction(-89, 0);
        this.codeAttributeEditor.replaceInstruction(n, branchInstruction);
        this.markInstruction(n);
        this.markSimplification(clazz, n, instruction);
    }

    private boolean isDupOrSwap(Instruction instruction) {
        return instruction.opcode >= 89 && instruction.opcode <= 95;
    }

    private boolean isPop(Instruction instruction) {
        return instruction.opcode == 87 || instruction.opcode == 88;
    }

    private boolean isAnyUnnecessaryInstructionBranchingOver(int n, int n2) {
        for (int i = n; i < n2; ++i) {
            if (!this.partialEvaluator.isTraced(i) || this.isInstructionNecessary(i) || !this.isAnyLargerThan(this.partialEvaluator.branchTargets(i), n2)) continue;
            return true;
        }
        return false;
    }

    private boolean isAllSmallerThanOrEqual(InstructionOffsetValue instructionOffsetValue, int n) {
        int n2;
        if (instructionOffsetValue != null && (n2 = instructionOffsetValue.instructionOffsetCount()) > 0) {
            for (int i = 0; i < n2; ++i) {
                if (instructionOffsetValue.instructionOffset(i) <= n) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private boolean isAnyLargerThan(InstructionOffsetValue instructionOffsetValue, int n) {
        int n2;
        if (instructionOffsetValue != null && (n2 = instructionOffsetValue.instructionOffsetCount()) > 0) {
            for (int i = 0; i < n2; ++i) {
                if (instructionOffsetValue.instructionOffset(i) <= n) continue;
                return true;
            }
        }
        return false;
    }

    private void initializeNecessary(CodeAttribute codeAttribute) {
        int n;
        int n2;
        int n3 = codeAttribute.u4codeLength;
        int n4 = codeAttribute.u2maxLocals;
        int n5 = codeAttribute.u2maxStack;
        if (this.variablesNecessaryAfter.length < n3 || this.variablesNecessaryAfter[0].length < n4) {
            this.variablesNecessaryAfter = new boolean[n3][n4];
        } else {
            for (n2 = 0; n2 < n3; ++n2) {
                for (n = 0; n < n4; ++n) {
                    this.variablesNecessaryAfter[n2][n] = false;
                }
            }
        }
        if (this.stacksNecessaryAfter.length < n3 || this.stacksNecessaryAfter[0].length < n5) {
            this.stacksNecessaryAfter = new boolean[n3][n5];
        } else {
            for (n2 = 0; n2 < n3; ++n2) {
                for (n = 0; n < n5; ++n) {
                    this.stacksNecessaryAfter[n2][n] = false;
                }
            }
        }
        if (this.stacksSimplifiedBefore.length < n3 || this.stacksSimplifiedBefore[0].length < n5) {
            this.stacksSimplifiedBefore = new boolean[n3][n5];
        } else {
            for (n2 = 0; n2 < n3; ++n2) {
                for (n = 0; n < n5; ++n) {
                    this.stacksSimplifiedBefore[n2][n] = false;
                }
            }
        }
        if (this.instructionsNecessary.length < n3) {
            this.instructionsNecessary = new boolean[n3];
            this.instructionsSimplified = new boolean[n3];
            this.aliasingVariables = new int[n3];
        } else {
            for (n2 = 0; n2 < n3; ++n2) {
                this.instructionsNecessary[n2] = false;
                this.instructionsSimplified[n2] = false;
            }
        }
        for (n2 = 0; n2 < n3; ++n2) {
            this.aliasingVariables[n2] = -1;
        }
    }

    private boolean isStackEntriesNecessaryAfter(int n, int n2, int n3) {
        boolean bl = this.isStackEntryNecessaryAfter(n, n2);
        boolean bl2 = this.isStackEntryNecessaryAfter(n, n3);
        return bl || bl2;
    }

    private boolean isVariableInitializationNecessary(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, int n2) {
        int n3 = codeAttribute.u4codeLength;
        if (this.isVariableNecessaryAfterAny(0, n3, n2)) {
            this.simplePartialEvaluator.visitCodeAttribute(clazz, method, codeAttribute);
            for (int i = 0; i < n3; ++i) {
                Value value;
                Value value2;
                if (!this.isInstructionNecessary(i) || (value2 = this.partialEvaluator.getVariablesBefore(i).getProducerValue(n2)) == null || (value = this.simplePartialEvaluator.getVariablesBefore(i).getProducerValue(n2)) == null) continue;
                InstructionOffsetValue instructionOffsetValue = value2.instructionOffsetValue();
                InstructionOffsetValue instructionOffsetValue2 = value.instructionOffsetValue();
                if (instructionOffsetValue.instructionOffsetCount() >= instructionOffsetValue2.instructionOffsetCount() || !this.isVariableNecessaryAfterAny(instructionOffsetValue, n2) || !instructionOffsetValue2.contains(n)) continue;
                return true;
            }
        }
        return false;
    }

    private void markVariableAfter(int n, int n2) {
        if (!this.isVariableNecessaryAfter(n, n2)) {
            this.variablesNecessaryAfter[n][n2] = true;
            if (this.maxMarkedOffset < n) {
                this.maxMarkedOffset = n;
            }
        }
    }

    private boolean isVariableNecessaryAfterAny(int n, int n2, int n3) {
        for (int i = n; i < n2; ++i) {
            if (!this.isVariableNecessaryAfter(i, n3)) continue;
            return true;
        }
        return false;
    }

    private boolean isVariableNecessaryAfterAny(InstructionOffsetValue instructionOffsetValue, int n) {
        int n2 = instructionOffsetValue.instructionOffsetCount();
        for (int i = 0; i < n2; ++i) {
            if (!this.isVariableNecessaryAfter(instructionOffsetValue.instructionOffset(i), n)) continue;
            return true;
        }
        return false;
    }

    private boolean isVariableNecessaryAfter(int n, int n2) {
        return n == -1 || this.variablesNecessaryAfter[n][n2];
    }

    private void markStackEntryAfter(int n, int n2) {
        if (!this.isStackEntryNecessaryAfter(n, n2)) {
            this.stacksNecessaryAfter[n][n2] = true;
            if (this.maxMarkedOffset < n) {
                this.maxMarkedOffset = n;
            }
        }
    }

    private boolean isAnyStackEntryNecessaryAfter(InstructionOffsetValue instructionOffsetValue, int n) {
        int n2 = instructionOffsetValue.instructionOffsetCount();
        for (int i = 0; i < n2; ++i) {
            if (!this.isStackEntryNecessaryAfter(instructionOffsetValue.instructionOffset(i), n)) continue;
            return true;
        }
        return false;
    }

    private boolean isStackEntryNecessaryAfter(int n, int n2) {
        return n == -1 || this.stacksNecessaryAfter[n][n2];
    }

    private void markStackSimplificationBefore(int n, int n2) {
        this.stacksSimplifiedBefore[n][n2] = true;
    }

    private boolean isStackSimplifiedBefore(int n, int n2) {
        return this.stacksSimplifiedBefore[n][n2];
    }

    private void markSimplification(Clazz clazz, int n, Instruction instruction) {
        this.instructionsSimplified[n] = true;
        TracedStack tracedStack = this.partialEvaluator.getStackBefore(n);
        int n2 = tracedStack.size() - 1;
        int n3 = instruction.stackPopCount(clazz);
        for (int i = 0; i < n3; ++i) {
            this.markStackSimplificationBefore(n, n2 - i);
        }
    }

    private boolean isInstructionSimplified(int n) {
        return this.instructionsSimplified[n];
    }

    private void setAliasingVariable(int n, int n2) {
        this.aliasingVariables[n] = n2;
    }

    private int getAliasingVariable(int n) {
        return this.aliasingVariables[n];
    }

    private void markInstruction(int n) {
        if (!this.isInstructionNecessary(n)) {
            this.instructionsNecessary[n] = true;
            if (this.maxMarkedOffset < n) {
                this.maxMarkedOffset = n;
            }
        }
    }

    private boolean isAnyInstructionNecessary(int n, int n2) {
        for (int i = n; i < n2; ++i) {
            if (!this.isInstructionNecessary(i)) continue;
            return true;
        }
        return false;
    }

    private int lastNecessaryInstructionOffset(int n) {
        for (int i = n - 1; i >= 0; --i) {
            if (!this.isInstructionNecessary(n)) continue;
            return i;
        }
        return 0;
    }

    private boolean isInstructionNecessary(int n) {
        return n == -1 || this.instructionsNecessary[n];
    }

    private class MyStackConsistencyFixer
    extends SimplifiedVisitor
    implements InstructionVisitor {
        private MyStackConsistencyFixer() {
        }

        @Override
        public void visitAnyInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, Instruction instruction) {
            if (EvaluationSimplifier.this.isInstructionNecessary(n)) {
                int n2;
                int n3;
                int n4;
                int n5 = instruction.stackPopCount(clazz);
                if (n5 > 0) {
                    TracedStack tracedStack = EvaluationSimplifier.this.partialEvaluator.getStackBefore(n);
                    int n6 = tracedStack.size() - 1;
                    n4 = 0;
                    for (n3 = 0; n3 < n5; ++n3) {
                        if (EvaluationSimplifier.this.isStackSimplifiedBefore(n, n6 - n3) || EvaluationSimplifier.this.isAnyStackEntryNecessaryAfter(tracedStack.getTopProducerValue(n3).instructionOffsetValue(), n6 - n3)) continue;
                        ++n4;
                    }
                    if (n4 > 0) {
                        if (n4 > (instruction.isCategory2() ? 2 : 1)) {
                            throw new IllegalArgumentException("Unsupported stack size increment [" + n4 + "]");
                        }
                        EvaluationSimplifier.this.increaseStackSize(n, tracedStack.getTop(0).computationalType(), false);
                    }
                }
                if ((n2 = instruction.stackPushCount(clazz)) > 0) {
                    TracedStack tracedStack = EvaluationSimplifier.this.partialEvaluator.getStackAfter(n);
                    n4 = tracedStack.size() - 1;
                    n3 = 0;
                    for (int i = 0; i < n2; ++i) {
                        if (EvaluationSimplifier.this.isStackEntryNecessaryAfter(n, n4 - i)) continue;
                        ++n3;
                    }
                    if (n3 > 0) {
                        EvaluationSimplifier.this.decreaseStackSize(n, n3, false, false);
                    }
                }
            } else {
                int n7;
                int n8;
                int n9;
                int n10 = instruction.stackPopCount(clazz);
                if (n10 > 0) {
                    TracedStack tracedStack = EvaluationSimplifier.this.partialEvaluator.getStackBefore(n);
                    int n11 = tracedStack.size() - 1;
                    n9 = 0;
                    for (n8 = 0; n8 < n10; ++n8) {
                        if (!EvaluationSimplifier.this.isAnyStackEntryNecessaryAfter(tracedStack.getTopProducerValue(n8).instructionOffsetValue(), n11 - n8)) continue;
                        ++n9;
                    }
                    if (n9 > 0) {
                        EvaluationSimplifier.this.decreaseStackSize(n, n9, true, true);
                    }
                }
                if ((n7 = instruction.stackPushCount(clazz)) > 0) {
                    TracedStack tracedStack = EvaluationSimplifier.this.partialEvaluator.getStackAfter(n);
                    n9 = tracedStack.size() - 1;
                    n8 = 0;
                    for (int i = 0; i < n7; ++i) {
                        if (!EvaluationSimplifier.this.isStackEntryNecessaryAfter(n, n9 - i)) continue;
                        ++n8;
                    }
                    if (n8 > 0) {
                        EvaluationSimplifier.this.increaseStackSize(n, tracedStack.getTop(0).computationalType(), true);
                    }
                }
            }
        }

        @Override
        public void visitSimpleInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, SimpleInstruction simpleInstruction) {
            if (EvaluationSimplifier.this.isInstructionNecessary(n) && EvaluationSimplifier.this.isDupOrSwap(simpleInstruction)) {
                EvaluationSimplifier.this.fixDupInstruction(clazz, codeAttribute, n, simpleInstruction);
            } else {
                this.visitAnyInstruction(clazz, method, codeAttribute, n, simpleInstruction);
            }
        }
    }

    private class MyProducerMarker
    extends SimplifiedVisitor
    implements InstructionVisitor {
        private MyProducerMarker() {
        }

        @Override
        public void visitAnyInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, Instruction instruction) {
            EvaluationSimplifier.this.markStackProducers(clazz, n, instruction);
        }

        @Override
        public void visitSimpleInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, SimpleInstruction simpleInstruction) {
            switch (simpleInstruction.opcode) {
                case 89: {
                    EvaluationSimplifier.this.conditionallyMarkStackEntryProducers(n, 0, 0);
                    EvaluationSimplifier.this.conditionallyMarkStackEntryProducers(n, 1, 0);
                    break;
                }
                case 90: {
                    EvaluationSimplifier.this.conditionallyMarkStackEntryProducers(n, 0, 0);
                    EvaluationSimplifier.this.conditionallyMarkStackEntryProducers(n, 1, 1);
                    EvaluationSimplifier.this.conditionallyMarkStackEntryProducers(n, 2, 0);
                    break;
                }
                case 91: {
                    EvaluationSimplifier.this.conditionallyMarkStackEntryProducers(n, 0, 0);
                    EvaluationSimplifier.this.conditionallyMarkStackEntryProducers(n, 1, 1);
                    EvaluationSimplifier.this.conditionallyMarkStackEntryProducers(n, 2, 2);
                    EvaluationSimplifier.this.conditionallyMarkStackEntryProducers(n, 3, 0);
                    break;
                }
                case 92: {
                    EvaluationSimplifier.this.conditionallyMarkStackEntryProducers(n, 0, 0);
                    EvaluationSimplifier.this.conditionallyMarkStackEntryProducers(n, 1, 1);
                    EvaluationSimplifier.this.conditionallyMarkStackEntryProducers(n, 2, 0);
                    EvaluationSimplifier.this.conditionallyMarkStackEntryProducers(n, 3, 1);
                    break;
                }
                case 93: {
                    EvaluationSimplifier.this.conditionallyMarkStackEntryProducers(n, 0, 0);
                    EvaluationSimplifier.this.conditionallyMarkStackEntryProducers(n, 1, 1);
                    EvaluationSimplifier.this.conditionallyMarkStackEntryProducers(n, 2, 2);
                    EvaluationSimplifier.this.conditionallyMarkStackEntryProducers(n, 3, 0);
                    EvaluationSimplifier.this.conditionallyMarkStackEntryProducers(n, 4, 1);
                    break;
                }
                case 94: {
                    EvaluationSimplifier.this.conditionallyMarkStackEntryProducers(n, 0, 0);
                    EvaluationSimplifier.this.conditionallyMarkStackEntryProducers(n, 1, 1);
                    EvaluationSimplifier.this.conditionallyMarkStackEntryProducers(n, 2, 2);
                    EvaluationSimplifier.this.conditionallyMarkStackEntryProducers(n, 3, 3);
                    EvaluationSimplifier.this.conditionallyMarkStackEntryProducers(n, 4, 0);
                    EvaluationSimplifier.this.conditionallyMarkStackEntryProducers(n, 5, 1);
                    break;
                }
                case 95: {
                    EvaluationSimplifier.this.conditionallyMarkStackEntryProducers(n, 0, 1);
                    EvaluationSimplifier.this.conditionallyMarkStackEntryProducers(n, 1, 0);
                    break;
                }
                default: {
                    EvaluationSimplifier.this.markStackProducers(clazz, n, simpleInstruction);
                }
            }
        }

        @Override
        public void visitVariableInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, VariableInstruction variableInstruction) {
            if (variableInstruction.opcode < 54) {
                EvaluationSimplifier.this.markVariableProducers(n, variableInstruction.variableIndex);
            } else {
                EvaluationSimplifier.this.markStackProducers(clazz, n, variableInstruction);
            }
        }

        @Override
        public void visitConstantInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, ConstantInstruction constantInstruction) {
            if (constantInstruction.opcode == -69) {
                EvaluationSimplifier.this.markInitialization(n);
            }
            EvaluationSimplifier.this.markStackProducers(clazz, n, constantInstruction);
        }

        @Override
        public void visitBranchInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, BranchInstruction branchInstruction) {
            if (branchInstruction.opcode == -88 || branchInstruction.opcode == -55) {
                EvaluationSimplifier.this.markStackEntryAfter(n, 0);
            } else {
                EvaluationSimplifier.this.markStackProducers(clazz, n, branchInstruction);
            }
        }
    }

    private class MyUnusedParameterSimplifier
    extends SimplifiedVisitor
    implements MemberVisitor {
        private int invocationOffset;
        private ConstantInstruction invocationInstruction;

        private MyUnusedParameterSimplifier(int n, ConstantInstruction constantInstruction) {
            this.invocationOffset = n;
            this.invocationInstruction = constantInstruction;
        }

        @Override
        public void visitAnyMember(Clazz clazz, Member member) {
        }

        @Override
        public void visitProgramMethod(ProgramClass programClass, ProgramMethod programMethod) {
            int n = ParameterUsageMarker.getParameterSize(programMethod);
            if ((programMethod.getAccessFlags() & 8) == 0 && !ParameterUsageMarker.isParameterUsed(programMethod, 0)) {
                EvaluationSimplifier.this.replaceInvocationInstruction(programClass, this.invocationOffset, this.invocationInstruction);
            }
            for (int i = 0; i < n; ++i) {
                if (ParameterUsageMarker.isParameterUsed(programMethod, i)) continue;
                TracedStack tracedStack = EvaluationSimplifier.this.partialEvaluator.getStackBefore(this.invocationOffset);
                int n2 = tracedStack.size() - n + i;
                EvaluationSimplifier.this.markStackSimplificationBefore(this.invocationOffset, n2);
            }
        }
    }

    private class MyInstructionSimplifier
    extends SimplifiedVisitor
    implements InstructionVisitor {
        private MyInstructionSimplifier() {
        }

        @Override
        public void visitSimpleInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, SimpleInstruction simpleInstruction) {
            switch (simpleInstruction.opcode) {
                case -128: 
                case -126: 
                case -120: 
                case -117: 
                case -114: 
                case -111: 
                case -110: 
                case -109: 
                case 46: 
                case 51: 
                case 52: 
                case 53: 
                case 96: 
                case 100: 
                case 104: 
                case 108: 
                case 112: 
                case 116: 
                case 120: 
                case 122: 
                case 124: 
                case 126: {
                    EvaluationSimplifier.this.replaceIntegerPushInstruction(clazz, n, simpleInstruction);
                    break;
                }
                case -127: 
                case -125: 
                case -123: 
                case -116: 
                case -113: 
                case 47: 
                case 97: 
                case 101: 
                case 105: 
                case 109: 
                case 113: 
                case 117: 
                case 121: 
                case 123: 
                case 125: 
                case 127: {
                    EvaluationSimplifier.this.replaceLongPushInstruction(clazz, n, simpleInstruction);
                    break;
                }
                case -122: 
                case -119: 
                case -112: 
                case 48: 
                case 98: 
                case 102: 
                case 106: 
                case 110: 
                case 114: 
                case 118: {
                    EvaluationSimplifier.this.replaceFloatPushInstruction(clazz, n, simpleInstruction);
                    break;
                }
                case -121: 
                case -118: 
                case -115: 
                case 49: 
                case 99: 
                case 103: 
                case 107: 
                case 111: 
                case 115: 
                case 119: {
                    EvaluationSimplifier.this.replaceDoublePushInstruction(clazz, n, simpleInstruction);
                    break;
                }
                case 50: {
                    EvaluationSimplifier.this.replaceReferencePushInstruction(clazz, n, simpleInstruction);
                }
            }
        }

        @Override
        public void visitVariableInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, VariableInstruction variableInstruction) {
            int n2 = variableInstruction.variableIndex;
            switch (variableInstruction.opcode) {
                case 21: 
                case 26: 
                case 27: 
                case 28: 
                case 29: {
                    EvaluationSimplifier.this.replaceIntegerPushInstruction(clazz, n, variableInstruction, n2);
                    break;
                }
                case 22: 
                case 30: 
                case 31: 
                case 32: 
                case 33: {
                    EvaluationSimplifier.this.replaceLongPushInstruction(clazz, n, variableInstruction, n2);
                    break;
                }
                case 23: 
                case 34: 
                case 35: 
                case 36: 
                case 37: {
                    EvaluationSimplifier.this.replaceFloatPushInstruction(clazz, n, variableInstruction, n2);
                    break;
                }
                case 24: 
                case 38: 
                case 39: 
                case 40: 
                case 41: {
                    EvaluationSimplifier.this.replaceDoublePushInstruction(clazz, n, variableInstruction, n2);
                    break;
                }
                case 25: 
                case 42: 
                case 43: 
                case 44: 
                case 45: {
                    EvaluationSimplifier.this.replaceReferencePushInstruction(clazz, n, variableInstruction);
                }
            }
        }

        @Override
        public void visitConstantInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, ConstantInstruction constantInstruction) {
            switch (constantInstruction.opcode) {
                case -78: 
                case -76: {
                    EvaluationSimplifier.this.replaceAnyPushInstruction(clazz, n, constantInstruction);
                    break;
                }
                case -74: 
                case -73: 
                case -72: 
                case -71: {
                    clazz.constantPoolEntryAccept(constantInstruction.constantIndex, new ReferencedMemberVisitor(new MyUnusedParameterSimplifier(n, constantInstruction)));
                    if (constantInstruction.stackPushCount(clazz) <= 0 || EvaluationSimplifier.this.sideEffectInstructionChecker.hasSideEffects(clazz, method, codeAttribute, n, constantInstruction)) break;
                    EvaluationSimplifier.this.replaceAnyPushInstruction(clazz, n, constantInstruction);
                    break;
                }
                case -64: {
                    EvaluationSimplifier.this.replaceReferencePushInstruction(clazz, n, constantInstruction);
                }
            }
        }

        @Override
        public void visitBranchInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, BranchInstruction branchInstruction) {
            switch (branchInstruction.opcode) {
                case -89: 
                case -56: {
                    break;
                }
                case -88: 
                case -55: {
                    EvaluationSimplifier.this.replaceJsrInstruction(clazz, n, branchInstruction);
                    break;
                }
                default: {
                    EvaluationSimplifier.this.replaceBranchInstruction(clazz, n, branchInstruction);
                }
            }
        }

        @Override
        public void visitAnySwitchInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, SwitchInstruction switchInstruction) {
            EvaluationSimplifier.this.replaceBranchInstruction(clazz, n, switchInstruction);
            if (!EvaluationSimplifier.this.isInstructionSimplified(n)) {
                EvaluationSimplifier.this.replaceSwitchInstruction(clazz, n, switchInstruction);
            }
        }
    }
}

