/*
 * Decompiled with CFR 0.152.
 */
package proguard.optimize.info;

import proguard.classfile.Clazz;
import proguard.classfile.LibraryClass;
import proguard.classfile.Method;
import proguard.classfile.ProgramClass;
import proguard.classfile.attribute.CodeAttribute;
import proguard.classfile.constant.ClassConstant;
import proguard.classfile.constant.visitor.ConstantVisitor;
import proguard.classfile.instruction.ConstantInstruction;
import proguard.classfile.instruction.Instruction;
import proguard.classfile.instruction.visitor.InstructionVisitor;
import proguard.classfile.util.SimplifiedVisitor;
import proguard.classfile.visitor.ClassVisitor;
import proguard.optimize.info.ClassOptimizationInfo;

public class InstantiationClassMarker
extends SimplifiedVisitor
implements InstructionVisitor,
ConstantVisitor,
ClassVisitor {
    @Override
    public void visitAnyInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, Instruction instruction) {
    }

    @Override
    public void visitConstantInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, ConstantInstruction constantInstruction) {
        if (constantInstruction.opcode == -69) {
            clazz.constantPoolEntryAccept(constantInstruction.constantIndex, this);
        }
    }

    @Override
    public void visitClassConstant(Clazz clazz, ClassConstant classConstant) {
        classConstant.referencedClassAccept(this);
    }

    @Override
    public void visitLibraryClass(LibraryClass libraryClass) {
    }

    @Override
    public void visitProgramClass(ProgramClass programClass) {
        InstantiationClassMarker.setInstantiated(programClass);
    }

    public static void setInstantiated(Clazz clazz) {
        ClassOptimizationInfo classOptimizationInfo = ClassOptimizationInfo.getClassOptimizationInfo(clazz);
        if (classOptimizationInfo != null) {
            classOptimizationInfo.setInstantiated();
        }
    }

    public static boolean isInstantiated(Clazz clazz) {
        ClassOptimizationInfo classOptimizationInfo = ClassOptimizationInfo.getClassOptimizationInfo(clazz);
        return classOptimizationInfo == null || classOptimizationInfo.isInstantiated();
    }
}

