/*
 * Decompiled with CFR 0.152.
 */
package proguard.optimize.peephole;

import proguard.classfile.ProgramClass;
import proguard.classfile.ProgramField;
import proguard.classfile.ProgramMethod;
import proguard.classfile.util.AccessUtil;
import proguard.classfile.util.SimplifiedVisitor;
import proguard.classfile.visitor.MemberVisitor;
import proguard.optimize.info.NonPrivateMemberMarker;

public class MemberPrivatizer
extends SimplifiedVisitor
implements MemberVisitor {
    private final MemberVisitor extraFieldVisitor;
    private final MemberVisitor extraMethodVisitor;

    public MemberPrivatizer() {
        this(null, null);
    }

    public MemberPrivatizer(MemberVisitor memberVisitor, MemberVisitor memberVisitor2) {
        this.extraFieldVisitor = memberVisitor;
        this.extraMethodVisitor = memberVisitor2;
    }

    @Override
    public void visitProgramField(ProgramClass programClass, ProgramField programField) {
        if (NonPrivateMemberMarker.canBeMadePrivate(programField)) {
            programField.u2accessFlags = AccessUtil.replaceAccessFlags(programField.u2accessFlags, 2);
            if (this.extraFieldVisitor != null) {
                this.extraFieldVisitor.visitProgramField(programClass, programField);
            }
        }
    }

    @Override
    public void visitProgramMethod(ProgramClass programClass, ProgramMethod programMethod) {
        if (NonPrivateMemberMarker.canBeMadePrivate(programMethod)) {
            programMethod.u2accessFlags = AccessUtil.replaceAccessFlags(programMethod.u2accessFlags, 2);
            if (this.extraMethodVisitor != null) {
                this.extraMethodVisitor.visitProgramMethod(programClass, programMethod);
            }
        }
    }
}

