/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.arc.pds.tools.util;

import gov.nasa.arc.pds.tools.container.URLContentsContainer;
import gov.nasa.arc.pds.tools.util.StrUtils;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.List;

public class URLUtils {
    public static final List<String> TEXT_CONTENT_TYPES = new ArrayList<String>();

    public static boolean exists(URI uri) {
        try {
            return URLUtils.exists(uri.toURL());
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            return false;
        }
    }

    public static boolean exists(URL url) {
        HttpURLConnection.setFollowRedirects(false);
        try {
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("HEAD");
            boolean exists = connection.getResponseCode() == 200;
            connection.disconnect();
            return exists;
        }
        catch (IOException connection) {
        }
        catch (ClassCastException e) {
            File file;
            try {
                file = new File(url.toURI());
            }
            catch (URISyntaxException f) {
                file = new File(url.getPath());
            }
            return file.exists();
        }
        return false;
    }

    public static URL getAlternateCaseURL(URL url) {
        try {
            String filename = URLUtils.getFileName(url);
            String parentURL = URLUtils.getParentURLString(url);
            String altFilename = StrUtils.getAlternateCaseString(filename);
            return new URL(parentURL + altFilename);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static URL getCaseUnknownURL(URL url) {
        URL testURL;
        if (!URLUtils.exists(url) && URLUtils.exists(testURL = URLUtils.getAlternateCaseURL(url))) {
            return testURL;
        }
        return url;
    }

    public static URL getCaseUnknownURL(URI root, String path) {
        URL url = null;
        try {
            url = root.toURL();
        }
        catch (MalformedURLException e) {
            return null;
        }
        return URLUtils.getCaseUnknownURL(url, path);
    }

    public static URL getCaseUnknownURL(URL root, String path) {
        URL testURL;
        URL url = null;
        try {
            url = URLUtils.newURL(root, path);
        }
        catch (MalformedURLException e) {
            return null;
        }
        if (!URLUtils.exists(url) && URLUtils.exists(testURL = URLUtils.getAlternateCaseURL(url))) {
            return testURL;
        }
        return url;
    }

    public static String getFileName(String url) {
        URL URLObj = null;
        try {
            URLObj = new URL(url);
        }
        catch (MalformedURLException e) {
            return null;
        }
        return URLUtils.getFileName(URLObj);
    }

    public static String getFileName(URI uri) {
        try {
            return URLUtils.getFileName(uri.toURL());
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    public static String getFileName(URL url) {
        String filename = url.getFile();
        int paramIndex = filename.lastIndexOf("?");
        if (paramIndex != -1) {
            filename = filename.substring(0, paramIndex);
        }
        filename = filename.substring(filename.lastIndexOf("/") + 1, filename.length());
        return filename;
    }

    public static String getParentURLString(URL url) {
        String result;
        String urlString = url.toString();
        int slashIndex = urlString.lastIndexOf("/");
        if (slashIndex != -1 && slashIndex != urlString.length() && (result = urlString.substring(0, slashIndex + 1)).length() > 8) {
            return result;
        }
        return urlString;
    }

    public static URL getParentURL(URL url) {
        try {
            return new URL(URLUtils.getParentURLString(url));
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static URL getParentURL(URI uri) {
        try {
            return URLUtils.getParentURL(uri.toURL());
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static URLContentsContainer getContent(URL url, long maxLength) throws IOException {
        long curLength = 0L;
        int chunkSize = 1024;
        if (maxLength != -1L && maxLength < (long)chunkSize) {
            chunkSize = (int)maxLength;
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        URLConnection connection = url.openConnection();
        connection.setReadTimeout(10000);
        connection.setConnectTimeout(10000);
        BufferedInputStream is = new BufferedInputStream(connection.getInputStream());
        String contentType = URLUtils.getContentType(connection, url, is);
        String charset = URLUtils.getCharset(connection, "ISO-8859-1");
        if (contentType == null || TEXT_CONTENT_TYPES.contains(contentType)) {
            byte[] buf = new byte[chunkSize];
            int amtRead = 0;
            while ((maxLength == -1L || curLength < maxLength) && -1 != (amtRead = ((InputStream)is).read(buf))) {
                curLength += (long)amtRead;
                out.write(buf, 0, amtRead);
            }
            ((InputStream)is).close();
            out.close();
            byte[] response = out.toByteArray();
            return new URLContentsContainer(response, charset);
        }
        ((InputStream)is).close();
        System.out.println(contentType + " cannot be converted to text");
        return null;
    }

    public static URLContentsContainer getContent(URL url) throws IOException {
        return URLUtils.getContent(url, -1L);
    }

    public static String getContentType(URL url) throws IOException {
        URLConnection connection = url.openConnection();
        InputStream is = connection.getInputStream();
        String contentType = URLUtils.getContentType(connection, url, is);
        is.close();
        return contentType;
    }

    public static String getContentType(URLConnection connection, URL url, InputStream is) {
        String contentTypeString = connection.getContentType();
        if (contentTypeString == null) {
            try {
                contentTypeString = URLConnection.guessContentTypeFromStream(is);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (contentTypeString == null) {
            String fileName = URLUtils.getFileName(url);
            contentTypeString = URLConnection.guessContentTypeFromName(fileName);
        }
        if (contentTypeString != null) {
            int sep = contentTypeString.indexOf(";");
            if (sep != -1) {
                return contentTypeString.substring(0, sep);
            }
            contentTypeString.toLowerCase();
        }
        return contentTypeString;
    }

    public static String getCharset(URLConnection connection, String defaultCharset) {
        String contentTypeString = connection.getContentType();
        return URLUtils.getCharset(contentTypeString, defaultCharset);
    }

    public static String getCharset(String contentType, String defaultCharset) {
        int sep;
        if (contentType != null && (sep = contentType.indexOf("charset=")) != -1) {
            return contentType.substring(sep + 8);
        }
        return defaultCharset;
    }

    public static int getContentLength(URL url) {
        int size = -1;
        try {
            URLConnection connection = url.openConnection();
            size = connection.getContentLength();
            connection.getInputStream().close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return size;
    }

    public static URL newURL(URL base, String filename) throws MalformedURLException {
        String baseString = base.toString();
        if (baseString.endsWith("/")) {
            return new URL(base + filename);
        }
        return new URL(base + "/" + filename);
    }

    static {
        TEXT_CONTENT_TYPES.add("text/html");
        TEXT_CONTENT_TYPES.add("text/plain");
    }
}

