/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.pds.label.object;

import gov.nasa.pds.objectAccess.utility.Utility;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import org.apache.commons.compress.utils.BoundedInputStream;
import org.apache.commons.compress.utils.SeekableInMemoryByteChannel;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;

public abstract class DataObject {
    private URL parentDir;
    private gov.nasa.arc.pds.xml.generated.File fileObject;
    private long offset;
    private long size;
    private SeekableByteChannel channel;

    protected DataObject(File parentDir, gov.nasa.arc.pds.xml.generated.File fileObject, long offset, long size) throws IOException {
        this(parentDir.toURI().toURL(), fileObject, offset, size);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DataObject(URL parentDir, gov.nasa.arc.pds.xml.generated.File fileObject, long offset, long size) throws IOException {
        this.parentDir = parentDir;
        this.fileObject = fileObject;
        this.offset = offset;
        this.size = size;
        this.channel = null;
        if (size < 0L) {
            URL u = null;
            URLConnection conn = null;
            try {
                u = this.getDataFile();
                conn = u.openConnection();
                size = conn.getContentLengthLong();
            }
            finally {
                IOUtils.closeQuietly((InputStream)conn.getInputStream());
            }
        }
    }

    public URL getDataFile() throws MalformedURLException {
        return new URL(this.parentDir, this.fileObject.getFileName());
    }

    public long getOffset() {
        return this.offset;
    }

    public long getSize() {
        return this.size;
    }

    protected void setSize(long newSize) {
        this.size = newSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getDataSize(URL u) throws IOException {
        if (this.size >= 0L) {
            return this.size;
        }
        URLConnection conn = null;
        try {
            conn = u.openConnection();
            long l = conn.getContentLengthLong() - this.offset;
            return l;
        }
        finally {
            IOUtils.closeQuietly((InputStream)conn.getInputStream());
        }
    }

    public InputStream getInputStream() throws IOException {
        SeekableByteChannel ch = null;
        ch = this.channel != null ? this.channel : this.getChannel();
        return new BufferedInputStream(Channels.newInputStream(ch));
    }

    public SeekableByteChannel getChannel() throws IOException {
        if (this.channel != null) {
            return this.channel;
        }
        URL u = this.getDataFile();
        long datasize = this.getDataSize(u);
        try {
            this.channel = this.createChannel(u, this.offset, datasize);
        }
        catch (IOException io) {
            throw new IOException("Error reading data file '" + u.toString() + "': " + io.getMessage());
        }
        return this.channel;
    }

    public void closeChannel() {
        try {
            if (this.channel != null) {
                this.channel.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SeekableByteChannel createChannel(URL url, long offset, long size) throws IOException {
        Object createdChannel;
        block9: {
            FileOutputStream fileStream = null;
            Path temp = null;
            int MAX_SIZE = 49941480;
            InputStream input = Utility.openConnection(url.openConnection());
            input.skip(offset);
            createdChannel = null;
            try {
                if (size > 49941480L) {
                    temp = Files.createTempFile(FilenameUtils.getBaseName((String)url.toString()), null, new FileAttribute[0]);
                    temp.toFile().deleteOnExit();
                    ReadableByteChannel channel = Channels.newChannel(input);
                    try {
                        fileStream = new FileOutputStream(temp.toFile());
                        FileChannel fc = fileStream.getChannel();
                        long totalBytesRead = 0L;
                        long bytesRead = fc.transferFrom(channel, 0L, size);
                        if ((totalBytesRead += bytesRead) != size) {
                            do {
                                fc.position(fc.position() + bytesRead);
                            } while ((bytesRead = fc.transferFrom(channel, fc.position(), size)) != 0L && (totalBytesRead += bytesRead) < size);
                            fc.position(0L);
                        }
                        if (totalBytesRead != size) {
                            throw new IOException("Error while copying data object to file '" + temp.toString() + "': Number of bytes read does not match the expected size (got=" + totalBytesRead + ", expected=" + size + ")");
                        }
                    }
                    catch (Throwable throwable) {
                        IOUtils.closeQuietly(fileStream);
                        throw throwable;
                    }
                    IOUtils.closeQuietly((OutputStream)fileStream);
                    createdChannel = Files.newByteChannel(temp, StandardOpenOption.READ, StandardOpenOption.DELETE_ON_CLOSE);
                    break block9;
                }
                BoundedInputStream bis = new BoundedInputStream(input, size);
                createdChannel = new SeekableInMemoryByteChannel(IOUtils.toByteArray((InputStream)bis));
            }
            finally {
                IOUtils.closeQuietly((InputStream)input);
            }
        }
        return createdChannel;
    }
}

