/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.pds.objectAccess.array;

import gov.nasa.pds.objectAccess.array.DataTypeAdapter;
import java.nio.ByteBuffer;

public class IntegerAdapter
implements DataTypeAdapter {
    private static final int BYTE_MASK = 255;
    private int elementSize;
    private boolean isBigEndian;
    private boolean isUnsigned;

    public IntegerAdapter(int elementSize, boolean isBigEndian, boolean isUnsigned) {
        this.elementSize = elementSize;
        this.isBigEndian = isBigEndian;
        this.isUnsigned = isUnsigned;
    }

    @Override
    public int getInt(ByteBuffer buf) {
        long value = this.getValue(buf);
        if (value < Integer.MIN_VALUE || value > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Value out of range for int: " + Long.toString(value));
        }
        return (int)value;
    }

    @Override
    public long getLong(ByteBuffer buf) {
        return this.getValue(buf);
    }

    @Override
    public double getDouble(ByteBuffer buf) {
        return this.getValue(buf);
    }

    private long getValue(ByteBuffer buf) {
        byte[] b = new byte[this.elementSize];
        long value = 0L;
        if (this.isBigEndian) {
            value = buf.get();
            if (this.isUnsigned) {
                value &= 0xFFL;
            }
            for (int i = 1; i < b.length; ++i) {
                value = value << 8 | (long)(buf.get() & 0xFF);
            }
        } else {
            for (int i = 0; i < b.length; ++i) {
                int newByte = buf.get();
                if (i < b.length - 1 || this.isUnsigned) {
                    newByte &= 0xFF;
                }
                value |= (long)newByte << 8 * i;
            }
        }
        return value;
    }
}

