/*
 * Decompiled with CFR 0.152.
 */
package opendap.dap;

import java.io.BufferedWriter;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Enumeration;
import java.util.Stack;
import java.util.Vector;
import opendap.dap.Alias;
import opendap.dap.Attribute;
import opendap.dap.AttributeExistsException;
import opendap.dap.AttributeTable;
import opendap.dap.BadSemanticsException;
import opendap.dap.BaseType;
import opendap.dap.BaseTypeFactory;
import opendap.dap.BaseTypePrimitiveVector;
import opendap.dap.DAP2Exception;
import opendap.dap.DAS;
import opendap.dap.DASException;
import opendap.dap.DConstructor;
import opendap.dap.DDSException;
import opendap.dap.DStructure;
import opendap.dap.DVector;
import opendap.dap.DefaultFactory;
import opendap.dap.MalformedAliasException;
import opendap.dap.NoSuchAttributeException;
import opendap.dap.NoSuchVariableException;
import opendap.dap.UnresolvedAliasException;
import opendap.dap.Util;
import opendap.dap.XMLparser.DDSXMLParser;
import opendap.dap.parser.DDSParser;
import opendap.dap.parser.ParseException;
import opendap.util.Debug;
import org.jdom.Document;

public class DDS
extends DStructure {
    private static final boolean _Debug = false;
    private BaseType currentBT;
    private AttributeTable currentAT;
    private static final char slash = '\\';
    private static final char quote = '\"';
    private static final char dot = '.';
    private BaseTypeFactory factory;
    private static final String defaultSchemaLocation = "http://xml.opendap.org/dap/dap2.xsd";
    private static final String opendapNameSpace = "http://xml.opendap.org/ns/DAP2";
    private String schemaLocation;
    private String _dataBlobID = null;

    public DDS() {
        this(null, new DefaultFactory());
    }

    public DDS(String n) {
        this(n, new DefaultFactory());
    }

    public DDS(BaseTypeFactory factory) {
        this("", factory);
    }

    public DDS(String n, BaseTypeFactory factory) {
        this(n, factory, defaultSchemaLocation);
    }

    public DDS(String n, BaseTypeFactory factory, String schema) {
        super(n);
        this.vars = new Vector();
        this.factory = factory;
        this.schemaLocation = schema;
    }

    public Object clone() {
        try {
            DDS d = (DDS)super.clone();
            d.vars = new Vector();
            for (int i = 0; i < this.vars.size(); ++i) {
                BaseType element = (BaseType)this.vars.elementAt(i);
                d.vars.addElement(element.clone());
            }
            d.setName(this.getName());
            d.factory = this.factory;
            return d;
        }
        catch (Exception e) {
            throw new InternalError();
        }
    }

    public final BaseTypeFactory getFactory() {
        return this.factory;
    }

    public final void setFactory(BaseTypeFactory btf) {
        this.factory = btf;
    }

    public void setBlobContentID(String contentID) {
        this._dataBlobID = contentID;
    }

    public String getBlobContentID() {
        return this._dataBlobID;
    }

    public DAS getDAS() throws DASException {
        DAS myDAS = new DAS();
        try {
            AttributeTable looseEnds = new AttributeTable(this.getLooseEndsTableName());
            AttributeTable atTbl = (AttributeTable)this.getAttributeTable().clone();
            int countLooseAttributes = 0;
            Enumeration e = atTbl.getNames();
            while (e.hasMoreElements()) {
                String name;
                String aName = (String)e.nextElement();
                Attribute a = atTbl.getAttribute(aName);
                if (a.isAlias()) {
                    name = a.getName();
                    String attribute = ((Alias)a).getAliasedToAttributeFieldAsClearString();
                    looseEnds.addAlias(name, this.convertDDSAliasFieldsToDASAliasFields(attribute));
                    ++countLooseAttributes;
                    continue;
                }
                if (a.isContainer()) {
                    myDAS.addAttributeTable(a.getName(), a.getContainer());
                    continue;
                }
                name = a.getName();
                int type = a.getType();
                Enumeration vals = a.getValues();
                while (vals.hasMoreElements()) {
                    String value = (String)vals.nextElement();
                    looseEnds.appendAttribute(name, type, value, true);
                }
                ++countLooseAttributes;
            }
            if (countLooseAttributes > 0) {
                myDAS.addAttributeTable(looseEnds.getName(), looseEnds);
            }
            e = this.getVariables();
            while (e.hasMoreElements()) {
                BaseType bt = (BaseType)e.nextElement();
                this.buildDASAttributeTable(bt, myDAS);
            }
            myDAS.resolveAliases();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new DASException(0, "Could not create a DAS from this DDX object.\nBecause of the structural differences between the DDX and the DAS it is possible for the DDX to contain sets of Attributes that cannot be represented in a DAS object.\nThe specific problem was an execption of type " + e.getClass().getName() + " with an " + "error message of: \n" + e.getMessage());
        }
        return myDAS;
    }

    private String convertDDSAliasFieldsToDASAliasFields(String attribute) throws MalformedAliasException {
        String prefix = "";
        Vector aNames = DDS.tokenizeAliasField(attribute);
        String topName = (String)aNames.get(1);
        boolean foundIt = false;
        Enumeration e = this.getVariables();
        while (e.hasMoreElements()) {
            BaseType bt = (BaseType)e.nextElement();
            String normName = DDS.normalize(bt.getName());
            if (!topName.equals(normName)) continue;
            foundIt = true;
        }
        if (!foundIt) {
            prefix = "." + this.getLooseEndsTableName();
        }
        return prefix + attribute;
    }

    private String getLooseEndsTableName() {
        return this.checkLooseEndsTableNameConflict(this.getName(), 0);
    }

    private String checkLooseEndsTableNameConflict(String name, int attempt) {
        Enumeration e = this.getVariables();
        while (e.hasMoreElements()) {
            BaseType bt = (BaseType)e.nextElement();
            String btName = bt.getName();
            if (!btName.equals(name)) continue;
            name = this.repairLooseEndsTableConflict(name, attempt++);
            name = this.checkLooseEndsTableNameConflict(name, attempt);
        }
        AttributeTable at = this.getAttributeTable();
        e = at.getNames();
        while (e.hasMoreElements()) {
            String aName = (String)e.nextElement();
            if (!aName.equals(name)) continue;
            name = this.repairLooseEndsTableConflict(name, attempt++);
            name = this.checkLooseEndsTableNameConflict(name, attempt);
        }
        return name;
    }

    private String repairLooseEndsTableConflict(String badName, int attempt) {
        System.out.println("Repairing toplevel attribute table name conflict. Attempt: " + attempt);
        String name = "";
        switch (attempt) {
            case 0: {
                name = badName + "_DatasetAttributes_0";
                break;
            }
            default: {
                int last_ = badName.lastIndexOf("_");
                name = badName.substring(0, last_) + "_" + attempt;
            }
        }
        return name;
    }

    private void buildDASAttributeTable(BaseType bt, AttributeTable atbl) throws DASException {
        AttributeTable tBTAT = bt.getAttributeTable();
        AttributeTable newAT = atbl.appendContainer(tBTAT.getName());
        Enumeration e = tBTAT.getNames();
        while (e.hasMoreElements()) {
            String attrName = (String)e.nextElement();
            Attribute attr = tBTAT.getAttribute(attrName);
            this.populateAttributeTable(newAT, attr);
        }
        if (bt instanceof DConstructor) {
            Enumeration v = ((DConstructor)bt).getVariables();
            while (v.hasMoreElements()) {
                BaseType thisBT = (BaseType)v.nextElement();
                this.buildDASAttributeTable(thisBT, newAT);
            }
        }
    }

    private void populateAttributeTable(AttributeTable atTable, Attribute attr) throws DASException {
        if (attr.isAlias()) {
            String alias = attr.getName();
            String attribute = ((Alias)attr).getAliasedToAttributeFieldAsClearString();
            atTable.addAlias(alias, this.convertDDSAliasFieldsToDASAliasFields(attribute));
        } else if (attr.isContainer()) {
            AttributeTable thisTable = attr.getContainer();
            AttributeTable newTable = atTable.appendContainer(thisTable.getName());
            Enumeration e = thisTable.getNames();
            while (e.hasMoreElements()) {
                String attrName = (String)e.nextElement();
                Attribute thisAttr = thisTable.getAttribute(attrName);
                this.populateAttributeTable(newTable, thisAttr);
            }
        } else {
            int type = attr.getType();
            String name = attr.getName();
            Enumeration v = attr.getValues();
            while (v.hasMoreElements()) {
                String value = (String)v.nextElement();
                atTable.appendAttribute(name, type, value);
            }
        }
    }

    public void printDAS(OutputStream os) {
        PrintWriter pw = new PrintWriter(new BufferedWriter(new OutputStreamWriter(os)));
        this.printDAS(pw);
        pw.flush();
    }

    public void printDAS(PrintWriter pw) {
        DAS myDAS = null;
        try {
            myDAS = this.getDAS();
            myDAS.print(pw);
        }
        catch (DASException dasE) {
            pw.println("\n\nCould not get a DAS object to print!\nDDS.getDAS() threw an Exception. Message: \n" + dasE.getMessage());
        }
    }

    public void delVariable(String name) {
        try {
            BaseType bt = this.getVariable(name);
            this.vars.removeElement(bt);
        }
        catch (NoSuchVariableException noSuchVariableException) {
            // empty catch block
        }
    }

    private DConstructor isVectorOfDConstructor(BaseType var) {
        if (!(var instanceof DVector)) {
            return null;
        }
        if (!(((DVector)var).getPrimitiveVector() instanceof BaseTypePrimitiveVector)) {
            return null;
        }
        BaseTypePrimitiveVector btpv = (BaseTypePrimitiveVector)((DVector)var).getPrimitiveVector();
        if (btpv.getTemplate() instanceof DConstructor) {
            return (DConstructor)btpv.getTemplate();
        }
        return this.isVectorOfDConstructor(btpv.getTemplate());
    }

    public BaseType getVariable(String name) throws NoSuchVariableException {
        Stack s = new Stack();
        s = this.search(name, s);
        return (BaseType)s.pop();
    }

    public void addVariable(BaseType v, int part) {
        this.vars.addElement(v);
    }

    public Stack search(String name, Stack compStack) throws NoSuchVariableException {
        DDSSearch ddsSearch = new DDSSearch(compStack);
        if (ddsSearch.deepSearch(name)) {
            return ddsSearch.components;
        }
        throw new NoSuchVariableException("The variable `" + name + "' was not found in the dataset.");
    }

    public final Enumeration getVariables() {
        return this.vars.elements();
    }

    public final int numVariables() {
        return this.vars.size();
    }

    public void parse(InputStream is) throws ParseException, DDSException {
        DDSParser dp = new DDSParser(is);
        dp.Dataset(this, this.factory);
    }

    public void parseXML(InputStream is, boolean validation) throws DAP2Exception {
        DDSXMLParser dp = new DDSXMLParser(opendapNameSpace);
        dp.parse(is, this, this.factory, validation);
        this.checkForAttributeNameConflict();
        this.resolveAliases();
    }

    public void parseXML(Document ddxDoc, boolean validation) throws DAP2Exception {
        DDSXMLParser dp = new DDSXMLParser(opendapNameSpace);
        dp.parse(ddxDoc, this, this.factory, validation);
        this.checkForAttributeNameConflict();
        this.resolveAliases();
    }

    public void checkSemantics(boolean all) throws BadSemanticsException {
        if (this.getName() == null) {
            System.err.println("A dataset must have a name");
            throw new BadSemanticsException("DDS.checkSemantics(): A dataset must have a name");
        }
        Util.uniqueNames(this.vars, this.getName(), "Dataset");
        if (all) {
            Enumeration e = this.vars.elements();
            while (e.hasMoreElements()) {
                BaseType bt = (BaseType)e.nextElement();
                bt.checkSemantics(true);
            }
        }
    }

    public void print(PrintWriter os) {
        os.println("Dataset {");
        Enumeration e = this.vars.elements();
        while (e.hasMoreElements()) {
            BaseType bt = (BaseType)e.nextElement();
            bt.printDecl(os);
        }
        os.print("} ");
        if (this.getName() != null) {
            os.print(this.getName());
        }
        os.println(";");
    }

    public final void print(OutputStream os) {
        PrintWriter pw = new PrintWriter(new BufferedWriter(new OutputStreamWriter(os)));
        this.print(pw);
        pw.flush();
    }

    public void resolveAliases() throws MalformedAliasException, UnresolvedAliasException, NoSuchAttributeException {
        this.currentBT = null;
        this.currentAT = null;
        this.resolveAliases(this);
    }

    private void resolveAliases(BaseType bt) throws MalformedAliasException, UnresolvedAliasException, NoSuchAttributeException {
        BaseType cacheBT = this.currentBT;
        this.currentBT = bt;
        this.currentAT = null;
        if (Debug.isSet("DDS.resolveAliases")) {
            System.out.println("Searching for Aliases in the Attributes of Variable: " + bt.getName());
        }
        this.resolveAliases(bt.getAttributeTable());
        if (bt instanceof DConstructor) {
            if (Debug.isSet("DDS.resolveAliases")) {
                System.out.println("Searching for Aliases in the children of Variable: " + bt.getName());
            }
            Enumeration bte = ((DConstructor)bt).getVariables();
            while (bte.hasMoreElements()) {
                BaseType thisBT = (BaseType)bte.nextElement();
                this.resolveAliases(thisBT);
            }
        }
        this.currentBT = cacheBT;
    }

    private void resolveAliases(AttributeTable at) throws MalformedAliasException, UnresolvedAliasException, NoSuchAttributeException {
        AttributeTable cacheAT = this.currentAT;
        this.currentAT = at;
        Enumeration aNames = this.currentAT.getNames();
        while (aNames.hasMoreElements()) {
            String aName = (String)aNames.nextElement();
            Attribute thisA = this.currentAT.getAttribute(aName);
            if (thisA.isAlias()) {
                this.resolveAlias((Alias)thisA);
                if (!Debug.isSet("DDS.resolveAliases")) continue;
                System.out.println("Resolved Alias: '" + thisA.getName() + "'\n");
                continue;
            }
            if (!thisA.isContainer()) continue;
            this.resolveAliases(thisA.getContainer());
        }
        this.currentAT = cacheAT;
    }

    private void resolveAlias(Alias alias) throws MalformedAliasException, UnresolvedAliasException {
        String name = alias.getName();
        String attribute = alias.getAliasedToAttributeFieldAsClearString();
        if (Debug.isSet("DDS.resolveAliases")) {
            System.out.println("\n\nFound: Alias " + name + "  " + attribute);
        }
        if (attribute.equals("")) {
            throw new MalformedAliasException("The attribute 'attribute' in the Alias element (name: '" + name + "') must have a value other than an empty string.");
        }
        if (Debug.isSet("DDS.resolveAliases")) {
            System.out.println("Attribute: `" + attribute + "'");
        }
        Vector aNames = DDS.tokenizeAliasField(attribute);
        if (Debug.isSet("DDS.resolveAliases")) {
            System.out.println("Attribute name tokenized to " + aNames.size() + " elements");
            Enumeration e = aNames.elements();
            while (e.hasMoreElements()) {
                String aname = (String)e.nextElement();
                System.out.println("name: " + aname);
            }
        }
        BaseType targetBT = null;
        boolean isAbsolutePath = aNames.get(0).equals(".");
        if (!isAbsolutePath) {
            throw new MalformedAliasException("In the Alias '" + name + "'" + " the value of the attribute 'attribute' does not begin with the character dot (.). " + "The value of the 'attribute' field must always be an absolute path name from the " + "top level of the variable reference, and thus must always begin with the dot (.) character.");
        }
        if (aNames.size() == 1) {
            throw new MalformedAliasException("In the Alias '" + name + "'" + " the value of the attribute 'attribute' contains only the character dot (.). " + "The value of the 'attribute' field must always reference an Attribute using an absolute path name from the " + "top level of the DAS, and must reference an attribute within the DAS. A simple dot is not allowed.");
        }
        aNames.remove(0);
        targetBT = this.getDeepestMatchingVariable(this, aNames);
        if (targetBT == null) {
            targetBT = this;
        }
        Attribute targetAT = null;
        targetAT = aNames.size() == 0 ? targetBT.getAttribute() : this.getAttribute(targetBT.getAttributeTable(), aNames);
        alias.setMyVariable(targetBT);
        alias.setMyAttribute(targetAT);
    }

    private Attribute getAttribute(AttributeTable at, Vector aNames) throws MalformedAliasException, UnresolvedAliasException {
        String aName = (String)aNames.get(0);
        Enumeration e = at.getNames();
        while (e.hasMoreElements()) {
            String atName = (String)e.nextElement();
            Attribute a = at.getAttribute(atName);
            String normName = DDS.normalize(a.getName());
            if (!normName.equals(aName)) continue;
            if (a.isAlias()) {
                throw new MalformedAliasException("Aliases may NOT point to other aliases");
            }
            aNames.remove(0);
            if (aNames.size() == 0) {
                return a;
            }
            if (a.isContainer()) {
                try {
                    return this.getAttribute(a.getContainer(), aNames);
                }
                catch (NoSuchAttributeException nsae) {
                    throw new MalformedAliasException("Attribute " + a.getName() + " is not an attribute container. (AttributeTable) " + " It may not contain the attribute: " + aName);
                }
            }
            throw new MalformedAliasException("Attribute " + a.getName() + " is not an attribute container. (AttributeTable) " + " It may not contain the attribute: " + aName);
        }
        throw new UnresolvedAliasException("The alias `` references the attribute: `" + aName + "` which cannot be found.");
    }

    private BaseType getDeepestMatchingVariable(DConstructor dcBT, Vector vNames) {
        String vName = (String)vNames.get(0);
        Enumeration bte = dcBT.getVariables();
        while (bte.hasMoreElements()) {
            BaseType bt = (BaseType)bte.nextElement();
            String normName = DDS.normalize(bt.getClearName());
            if (!normName.equals(vName)) continue;
            vNames.remove(0);
            if (vNames.size() == 0) {
                return bt;
            }
            if (bt instanceof DConstructor) {
                BaseType nextBT = this.getDeepestMatchingVariable((DConstructor)bt, vNames);
                if (nextBT != null) {
                    return nextBT;
                }
                return bt;
            }
            return bt;
        }
        return null;
    }

    public static String normalize(String field) {
        boolean Debug2 = false;
        StringBuffer sb = new StringBuffer(field);
        for (int offset = 0; offset < sb.length(); ++offset) {
            char c = sb.charAt(offset);
            if (c != '\\' && c != '\"') continue;
            sb.insert(offset, '\\');
            ++offset;
        }
        if (Debug2) {
            System.out.println("String: `" + field + "` normalized to: `" + sb + "`");
        }
        return sb.toString();
    }

    public static Vector tokenizeAliasField(String field) throws MalformedAliasException {
        boolean Debug2 = false;
        int lastIndex = field.length() - 1;
        Vector<String> tokens = new Vector<String>();
        if (Debug2) {
            System.out.println("lastIndexOf(dot): " + field.lastIndexOf(46) + "   lastIndex: " + lastIndex);
        }
        if (field.charAt(0) == '\"') {
            int start = 1;
            int end = -1;
            boolean done = false;
            boolean escaped = false;
            for (int i = 1; i <= lastIndex || !done; ++i) {
                char c = field.charAt(i);
                if (escaped) {
                    escaped = false;
                    continue;
                }
                if (c == '\\') {
                    escaped = true;
                    continue;
                }
                if (c != '\"') continue;
                end = i;
                done = true;
            }
            if (end < 0) {
                throw new MalformedAliasException("Alias fields that begin with the quote (\") sign must have a closing quote.");
            }
            if (lastIndex > end && field.charAt(end + 1) != '.') {
                throw new MalformedAliasException("Alias fields must be seperated by the dot (.) character.");
            }
            if (field.charAt(lastIndex) == '.') {
                throw new MalformedAliasException("Alias fields may not end with the dot (.) character.");
            }
            String firstToken = field.substring(start, end);
            tokens.add(firstToken);
            if (end < lastIndex) {
                String theRest = field.substring(end + 2);
                Enumeration tkns = DDS.tokenizeAliasField(theRest).elements();
                while (tkns.hasMoreElements()) {
                    tokens.add((String)tkns.nextElement());
                }
            }
            return tokens;
        }
        int firstDot = field.indexOf(46);
        if (firstDot == 0) {
            if (Debug2) {
                System.out.println("First dot at index 0");
            }
            String thisToken = ".";
            tokens.add(thisToken);
            if (lastIndex > 0) {
                String theRest = field.substring(1);
                Enumeration tkns = DDS.tokenizeAliasField(theRest).elements();
                while (tkns.hasMoreElements()) {
                    tokens.add((String)tkns.nextElement());
                }
            }
            return tokens;
        }
        if (firstDot > 0) {
            String firstToken = field.substring(0, firstDot);
            tokens.add(firstToken);
            if (lastIndex == firstDot) {
                throw new MalformedAliasException("Alias fields may not end with the dot (.) character.");
            }
            String theRest = field.substring(firstDot + 1);
            Enumeration tkns = DDS.tokenizeAliasField(theRest).elements();
            while (tkns.hasMoreElements()) {
                tokens.add((String)tkns.nextElement());
            }
            return tokens;
        }
        tokens.add(field);
        return tokens;
    }

    public void printXML(PrintWriter pw) {
        this.printXML(pw, "", false);
    }

    public void printXML(PrintWriter pw, String pad, boolean constrained) {
        pw.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        pw.println("<Dataset name=\"" + DDSXMLParser.normalizeToXML(this.getName()) + "\"");
        pw.println("xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"");
        pw.println("xmlns=\"http://xml.opendap.org/ns/DAP2\"");
        pw.print("xsi:schemaLocation=\"");
        pw.print("http://xml.opendap.org/ns/DAP2  ");
        pw.print(this.schemaLocation);
        pw.println("\" >");
        pw.println("");
        Enumeration e = this.getAttributeNames();
        while (e.hasMoreElements()) {
            String aName = (String)e.nextElement();
            try {
                Attribute a = this.getAttribute(aName);
                a.printXML(pw, pad + "\t", constrained);
            }
            catch (NoSuchAttributeException nsae) {}
        }
        pw.println("");
        Enumeration ve = this.getVariables();
        while (ve.hasMoreElements()) {
            BaseType bt = (BaseType)ve.nextElement();
            bt.printXML(pw, pad + "\t", constrained);
        }
        pw.println("");
        if (this._dataBlobID != null) {
            pw.println(pad + "\t" + "<dataBLOB href=\"" + DDSXMLParser.normalizeToXML(this._dataBlobID) + "\"/>");
        }
        pw.println(pad + "</Dataset>");
    }

    public void ingestDAS(DAS das) {
        try {
            this.ingestAttributeTable((AttributeTable)das, this);
            this.resolveAliases();
        }
        catch (DASException de) {
            System.out.println("DDS.ingestDAS(): " + de.getMessage());
        }
    }

    private void ingestAttribute(Attribute a, BaseType bt) throws DASException {
        if (a.isAlias()) {
            String name = a.getName();
            String attribute = ((Alias)a).getAliasedToAttributeFieldAsClearString();
            bt.addAttributeAlias(name, attribute);
        } else if (a.isContainer()) {
            AttributeTable at = a.getContainer();
            this.ingestAttributeTable(at, bt);
        } else {
            String name = a.getName();
            int type = a.getType();
            Enumeration vals = a.getValues();
            while (vals.hasMoreElements()) {
                String value = (String)vals.nextElement();
                bt.appendAttribute(name, type, value, true);
            }
        }
    }

    private void ingestAttributeTable(AttributeTable at, DConstructor dc) throws DASException {
        Enumeration ate = at.getNames();
        while (ate.hasMoreElements()) {
            String aName = (String)ate.nextElement();
            Attribute a = at.getAttribute(aName);
            boolean foundIt = false;
            Enumeration bte = dc.getVariables();
            while (bte.hasMoreElements()) {
                BaseType thisBT = (BaseType)bte.nextElement();
                String bName = thisBT.getName();
                if (!bName.equals(aName)) continue;
                if (a.isContainer() && thisBT instanceof DConstructor) {
                    this.ingestAttributeTable(a.getContainer(), (DConstructor)thisBT);
                } else {
                    this.ingestAttribute(a, thisBT);
                }
                foundIt = true;
            }
            if (foundIt) continue;
            this.ingestAttribute(a, dc);
        }
    }

    private void ingestAttributeTable(AttributeTable at, BaseType bt) throws DASException {
        try {
            String atName = at.getName();
            String bName = bt.getName();
            if (bName.equals(atName)) {
                Enumeration e = at.getNames();
                while (e.hasMoreElements()) {
                    String aName = (String)e.nextElement();
                    Attribute a = at.getAttribute(aName);
                    this.ingestAttribute(a, bt);
                }
            } else {
                bt.addAttributeContainer(at);
            }
        }
        catch (AttributeExistsException ase) {
            Enumeration e = at.getNames();
            while (e.hasMoreElements()) {
                String aName = (String)e.nextElement();
                Attribute a = at.getAttribute(aName);
                this.ingestAttribute(a, bt);
            }
        }
    }

    public void checkForAttributeNameConflict() throws BadSemanticsException {
        this.checkForAttributeNameConflict(this);
    }

    private void checkForAttributeNameConflict(DConstructor dc) throws BadSemanticsException {
        Enumeration bte = dc.getVariables();
        while (bte.hasMoreElements()) {
            BaseType bt = (BaseType)bte.nextElement();
            Enumeration ate = dc.getAttributeNames();
            while (ate.hasMoreElements()) {
                String aName = (String)ate.nextElement();
                if (!aName.equals(bt.getName())) continue;
                throw new BadSemanticsException("The variable '" + dc.getLongName() + "' has an Attribute with the same name ('" + aName + "') as one of it's " + "member variables (" + bt.getTypeName() + " " + bt.getName() + ")\n" + "This is NOT allowed.");
            }
            if (!(bt instanceof DConstructor)) continue;
            this.checkForAttributeNameConflict((DConstructor)bt);
        }
    }

    public String getDDSText() {
        StringWriter sw = new StringWriter();
        this.print(new PrintWriter(sw));
        return sw.toString();
    }

    public String getDDXText() {
        StringWriter sw = new StringWriter();
        this.printXML(new PrintWriter(sw));
        return sw.toString();
    }

    private final class DDSSearch {
        Stack components;

        DDSSearch(Stack c) {
            this.components = c;
        }

        BaseType simpleSearch(String name, BaseType start) {
            Enumeration e = null;
            if (start == null) {
                e = DDS.this.getVariables();
            } else if (start instanceof DConstructor) {
                e = ((DConstructor)start).getVariables();
            } else {
                DConstructor dcv = DDS.this.isVectorOfDConstructor(start);
                if (dcv != null) {
                    e = dcv.getVariables();
                } else {
                    return null;
                }
            }
            while (e.hasMoreElements()) {
                BaseType v = (BaseType)e.nextElement();
                if (!v.getName().equals(name)) continue;
                return v;
            }
            return null;
        }

        boolean deepSearch(String name) throws NoSuchVariableException {
            Enumeration e;
            BaseType start = this.components.empty() ? null : (BaseType)this.components.peek();
            BaseType found = this.simpleSearch(name, start);
            if (found != null) {
                this.components.push(found);
                return true;
            }
            if (start == null) {
                e = DDS.this.getVariables();
            } else if (start instanceof DConstructor) {
                e = ((DConstructor)start).getVariables();
            } else {
                DConstructor dcv = DDS.this.isVectorOfDConstructor(start);
                if (dcv != null) {
                    e = dcv.getVariables();
                } else {
                    return false;
                }
            }
            while (e.hasMoreElements()) {
                BaseType v = (BaseType)e.nextElement();
                this.components.push(v);
                if (this.deepSearch(name)) {
                    return true;
                }
                this.components.pop();
            }
            return false;
        }
    }
}

