/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ffi.netcdf;

import com.google.common.base.Strings;
import com.sun.jna.Native;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.nc2.jni.netcdf.Nc4prototypes;
import ucar.nc2.jni.netcdf.Nc4wrapper;

public class NetcdfClibrary {
    private static Logger log = LoggerFactory.getLogger(NetcdfClibrary.class);
    private static Logger startupLog = LoggerFactory.getLogger("serverStartup");
    private static final String JNA_PATH = "jna.library.path";
    private static final String JNA_PATH_ENV = "JNA_PATH";
    private static final String JNA_LOG_LEVEL = "jna.library.loglevel";
    private static String DEFAULT_NETCDF4_LIBNAME;
    private static String jnaPath;
    private static String libName;
    private static Nc4prototypes nc4;
    private static int log_level;
    private static String version;
    private static Boolean isClibraryPresent;

    public static void setLibraryNameAndPath(@Nullable String jna_path, @Nullable String lib_name) {
        if ((lib_name = Strings.emptyToNull(lib_name)) == null) {
            lib_name = DEFAULT_NETCDF4_LIBNAME;
        }
        if ((jna_path = Strings.emptyToNull(jna_path)) == null) {
            jna_path = Strings.emptyToNull(System.getProperty(JNA_PATH));
        }
        if (jna_path == null) {
            jna_path = Strings.emptyToNull(System.getenv(JNA_PATH_ENV));
        }
        if (jna_path != null) {
            System.setProperty(JNA_PATH, jna_path);
        }
        libName = lib_name;
        jnaPath = jna_path;
    }

    public static synchronized boolean isLibraryPresent() {
        if (isClibraryPresent == null) {
            isClibraryPresent = NetcdfClibrary.load() != null;
        }
        return isClibraryPresent;
    }

    public static synchronized Nc4prototypes getForeignFunctionInterface() {
        return NetcdfClibrary.isLibraryPresent() ? nc4 : null;
    }

    @Nullable
    public static String getVersion() {
        if (nc4 != null && version == null) {
            try {
                version = nc4.nc_inq_libvers();
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                // empty catch block
            }
        }
        return version;
    }

    public static synchronized int setLogLevel(int level) {
        int oldlevel = -1;
        log_level = level;
        if (nc4 != null) {
            try {
                oldlevel = nc4.nc_set_log_level(log_level);
                startupLog.info(String.format("NetcdfLoader: set log level: old=%d new=%d", oldlevel, log_level));
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                // empty catch block
            }
        }
        return oldlevel;
    }

    private static Nc4prototypes load() {
        if (nc4 == null) {
            if (jnaPath == null) {
                NetcdfClibrary.setLibraryNameAndPath(null, null);
            }
            try {
                nc4 = Native.load(libName, Nc4prototypes.class);
                nc4 = new Nc4wrapper(nc4);
                startupLog.info("Nc4Iosp: NetCDF-4 C library loaded (jna_path='{}', libname='{}' version='{}').", jnaPath, libName, NetcdfClibrary.getVersion());
                startupLog.debug("Netcdf nc_inq_libvers='{}' isProtected={}", (Object)nc4.nc_inq_libvers(), (Object)Native.isProtected());
            }
            catch (Throwable t) {
                String message = String.format("Nc4Iosp: NetCDF-4 C library not present (jna_path='%s', libname='%s').", jnaPath, libName);
                startupLog.warn(message, t);
            }
            String slevel = Strings.emptyToNull(System.getProperty(JNA_LOG_LEVEL));
            if (slevel != null) {
                try {
                    log_level = Integer.parseInt(slevel);
                }
                catch (NumberFormatException message) {
                    // empty catch block
                }
            }
            try {
                int oldlevel = NetcdfClibrary.setLogLevel(log_level);
                startupLog.info(String.format("Nc4Iosp: set log level: old=%d new=%d", oldlevel, log_level));
            }
            catch (Throwable t) {
                String message = String.format("Nc4Iosp: could not set log level (level=%d jna_path='%s', libname='%s').", log_level, jnaPath, libName);
                startupLog.warn("Nc4Iosp: " + t.getMessage());
                startupLog.warn(message);
            }
        }
        return nc4;
    }

    private NetcdfClibrary() {
        throw new UnsupportedOperationException();
    }

    static {
        libName = DEFAULT_NETCDF4_LIBNAME = "netcdf";
    }
}

