/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.iosp.bufr;

import java.io.IOException;
import javax.annotation.concurrent.Immutable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.nc2.iosp.bufr.BufrIdentificationSection;
import ucar.nc2.iosp.bufr.Descriptor;
import ucar.nc2.iosp.bufr.tables.BufrTables;
import ucar.nc2.iosp.bufr.tables.TableB;
import ucar.nc2.iosp.bufr.tables.TableD;

@Immutable
public class TableLookup {
    private static final Logger log = LoggerFactory.getLogger(TableLookup.class);
    private static final boolean showErrors = false;
    private final TableB localTableB;
    private final TableD localTableD;
    private final TableB wmoTableB;
    private final TableD wmoTableD;
    private final BufrTables.Mode mode;

    public TableLookup(int center, int subcenter, int masterTableVersion, int local, int cat) throws IOException {
        this.wmoTableB = BufrTables.getWmoTableB(masterTableVersion);
        this.wmoTableD = BufrTables.getWmoTableD(masterTableVersion);
        BufrTables.Tables tables = BufrTables.getLocalTables(center, subcenter, masterTableVersion, local, cat);
        if (tables != null) {
            this.localTableB = tables.b;
            this.localTableD = tables.d;
            this.mode = tables.mode == null ? BufrTables.Mode.localOverride : tables.mode;
        } else {
            this.localTableB = null;
            this.localTableD = null;
            this.mode = BufrTables.Mode.localOverride;
        }
    }

    public TableLookup(BufrIdentificationSection ids, TableB b, TableD d) throws IOException {
        this.wmoTableB = BufrTables.getWmoTableB(ids.getMasterTableVersion());
        this.wmoTableD = BufrTables.getWmoTableD(ids.getMasterTableVersion());
        this.localTableB = b;
        this.localTableD = d;
        this.mode = BufrTables.Mode.localOverride;
    }

    public String getWmoTableBName() {
        return this.wmoTableB.getName();
    }

    public String getLocalTableBName() {
        return this.localTableB == null ? "none" : this.localTableB.getName();
    }

    public String getLocalTableDName() {
        return this.localTableD == null ? "none" : this.localTableD.getName();
    }

    public String getWmoTableDName() {
        return this.wmoTableD.getName();
    }

    public BufrTables.Mode getMode() {
        return this.mode;
    }

    public TableB getLocalTableB() {
        return this.localTableB;
    }

    public TableD getLocalTableD() {
        return this.localTableD;
    }

    public TableB.Descriptor getDescriptorTableB(short fxy) {
        TableB.Descriptor b = null;
        boolean isWmoRange = Descriptor.isWmoRange(fxy);
        if (isWmoRange && this.mode == BufrTables.Mode.wmoOnly) {
            b = this.wmoTableB.getDescriptor(fxy);
        } else if (isWmoRange && this.mode == BufrTables.Mode.wmoLocal) {
            b = this.wmoTableB.getDescriptor(fxy);
            if (b == null && this.localTableB != null) {
                b = this.localTableB.getDescriptor(fxy);
            }
        } else if (isWmoRange && this.mode == BufrTables.Mode.localOverride) {
            if (this.localTableB != null) {
                b = this.localTableB.getDescriptor(fxy);
            }
            if (b == null) {
                b = this.wmoTableB.getDescriptor(fxy);
            } else {
                b.setLocalOverride(true);
            }
        } else if (!isWmoRange && this.localTableB != null) {
            b = this.localTableB.getDescriptor(fxy);
        }
        if (b == null) {
            b = BufrTables.getWmoTableBlatest().getDescriptor(fxy);
        }
        if (b == null) {
            // empty if block
        }
        return b;
    }

    public TableD.Descriptor getDescriptorTableD(short fxy) {
        TableD.Descriptor d = null;
        boolean isWmoRange = Descriptor.isWmoRange(fxy);
        if (isWmoRange && this.mode == BufrTables.Mode.wmoOnly) {
            d = this.wmoTableD.getDescriptor(fxy);
        } else if (isWmoRange && this.mode == BufrTables.Mode.wmoLocal) {
            d = this.wmoTableD.getDescriptor(fxy);
            if (d == null && this.localTableD != null) {
                d = this.localTableD.getDescriptor(fxy);
            }
        } else if (isWmoRange && this.mode == BufrTables.Mode.localOverride) {
            if (this.localTableD != null) {
                d = this.localTableD.getDescriptor(fxy);
            }
            if (d == null) {
                d = this.wmoTableD.getDescriptor(fxy);
            } else {
                d.setLocalOverride(true);
            }
        } else if (this.localTableD != null) {
            d = this.localTableD.getDescriptor(fxy);
        }
        if (d == null) {
            d = BufrTables.getWmoTableDlatest().getDescriptor(fxy);
        }
        if (d == null) {
            // empty if block
        }
        return d;
    }
}

