/*
 * Decompiled with CFR 0.152.
 */
package org.astrogrid.samp.httpd;

import java.io.IOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.LinkedHashMap;
import org.astrogrid.samp.httpd.HttpServer;
import org.astrogrid.samp.httpd.UtilServer;

public class URLMapperHandler
implements HttpServer.Handler {
    private final String basePath_;
    private final URL baseUrl_;
    private final URL sourceUrl_;
    private final boolean includeRelatives_;

    public URLMapperHandler(HttpServer server, String basePath, URL sourceUrl, boolean includeRelatives) throws MalformedURLException {
        if (!basePath.startsWith("/")) {
            basePath = "/" + basePath;
        }
        if (!basePath.endsWith("/") && includeRelatives) {
            basePath = basePath + "/";
        }
        this.basePath_ = basePath;
        this.baseUrl_ = new URL(server.getBaseUrl(), basePath);
        this.sourceUrl_ = sourceUrl;
        this.includeRelatives_ = includeRelatives;
    }

    public URL getBaseUrl() {
        return this.baseUrl_;
    }

    public HttpServer.Response serveRequest(HttpServer.Request request) {
        URL srcUrl;
        String path = request.getUrl();
        if (!path.startsWith(this.basePath_)) {
            return null;
        }
        String relPath = path.substring(this.basePath_.length());
        if (this.includeRelatives_) {
            try {
                srcUrl = new URL(this.sourceUrl_, relPath);
            }
            catch (MalformedURLException e) {
                return HttpServer.createErrorResponse(500, "Internal server error", e);
            }
        } else if (relPath.length() == 0) {
            srcUrl = this.sourceUrl_;
        } else {
            return HttpServer.createErrorResponse(403, "Forbidden");
        }
        return URLMapperHandler.mapUrlResponse(request.getMethod(), srcUrl);
    }

    public static HttpServer.Response mapUrlResponse(String method, URL targetUrl) {
        URLConnection conn;
        try {
            conn = targetUrl.openConnection();
            conn.connect();
        }
        catch (IOException e) {
            return HttpServer.createErrorResponse(404, "Not found", e);
        }
        try {
            String contentEncoding;
            int contentLength;
            LinkedHashMap<String, String> hdrMap = new LinkedHashMap<String, String>();
            String contentType = conn.getContentType();
            if (contentType != null) {
                hdrMap.put("Content-Type", contentType);
            }
            if ((contentLength = conn.getContentLength()) >= 0) {
                hdrMap.put("Content-Length", Integer.toString(contentLength));
            }
            if ((contentEncoding = conn.getContentEncoding()) != null) {
                hdrMap.put("Content-Encoding", contentEncoding);
            }
            if ("GET".equals(method)) {
                return new HttpServer.Response(200, "OK", hdrMap){

                    public void writeBody(OutputStream out) throws IOException {
                        UtilServer.copy(conn.getInputStream(), out);
                    }
                };
            }
            if ("HEAD".equals(method)) {
                return new HttpServer.Response(200, "OK", hdrMap){

                    public void writeBody(OutputStream out) {
                    }
                };
            }
            return HttpServer.create405Response(new String[]{"HEAD", "GET"});
        }
        catch (Exception e) {
            return HttpServer.createErrorResponse(500, "Internal server error", e);
        }
    }
}

