/*
 * Decompiled with CFR 0.152.
 */
package proguard.evaluation.value;

import proguard.evaluation.value.ComparisonValue;
import proguard.evaluation.value.CompositeDoubleValue;
import proguard.evaluation.value.ConvertedFloatValue;
import proguard.evaluation.value.ConvertedIntegerValue;
import proguard.evaluation.value.ConvertedLongValue;
import proguard.evaluation.value.DoubleValue;
import proguard.evaluation.value.FloatValue;
import proguard.evaluation.value.IntegerValue;
import proguard.evaluation.value.LongValue;
import proguard.evaluation.value.NegatedDoubleValue;
import proguard.evaluation.value.SpecificValueFactory;
import proguard.evaluation.value.ValueFactory;

abstract class SpecificDoubleValue
extends DoubleValue {
    SpecificDoubleValue() {
    }

    @Override
    public DoubleValue negate() {
        return new NegatedDoubleValue(this);
    }

    @Override
    public IntegerValue convertToInteger() {
        return new ConvertedIntegerValue(this);
    }

    @Override
    public LongValue convertToLong() {
        return new ConvertedLongValue(this);
    }

    @Override
    public FloatValue convertToFloat() {
        return new ConvertedFloatValue(this);
    }

    @Override
    public DoubleValue generalize(DoubleValue doubleValue) {
        return doubleValue.generalize(this);
    }

    @Override
    public DoubleValue add(DoubleValue doubleValue) {
        return doubleValue.add(this);
    }

    @Override
    public DoubleValue subtract(DoubleValue doubleValue) {
        return doubleValue.subtractFrom(this);
    }

    @Override
    public DoubleValue subtractFrom(DoubleValue doubleValue) {
        return doubleValue.subtract(this);
    }

    @Override
    public DoubleValue multiply(DoubleValue doubleValue) {
        return doubleValue.multiply(this);
    }

    @Override
    public DoubleValue divide(DoubleValue doubleValue) {
        return doubleValue.divideOf(this);
    }

    @Override
    public DoubleValue divideOf(DoubleValue doubleValue) {
        return doubleValue.divide(this);
    }

    @Override
    public DoubleValue remainder(DoubleValue doubleValue) {
        return doubleValue.remainderOf(this);
    }

    @Override
    public DoubleValue remainderOf(DoubleValue doubleValue) {
        return doubleValue.remainder(this);
    }

    @Override
    public IntegerValue compare(DoubleValue doubleValue) {
        return doubleValue.compareReverse(this);
    }

    @Override
    public DoubleValue generalize(SpecificDoubleValue specificDoubleValue) {
        return this.equals(specificDoubleValue) ? this : ValueFactory.DOUBLE_VALUE;
    }

    @Override
    public DoubleValue add(SpecificDoubleValue specificDoubleValue) {
        return new CompositeDoubleValue(this, 43, specificDoubleValue);
    }

    @Override
    public DoubleValue subtract(SpecificDoubleValue specificDoubleValue) {
        return new CompositeDoubleValue(this, 45, specificDoubleValue);
    }

    @Override
    public DoubleValue subtractFrom(SpecificDoubleValue specificDoubleValue) {
        return new CompositeDoubleValue(specificDoubleValue, 45, this);
    }

    @Override
    public DoubleValue multiply(SpecificDoubleValue specificDoubleValue) {
        return new CompositeDoubleValue(this, 42, specificDoubleValue);
    }

    @Override
    public DoubleValue divide(SpecificDoubleValue specificDoubleValue) {
        return new CompositeDoubleValue(this, 47, specificDoubleValue);
    }

    @Override
    public DoubleValue divideOf(SpecificDoubleValue specificDoubleValue) {
        return new CompositeDoubleValue(specificDoubleValue, 47, this);
    }

    @Override
    public DoubleValue remainder(SpecificDoubleValue specificDoubleValue) {
        return new CompositeDoubleValue(this, 37, specificDoubleValue);
    }

    @Override
    public DoubleValue remainderOf(SpecificDoubleValue specificDoubleValue) {
        return new CompositeDoubleValue(specificDoubleValue, 37, this);
    }

    @Override
    public IntegerValue compare(SpecificDoubleValue specificDoubleValue) {
        return this.equals(specificDoubleValue) ? SpecificValueFactory.INTEGER_VALUE_0 : new ComparisonValue(this, specificDoubleValue);
    }

    @Override
    public boolean isSpecific() {
        return true;
    }

    public boolean equals(Object object) {
        return object != null && this.getClass() == object.getClass();
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }
}

