/*
 * Decompiled with CFR 0.152.
 */
package proguard.util;

import java.util.List;
import proguard.util.AndMatcher;
import proguard.util.ListUtil;
import proguard.util.NameParser;
import proguard.util.NotMatcher;
import proguard.util.OrMatcher;
import proguard.util.StringMatcher;
import proguard.util.StringParser;

public class ListParser
implements StringParser {
    private final StringParser stringParser;

    public ListParser(StringParser stringParser) {
        this.stringParser = stringParser;
    }

    @Override
    public StringMatcher parse(String string) {
        return this.parse(ListUtil.commaSeparatedList(string));
    }

    public StringMatcher parse(List list) {
        StringMatcher stringMatcher = null;
        for (int i = list.size() - 1; i >= 0; --i) {
            String string = (String)list.get(i);
            StringMatcher stringMatcher2 = this.parseEntry(string);
            stringMatcher = stringMatcher == null ? stringMatcher2 : (this.isNegated(string) ? new AndMatcher(stringMatcher2, stringMatcher) : new OrMatcher(stringMatcher2, stringMatcher));
        }
        return stringMatcher;
    }

    private StringMatcher parseEntry(String string) {
        return this.isNegated(string) ? new NotMatcher(this.stringParser.parse(string.substring(1))) : this.stringParser.parse(string);
    }

    private boolean isNegated(String string) {
        return string.length() > 0 && string.charAt(0) == '!';
    }

    public static void main(String[] stringArray) {
        try {
            System.out.println("Regular expression [" + stringArray[0] + "]");
            ListParser listParser = new ListParser(new NameParser());
            StringMatcher stringMatcher = listParser.parse(stringArray[0]);
            for (int i = 1; i < stringArray.length; ++i) {
                String string = stringArray[i];
                System.out.print("String             [" + string + "]");
                System.out.println(" -> match = " + stringMatcher.matches(stringArray[i]));
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

