/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans.actions.desktop;

import com.install4j.api.actions.AutoUninstallAction;
import com.install4j.api.context.Context;
import com.install4j.api.context.InstallerContext;
import com.install4j.api.context.UninstallerContext;
import com.install4j.api.context.UserCanceledException;
import com.install4j.runtime.beans.actions.SystemInstallAction;
import com.install4j.runtime.installer.helper.InstallerUtil;
import com.install4j.runtime.installer.helper.Logger;
import com.install4j.runtime.installer.helper.comm.ExecutionContext;
import com.install4j.runtime.installer.helper.comm.HelperCommunication;
import com.install4j.runtime.installer.helper.comm.actions.RunAction;
import com.install4j.runtime.installer.platform.macos.PlistHelper;
import com.install4j.runtime.installer.platform.unix.Execution;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.Properties;

public class AddToDockAction
extends SystemInstallAction
implements AutoUninstallAction {
    private Properties persistentProperties = new Properties();
    private File executable;
    private static final String PROPNAME_EXECUTABLE = "executable";
    private static final String PLIST_NAME = "com.apple.dock";
    private static final String ARRAY_NAME = "persistent-apps";
    private static final String TILE_DATA_KEY = "tile-data";
    private static final String FILE_DATA_KEY = "file-data";
    private static final String CF_URL_STRING_KEY = "_CFURLString";

    @Override
    public boolean install(InstallerContext context) throws UserCanceledException {
        if (InstallerUtil.isMacOS()) {
            Object[][] dict;
            File destinationFile = context.getDestinationFile(this.getExecutable());
            String fileName = destinationFile.getAbsolutePath() + "/";
            AddToDockAction.doRollback(fileName);
            String fileUrl = AddToDockAction.getFileUrl(destinationFile);
            String label = destinationFile.getName();
            if (label.endsWith(".app")) {
                label = label.substring(0, label.length() - 4);
            }
            if (PlistHelper.addToPlist(PLIST_NAME, ARRAY_NAME, dict = new Object[][]{{TILE_DATA_KEY, "tile-type"}, {new Object[][]{{"dock-extra", FILE_DATA_KEY, "file-label"}, {Boolean.FALSE, new Object[][]{{CF_URL_STRING_KEY, "_CFURLStringType"}, {fileUrl, 15}}, label}}, "file-tile"}})) {
                this.getPersistentProperties().setProperty(PROPNAME_EXECUTABLE, fileName);
                this.restartDock();
            } else {
                return false;
            }
        }
        return true;
    }

    private static String getFileUrl(File destinationFile) {
        String fileUrl = "";
        try {
            fileUrl = destinationFile.toURI().toURL().toString();
        }
        catch (MalformedURLException e) {
            Logger.getImpl().log(e);
        }
        return fileUrl;
    }

    private void restartDock() {
        try {
            Execution.executeAndWait(new String[]{"killall", "Dock"}, null);
        }
        catch (IOException e) {
            Logger.getInstance().log(e);
        }
    }

    @Override
    public Properties getPersistentProperties() {
        return this.persistentProperties;
    }

    @Override
    public void setPersistentProperties(Properties properties) {
        this.persistentProperties = properties;
    }

    @Override
    public void rollback(InstallerContext context) {
        if (InstallerUtil.isMacOS()) {
            AddToDockAction.doRollback(context.getDestinationFile(this.getExecutable()).getAbsolutePath() + "/");
            this.restartDock();
        }
    }

    @Override
    public boolean uninstall(UninstallerContext context) throws UserCanceledException {
        if (InstallerUtil.isMacOS()) {
            AddToDockAction.doRollback(this.getPersistentProperties().getProperty(PROPNAME_EXECUTABLE));
            this.restartDock();
        }
        return true;
    }

    private static void doRollback(final String executable) {
        HelperCommunication.getInstance().executeAction(ExecutionContext.UNELEVATED, new RunAction(){

            @Override
            protected void run(Context context) throws Exception {
                if (executable != null) {
                    try {
                        String executableUrl = AddToDockAction.getFileUrl(new File(executable)).replaceAll("file:/*", "/");
                        if (PlistHelper.removeElementWithChild(AddToDockAction.PLIST_NAME, AddToDockAction.ARRAY_NAME, new String[]{AddToDockAction.TILE_DATA_KEY, AddToDockAction.FILE_DATA_KEY, AddToDockAction.CF_URL_STRING_KEY}, executableUrl, true) || PlistHelper.removeElementWithChild(AddToDockAction.PLIST_NAME, AddToDockAction.ARRAY_NAME, new String[]{AddToDockAction.TILE_DATA_KEY, AddToDockAction.FILE_DATA_KEY, AddToDockAction.CF_URL_STRING_KEY}, executable, true)) {
                            PlistHelper.flushCache();
                        } else {
                            Logger.getInstance().error(null, "removing not successful: " + executableUrl);
                        }
                    }
                    catch (IOException e) {
                        Logger.getInstance().log(e);
                    }
                }
            }
        });
    }

    public File getExecutable() {
        return AddToDockAction.replaceVariables(this.executable);
    }

    public void setExecutable(File executable) {
        this.executable = executable;
    }
}

