/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans.actions.files;

import com.exe4j.runtime.util.FileUtil;
import com.install4j.api.beans.ActionList;
import com.install4j.api.context.Context;
import com.install4j.api.context.InstallerContext;
import com.install4j.api.context.UserCanceledException;
import com.install4j.runtime.beans.actions.files.AbstractZipFileAction;
import com.install4j.runtime.beans.actions.files.BackupFileForRollbackAction;
import com.install4j.runtime.beans.actions.files.CreateZipFileAction;
import com.install4j.runtime.installer.ProgressAdapterContext;
import com.install4j.runtime.installer.frontend.ProgressAdapter;
import com.install4j.runtime.installer.helper.Logger;
import java.io.File;
import java.io.IOException;

public class ModifyZipFileAction
extends AbstractZipFileAction {
    private ActionList actionList;
    private File tempDir;

    public ActionList getActionList() {
        return this.actionList;
    }

    public void setActionList(ActionList actionList) {
        this.actionList = actionList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean zipActions(Context context, File usedSourceFile) throws IOException, UserCanceledException {
        if (this.actionList == null) {
            Logger.getInstance().log(this, "Nothing to do because no modification actions are configured.", true);
            return true;
        }
        this.tempDir = File.createTempFile("install4j", "dir");
        this.tempDir.delete();
        if (!this.tempDir.mkdir()) {
            throw new IOException("Could not create temporary directory " + this.tempDir);
        }
        if (context instanceof InstallerContext && !this.isSuppressRollback()) {
            BackupFileForRollbackAction backupFileForRollbackAction = new BackupFileForRollbackAction(usedSourceFile, false, false, false);
            backupFileForRollbackAction.install((InstallerContext)context);
            this.addRollbackAction(backupFileForRollbackAction);
        }
        try {
            boolean bl = super.zipActions(context, usedSourceFile) && this.executeActionList(context) && this.createZipFile(context);
            return bl;
        }
        finally {
            FileUtil.deleteDirectory(this.tempDir);
        }
    }

    private boolean executeActionList(Context context) throws UserCanceledException {
        this.overrideVariable("sys.overriddenTargetDir", this.tempDir, context);
        this.overrideVariable("sys.actionSuppressRollback", true, context);
        try {
            boolean bl = ModifyZipFileAction.executeActionListSync(this.actionList, new Object[0]);
            return bl;
        }
        finally {
            this.restoreVariables(context);
        }
    }

    private boolean createZipFile(Context context) throws UserCanceledException {
        CreateZipFileAction createZipFileAction = new CreateZipFileAction();
        createZipFileAction.setZipFile(this.getZipFile());
        createZipFileAction.setFiles(new File[]{this.tempDir});
        createZipFileAction.setShowProgress(this.isShowProgress());
        createZipFileAction.setShowFileNames(false);
        ProgressAdapter progressAdapter = new ProgressAdapter(context.getProgressInterface(), this.getExtractionPercent(), 100);
        return createZipFileAction.execute(new ProgressAdapterContext(context, progressAdapter));
    }

    @Override
    protected File getTargetDirectory(Context context) {
        return this.tempDir;
    }

    @Override
    protected boolean passesFileFilter(String entryName, Context context) {
        return true;
    }

    @Override
    protected int getExtractionPercent() {
        return 50;
    }

    @Override
    public boolean isShowFileNames() {
        return false;
    }
}

