/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans.actions.registry;

import com.install4j.api.context.Context;
import com.install4j.runtime.beans.actions.registry.PreferenceReadType;
import com.install4j.runtime.beans.actions.registry.PreferencesAction;
import com.install4j.runtime.installer.helper.Logger;
import com.install4j.runtime.installer.helper.PreferencesUtil;
import com.install4j.runtime.installer.helper.comm.ExecutionContext;
import com.install4j.runtime.installer.helper.comm.HelperCommunication;
import com.install4j.runtime.installer.helper.comm.actions.FetchBooleanAction;
import java.io.Serializable;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;

public abstract class PreferencesReadAction
extends PreferencesAction {
    private PreferenceReadType preferenceReadType = PreferenceReadType.USER;

    public PreferenceReadType getPreferenceReadType() {
        return this.preferenceReadType;
    }

    public void setPreferenceReadType(PreferenceReadType preferenceReadType) {
        this.preferenceReadType = preferenceReadType;
    }

    @Override
    public boolean isRollbackSupported() {
        return false;
    }

    protected boolean executePreferencesReader(PreferencesReader preferencesReader, Context context) {
        boolean success = false;
        if (this.preferenceReadType == PreferenceReadType.SYSTEM || this.preferenceReadType == PreferenceReadType.SYSTEM_THEN_USER) {
            success |= PreferencesReadAction.executePreferencesReader(preferencesReader, this.getPackageName(), false, context);
        }
        if (this.preferenceReadType == PreferenceReadType.USER || this.preferenceReadType == PreferenceReadType.SYSTEM_THEN_USER) {
            success |= PreferencesReadAction.executePreferencesReader(preferencesReader, this.getPackageName(), true, context);
        }
        return success;
    }

    private static boolean executePreferencesReader(PreferencesReader preferencesReader, String packageName, boolean userSpecific, Context context) {
        if (HelperCommunication.getInstance().isElevatedHelper() && userSpecific) {
            return PreferencesReadAction.executePreferencesReaderUnelevated(preferencesReader, packageName);
        }
        try {
            PreferencesUtil.getRootNode(userSpecific).sync();
            Preferences packageNode = PreferencesUtil.getPackageNodeNoCreation(packageName, userSpecific);
            if (packageNode != null) {
                packageNode.sync();
                return preferencesReader.readFromPreferences(packageNode, context);
            }
            Logger.getInstance().log(null, "Package " + packageName + " does not exist", false);
        }
        catch (Exception e) {
            Logger.getInstance().log(e);
        }
        return false;
    }

    private static boolean executePreferencesReaderUnelevated(final PreferencesReader preferencesReader, final String packageName) {
        return HelperCommunication.getInstance().fetchBoolean(ExecutionContext.UNELEVATED, new FetchBooleanAction(){

            @Override
            protected boolean fetchValue(Context context) throws Exception {
                return PreferencesReadAction.executePreferencesReader(preferencesReader, packageName, true, context);
            }
        });
    }

    public static interface PreferencesReader
    extends Serializable {
        public boolean readFromPreferences(Preferences var1, Context var2) throws BackingStoreException;
    }
}

