/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans.screens.componentselection;

import com.install4j.runtime.beans.screens.componentselection.ComponentCellHandler;
import com.install4j.runtime.beans.screens.componentselection.ComponentFolderNode;
import com.install4j.runtime.beans.screens.componentselection.ComponentNode;
import com.install4j.runtime.beans.screens.componentselection.ComponentTreeModel;
import com.install4j.runtime.beans.screens.componentselection.DescriptionModeProvider;
import com.install4j.runtime.installer.config.ComponentNodeConfig;
import java.awt.ComponentOrientation;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.Enumeration;
import java.util.Objects;
import javax.swing.Icon;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.text.Position;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public abstract class ComponentTree
extends JTree {
    private DescriptionModeProvider descriptionModeProvider;
    private ComponentCellHandler renderer;
    private ComponentCellHandler editor;
    private boolean isInStartEditing = false;

    public ComponentTree(DescriptionModeProvider descriptionModeProvider) {
        this.descriptionModeProvider = descriptionModeProvider;
        this.setupControls();
        this.setupComponent();
        this.setupEventHandlers();
    }

    protected abstract ComponentTreeModel createTreeModel();

    public abstract String getIconTooltip(ComponentNodeConfig var1);

    public abstract Icon getLeafIcon(ComponentNodeConfig var1);

    public abstract int getLeafIconWidth();

    public DescriptionModeProvider getDescriptionModeProvider() {
        return this.descriptionModeProvider;
    }

    protected void setupControls() {
        this.renderer = this.createComponentCellHandler();
        this.editor = this.createComponentCellHandler();
    }

    @Override
    public void applyComponentOrientation(ComponentOrientation o) {
        super.applyComponentOrientation(o);
        this.renderer.applyComponentOrientation(o);
        this.editor.applyComponentOrientation(o);
    }

    protected ComponentCellHandler createComponentCellHandler() {
        return new ComponentCellHandler(this);
    }

    protected void setupComponent() {
        this.setRootVisible(false);
        ComponentTreeModel model = this.createTreeModel();
        this.setVisibleRowCount(5);
        this.setModel(model);
        this.setCellRenderer(this.renderer);
        this.setCellEditor(this.editor);
        this.modelSet();
        this.setRowHeight(0);
        this.setInvokesStopCellEditing(true);
        this.setEditable(true);
        this.getSelectionModel().setSelectionMode(1);
        DefaultMutableTreeNode rootNode = (DefaultMutableTreeNode)model.getRoot();
        int childCount = rootNode.getChildCount();
        boolean topLevelOnly = true;
        for (int i = 0; i < childCount; ++i) {
            if (rootNode.getChildAt(i).getChildCount() <= 0) continue;
            topLevelOnly = false;
            break;
        }
        this.setShowsRootHandles(!topLevelOnly);
    }

    protected void modelSet() {
    }

    protected void setupEventHandlers() {
        this.addMouseListener(new ComponentTreeMouseListener());
        this.addKeyListener(new ComponentTreeKeyListener());
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                ComponentTree.this.resized();
            }
        });
        this.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                TreePath editingPath;
                TreePath path = ComponentTree.this.getPathForLocation(e.getX(), e.getY());
                if (path != null && !Objects.equals(editingPath = ComponentTree.this.getEditingPath(), path)) {
                    ComponentTree.this.startEditingAtPath(path);
                }
            }
        });
        this.editor.addCellEditorListener(new CellEditorListener(){

            @Override
            public void editingCanceled(ChangeEvent e) {
                ComponentTree.this.requestFocus();
            }

            @Override
            public void editingStopped(ChangeEvent e) {
            }
        });
        ToolTipManager.sharedInstance().registerComponent(this);
    }

    private void resized() {
        this.stopEditing();
        int rowCount = this.getRowCount();
        for (int row = 0; row < rowCount; ++row) {
            TreePath path = this.getPathForRow(row);
            this.startEditingAtPath(path);
            this.stopEditing();
        }
    }

    public void updateAllNodes() {
        DefaultTreeModel model = (DefaultTreeModel)this.getModel();
        Enumeration<TreeNode> en = ((DefaultMutableTreeNode)model.getRoot()).depthFirstEnumeration();
        while (en.hasMoreElements()) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)en.nextElement();
            model.nodeChanged(node);
        }
    }

    @Override
    public String getToolTipText(MouseEvent event) {
        Point p;
        if (event != null && (p = this.initRenderer(event)) != null) {
            return this.renderer.getToolTipText(p);
        }
        return null;
    }

    @Override
    public void startEditingAtPath(TreePath path) {
        this.isInStartEditing = true;
        try {
            super.startEditingAtPath(path);
        }
        finally {
            this.isInStartEditing = false;
        }
    }

    @Override
    public void scrollRectToVisible(Rectangle rect) {
        if (!this.isInStartEditing && this.getEditingPath() == null) {
            super.scrollRectToVisible(rect);
        }
    }

    @Override
    public void scrollPathToVisible(TreePath path) {
        if (!this.isInStartEditing && this.getEditingPath() == null) {
            super.scrollPathToVisible(path);
        }
    }

    @Override
    public TreePath getNextMatch(String prefix, int startingRow, Position.Bias bias) {
        return null;
    }

    @Override
    public void removeSelectionRow(int row) {
    }

    private Point initRenderer(MouseEvent event) {
        TreePath path = this.getPathForLocation(event.getX(), event.getY());
        if (path == null) {
            return null;
        }
        int row = this.getRowForLocation(event.getX(), event.getY());
        Rectangle bounds = this.getRowBounds(row);
        Point point = event.getPoint();
        point.translate(-bounds.x, -bounds.y);
        this.renderer.getTreeCellRendererComponent(this, path.getLastPathComponent(), false, false, true, 0, false);
        this.renderer.setSize(this.renderer.getPreferredSize());
        this.renderer.doLayout();
        return point;
    }

    public void nodeToggled() {
    }

    public void selectionChanged(ComponentNode componentNode, boolean dependency) {
    }

    private class ComponentTreeKeyListener
    extends KeyAdapter {
        private ComponentTreeKeyListener() {
        }

        @Override
        public void keyPressed(KeyEvent event) {
            TreePath path;
            if (event.getKeyCode() == 112) {
                ComponentNode node;
                ComponentNodeConfig componentNodeConfig;
                TreePath selectionPath = ComponentTree.this.getSelectionPath();
                if (!(selectionPath == null || (componentNodeConfig = (node = (ComponentNode)selectionPath.getLastPathComponent()).getComponentNodeConfig()).isHideHelpButton() && componentNodeConfig.isInitialDisplayDescription())) {
                    node.toggleDisplayDescription();
                }
            } else if (event.getKeyCode() == 32 && (path = ComponentTree.this.getSelectionPath()) != null) {
                ComponentTree.this.stopEditing();
                Object node = path.getLastPathComponent();
                ComponentNode componentNode = (ComponentNode)node;
                if (componentNode instanceof ComponentFolderNode && componentNode.isSelected() && !((ComponentFolderNode)componentNode).isAllSelected()) {
                    componentNode.setSelected(true, true);
                } else {
                    componentNode.setSelected(!componentNode.isSelected(), true);
                }
                ((DefaultTreeModel)ComponentTree.this.getModel()).nodeChanged(componentNode);
                event.consume();
                ComponentTree.this.startEditingAtPath(path);
            }
        }
    }

    private class ComponentTreeMouseListener
    extends MouseAdapter {
        private ComponentTreeMouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent event) {
            if (event.getClickCount() == 2) {
                TreePath path = ComponentTree.this.getPathForLocation(event.getX(), event.getY());
                Point point = ComponentTree.this.initRenderer(event);
                if (point == null) {
                    return;
                }
                if (ComponentTree.this.renderer.isPointInLabel(point)) {
                    if (ComponentTree.this.isExpanded(path)) {
                        ComponentTree.this.collapsePath(path);
                    } else {
                        ComponentTree.this.expandPath(path);
                    }
                }
            }
        }

        @Override
        public void mousePressed(MouseEvent event) {
            if (!ComponentTree.this.isEnabled()) {
                return;
            }
            TreePath path = ComponentTree.this.getPathForLocation(event.getX(), event.getY());
            Point point = ComponentTree.this.initRenderer(event);
            if (point == null) {
                return;
            }
            if (ComponentTree.this.renderer.isPointInLabel(point)) {
                ComponentTree.this.stopEditing();
                ComponentTree.this.setSelectionPath(path);
            }
        }
    }
}

