/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.platform.macos;

import com.install4j.runtime.installer.helper.InstallerUtil;
import com.install4j.runtime.installer.helper.Logger;
import com.install4j.runtime.installer.helper.launching.LaunchDescriptor;
import com.install4j.runtime.installer.helper.launching.LaunchHelper;
import com.install4j.runtime.installer.platform.unix.UnixUserInfo;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.Map;

public class MacosUserInfo {
    public static final String ELEVATION_EXECUTABLE = "install4j";

    public static boolean isAdminUser() {
        try {
            String line;
            if (UnixUserInfo.ROOT_USER) {
                return true;
            }
            Process process = Runtime.getRuntime().exec("groups");
            BufferedReader br = new BufferedReader(new InputStreamReader(process.getInputStream()));
            boolean containsAdmin = false;
            while ((line = br.readLine()) != null) {
                if (!line.contains("admin")) continue;
                containsAdmin = true;
            }
            return containsAdmin;
        }
        catch (IOException e) {
            e.printStackTrace();
            return true;
        }
    }

    public static boolean executeElevated(String executable, String arguments, String directory, Map environmentVariables) {
        File elevationUtil = InstallerUtil.getInstallerFile(ELEVATION_EXECUTABLE);
        if (!elevationUtil.exists()) {
            return false;
        }
        try {
            File scriptFile = MacosUserInfo.createScriptFile(executable, arguments, environmentVariables);
            Integer retVal = LaunchHelper.launchApplication(new LaunchDescriptor(elevationUtil).workingDirectory(new File(directory)).arguments(scriptFile.getAbsolutePath()).wait(true));
            if (retVal == null || retVal != 0) {
                Logger.getInstance().error(MacosUserInfo.class, "return value is " + retVal);
                return false;
            }
            return true;
        }
        catch (IOException e) {
            Logger.getInstance().info(MacosUserInfo.class, e.toString());
            e.printStackTrace();
            return false;
        }
    }

    private static File createScriptFile(String executable, String arguments, Map environmentVariables) throws IOException {
        File scriptFile = File.createTempFile("i4j", ".sh");
        PrintWriter pw = new PrintWriter(new OutputStreamWriter((OutputStream)new BufferedOutputStream(new FileOutputStream(scriptFile)), "UTF-8"));
        pw.println("#!/bin/sh");
        if (environmentVariables != null) {
            for (Map.Entry entry : environmentVariables.entrySet()) {
                pw.println(entry.getKey() + "=\"" + entry.getValue() + "\"");
                pw.println("export " + entry.getKey());
            }
        }
        pw.print("\"" + executable + "\"");
        if (arguments != null) {
            pw.print(" " + arguments);
        }
        pw.println();
        pw.println("rm $0");
        pw.println("exit 0");
        pw.close();
        return scriptFile;
    }
}

