/*
 * Decompiled with CFR 0.152.
 */
package gsfc.nssdc.cdf;

import gsfc.nssdc.cdf.CDFConstants;
import gsfc.nssdc.cdf.CDFException;
import gsfc.nssdc.cdf.CDFObject;
import gsfc.nssdc.cdf.Variable;
import gsfc.nssdc.cdf.util.CDFTT2000;
import gsfc.nssdc.cdf.util.CDFUtils;
import gsfc.nssdc.cdf.util.Epoch;
import gsfc.nssdc.cdf.util.Epoch16;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.Vector;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class CDFData
implements CDFObject,
CDFConstants {
    private Variable _myVar;
    private Object _data;
    private Object _dataArray;
    private long id;
    private long cdfID;
    private long numValues;
    private long numElements;
    private long numDims;
    private long[] varDimSizes;
    private String dataSignature;
    private long dataType;
    private int nDims;
    private int[] dimSizes;
    private long recStart;
    private long recCount;
    private long recInterval;
    private long[] dimIndices;
    private long[] dimCounts;
    private long[] dimIntervals;

    public Object getData() {
        return this._dataArray;
    }

    public Object getRawData() {
        return this._data;
    }

    public int getnDims() {
        return this.nDims;
    }

    public int[] getDimSizes() {
        return this.dimSizes;
    }

    public long getRecStart() {
        return this.recStart;
    }

    public long getRecCount() {
        return this.recCount;
    }

    public long getRecInterval() {
        return this.recInterval;
    }

    public long[] getDimIndices() {
        return this.dimIndices;
    }

    public long[] getDimCounts() {
        return this.dimCounts;
    }

    public long[] getDimIntervals() {
        return this.dimIntervals;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected static final CDFData get(Variable variable, long l, long l2, long l3, long[] lArray, long[] lArray2, long[] lArray3) throws CDFException {
        Variable variable2 = variable;
        synchronized (variable2) {
            CDFData cDFData;
            block4: {
                block3: {
                    cDFData = new CDFData(variable);
                    cDFData.recStart = l;
                    cDFData.recCount = l2;
                    cDFData.recInterval = l3;
                    if (variable.getNumDims() <= 0L) break block3;
                    cDFData.dimIndices = lArray;
                    cDFData.dimCounts = lArray2;
                    cDFData.dimIntervals = lArray3;
                    break block4;
                }
                cDFData.dimIndices = new long[1];
                cDFData.dimCounts = new long[]{1L};
                cDFData.dimIntervals = new long[]{1L};
            }
            cDFData.initDimAndSizes();
            Vector<Serializable> vector = new Vector<Serializable>();
            Vector<String> vector2 = new Vector<String>();
            Vector<String> vector3 = new Vector<String>();
            Vector<String> vector4 = new Vector<String>();
            Vector<String> vector5 = new Vector<String>();
            Vector<String> vector6 = new Vector<String>();
            Vector<String> vector7 = new Vector<String>();
            Vector<String> vector8 = new Vector<String>();
            Vector<String> vector9 = new Vector<String>();
            Vector<String> vector10 = new Vector<String>();
            cDFData.buildDataObject();
            vector.addElement(new Long(1005L));
            vector.addElement(new Long(1L));
            vector10.addElement("cdfID");
            vector10.addElement("J");
            vector.addElement(vector10);
            vector.addElement(new Long(57L));
            vector2.addElement("id");
            vector2.addElement("J");
            vector.addElement(vector2);
            vector.addElement(new Long(79L));
            vector3.addElement("recStart");
            vector3.addElement("J");
            vector.addElement(vector3);
            vector.addElement(new Long(80L));
            vector4.addElement("recCount");
            vector4.addElement("J");
            vector.addElement(vector4);
            vector.addElement(new Long(81L));
            vector5.addElement("recInterval");
            vector5.addElement("J");
            vector.addElement(vector5);
            vector.addElement(new Long(82L));
            vector6.addElement("dimIndices");
            vector6.addElement("[J");
            vector.addElement(vector6);
            vector.addElement(new Long(83L));
            vector7.addElement("dimCounts");
            vector7.addElement("[J");
            vector.addElement(vector7);
            vector.addElement(new Long(84L));
            vector8.addElement("dimIntervals");
            vector8.addElement("[J");
            vector.addElement(vector8);
            vector.addElement(new Long(1007L));
            vector.addElement(new Long(67L));
            vector9.addElement("_data");
            vector9.addElement("Ljava/lang/Object;");
            vector.addElement(vector9);
            vector.addElement(new Long(1000L));
            cDFData._myVar.getMyCDF().executeCommand(cDFData, vector);
            cDFData.arrayify();
            return cDFData;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected static final CDFData put(Variable variable, long l, long l2, long l3, long[] lArray, long[] lArray2, long[] lArray3, Object object) throws CDFException {
        Variable variable2 = variable;
        synchronized (variable2) {
            String string = object.getClass().getName();
            switch ((int)variable.getDataType()) {
                case 51: 
                case 52: {
                    if (string.indexOf("java.lang.String") != -1 || string.indexOf("[B") != -1) break;
                    throw new CDFException(-2112L);
                }
                case 1: 
                case 41: {
                    if (string.indexOf("[B") != -1 || string.indexOf("Byte") != -1) break;
                    throw new CDFException(-2112L);
                }
                case 2: 
                case 11: {
                    if (string.indexOf("[S") != -1 || string.indexOf("Short") != -1) break;
                    throw new CDFException(-2112L);
                }
                case 4: 
                case 12: {
                    if (string.indexOf("[I") != -1 || string.indexOf("Integer") != -1) break;
                    throw new CDFException(-2112L);
                }
                case 14: {
                    if (string.indexOf("[J") != -1 || string.indexOf("Long") != -1) break;
                    throw new CDFException(-2112L);
                }
                case 8: 
                case 33: {
                    if (string.indexOf("[J") != -1 || string.indexOf("Long") != -1) break;
                    throw new CDFException(-2112L);
                }
                case 21: 
                case 44: {
                    if (string.indexOf("[F") != -1 || string.indexOf("Float") != -1) break;
                    throw new CDFException(-2112L);
                }
                case 22: 
                case 31: 
                case 45: {
                    if (string.indexOf("[D") != -1 || string.indexOf("Double") != -1) break;
                    throw new CDFException(-2112L);
                }
                case 32: {
                    string.indexOf("[D");
                    break;
                }
            }
            CDFData cDFData = new CDFData(variable);
            cDFData._dataArray = object;
            cDFData.recStart = l;
            cDFData.recCount = l2;
            cDFData.recInterval = l3;
            cDFData.dimIndices = lArray;
            cDFData.dimCounts = lArray2;
            cDFData.dimIntervals = lArray3;
            cDFData.initDimAndSizes();
            cDFData.vectorize();
            cDFData.dataSignature = CDFUtils.getSignature(cDFData._data);
            Vector<Serializable> vector = new Vector<Serializable>();
            Vector<String> vector2 = new Vector<String>();
            Vector<String> vector3 = new Vector<String>();
            Vector<String> vector4 = new Vector<String>();
            Vector<String> vector5 = new Vector<String>();
            Vector<String> vector6 = new Vector<String>();
            Vector<String> vector7 = new Vector<String>();
            Vector<String> vector8 = new Vector<String>();
            Vector<String> vector9 = new Vector<String>();
            Vector<String> vector10 = new Vector<String>();
            vector.addElement(new Long(1005L));
            vector.addElement(new Long(1L));
            vector10.addElement("cdfID");
            vector10.addElement("J");
            vector.addElement(vector10);
            vector.addElement(new Long(57L));
            vector2.addElement("id");
            vector2.addElement("J");
            vector.addElement(vector2);
            vector.addElement(new Long(79L));
            vector3.addElement("recStart");
            vector3.addElement("J");
            vector.addElement(vector3);
            vector.addElement(new Long(80L));
            vector4.addElement("recCount");
            vector4.addElement("J");
            vector.addElement(vector4);
            vector.addElement(new Long(81L));
            vector5.addElement("recInterval");
            vector5.addElement("J");
            vector.addElement(vector5);
            vector.addElement(new Long(82L));
            vector6.addElement("dimIndices");
            vector6.addElement("[J");
            vector.addElement(vector6);
            vector.addElement(new Long(83L));
            vector7.addElement("dimCounts");
            vector7.addElement("[J");
            vector.addElement(vector7);
            vector.addElement(new Long(84L));
            vector8.addElement("dimIntervals");
            vector8.addElement("[J");
            vector.addElement(vector8);
            vector.addElement(new Long(1008L));
            vector.addElement(new Long(67L));
            vector9.addElement("_data");
            vector9.addElement("Ljava/lang/Object;");
            vector.addElement(vector9);
            vector.addElement(new Long(1000L));
            cDFData._myVar.getMyCDF().executeCommand(cDFData, vector);
            return cDFData;
        }
    }

    private final long product(int[] nArray, int n, int n2) {
        long l = 1L;
        int n3 = n;
        while (n3 < n2) {
            if (nArray[n3] > 1) {
                l *= (long)nArray[n3];
            }
            ++n3;
        }
        return l;
    }

    private final void arrayify() throws CDFException {
        if (this.nDims <= 1 || this.numValues == 1L) {
            if (this.dataType == 51L || this.dataType == 52L) {
                if (this.nDims == 0) {
                    this._dataArray = new String((byte[])this._data);
                } else {
                    this.buildDataArray();
                    int n = 0;
                    byte[] byArray = new byte[(int)this.numElements];
                    int n2 = 0;
                    while (n2 < this.dimSizes[0]) {
                        System.arraycopy(this._data, n, byArray, 0, (int)this.numElements);
                        Array.set(this._dataArray, n2, new String(byArray));
                        n = (int)((long)n + this.numElements);
                        ++n2;
                    }
                }
            } else {
                this._dataArray = this._data;
            }
        } else {
            this.buildDataArray();
            Object[] objectArray = null;
            Object[] objectArray2 = new Object[this.nDims - 1];
            int[] nArray = new int[this.nDims - 1];
            long[] lArray = new long[this.nDims - 1];
            objectArray2[0] = this._dataArray;
            nArray[0] = 0;
            lArray[0] = this.product(this.dimSizes, 0, this.nDims);
            int n = 1;
            while (n < this.nDims - 1) {
                objectArray2[n] = Array.get(objectArray2[n - 1], 0);
                lArray[n] = this.product(this.dimSizes, n, this.nDims);
                nArray[n] = 0;
                ++n;
            }
            n = 0;
            Object object = this._dataArray;
            while ((long)n < this.numValues) {
                int n3;
                if (n != 0) {
                    n3 = 0;
                    while (n3 < this.nDims - 1) {
                        boolean bl;
                        boolean bl2 = false;
                        if ((long)n % lArray[n3] == 0L) {
                            bl2 = true;
                        }
                        if (bl = bl2) {
                            int n4 = n3;
                            nArray[n4] = nArray[n4] + 1;
                            objectArray2[n3] = object = Array.get(object, nArray[n3]);
                            int n5 = n3 + 1;
                            while (n5 < this.nDims - 1) {
                                nArray[n5] = 0;
                                objectArray2[n5] = Array.get(objectArray2[n5 - 1], 0);
                                ++n5;
                            }
                            break;
                        }
                        object = objectArray2[n3];
                        ++n3;
                    }
                }
                n3 = 0;
                while (n3 < this.dimSizes[this.nDims - 2]) {
                    switch ((int)this._myVar.getDataType()) {
                        case 51: 
                        case 52: {
                            byte[] byArray = new byte[(int)this.numElements];
                            objectArray = new String[this.dimSizes[this.nDims - 1]];
                            int n6 = 0;
                            while (n6 < this.dimSizes[this.nDims - 1]) {
                                System.arraycopy(this._data, n, byArray, 0, (int)this.numElements);
                                ((String[])objectArray)[n6] = new String(byArray);
                                n = (int)((long)n + this.numElements);
                                ++n6;
                            }
                            break;
                        }
                        case 1: 
                        case 41: {
                            objectArray = new byte[this.dimSizes[this.nDims - 1]];
                            System.arraycopy(this._data, n, objectArray, 0, this.dimSizes[this.nDims - 1]);
                            n += this.dimSizes[this.nDims - 1];
                            break;
                        }
                        case 2: 
                        case 11: {
                            objectArray = new short[this.dimSizes[this.nDims - 1]];
                            System.arraycopy(this._data, n, objectArray, 0, this.dimSizes[this.nDims - 1]);
                            n += this.dimSizes[this.nDims - 1];
                            break;
                        }
                        case 4: 
                        case 12: {
                            objectArray = new int[this.dimSizes[this.nDims - 1]];
                            System.arraycopy(this._data, n, objectArray, 0, this.dimSizes[this.nDims - 1]);
                            n += this.dimSizes[this.nDims - 1];
                            break;
                        }
                        case 14: {
                            objectArray = new long[this.dimSizes[this.nDims - 1]];
                            System.arraycopy(this._data, n, objectArray, 0, this.dimSizes[this.nDims - 1]);
                            n += this.dimSizes[this.nDims - 1];
                            break;
                        }
                        case 8: 
                        case 33: {
                            objectArray = new long[this.dimSizes[this.nDims - 1]];
                            System.arraycopy(this._data, n, objectArray, 0, this.dimSizes[this.nDims - 1]);
                            n += this.dimSizes[this.nDims - 1];
                            break;
                        }
                        case 21: 
                        case 44: {
                            objectArray = new float[this.dimSizes[this.nDims - 1]];
                            System.arraycopy(this._data, n, objectArray, 0, this.dimSizes[this.nDims - 1]);
                            n += this.dimSizes[this.nDims - 1];
                            break;
                        }
                        case 22: 
                        case 31: 
                        case 45: {
                            objectArray = new double[this.dimSizes[this.nDims - 1]];
                            System.arraycopy(this._data, n, objectArray, 0, this.dimSizes[this.nDims - 1]);
                            n += this.dimSizes[this.nDims - 1];
                            break;
                        }
                        case 32: {
                            objectArray = new double[2 * this.dimSizes[this.nDims - 1]];
                            System.arraycopy(this._data, n, objectArray, 0, 2 * this.dimSizes[this.nDims - 1]);
                            n += 2 * this.dimSizes[this.nDims - 1];
                            break;
                        }
                    }
                    Array.set(objectArray2[this.nDims - 2], n3, objectArray);
                    ++n3;
                }
            }
        }
    }

    private final void vectorize() throws CDFException {
        if (this.nDims <= 1 || this.numValues == 1L) {
            if (this.dataType == 51L || this.dataType == 52L) {
                String string = this._dataArray.getClass().getName();
                if (string.indexOf("[B") == -1) {
                    int n = 0;
                    if (this.nDims == 0) {
                        this._data = new byte[(int)this.numElements];
                        int n2 = 0;
                        while ((long)n2 < this.numElements) {
                            ((byte[])this._data)[n2] = 32;
                            ++n2;
                        }
                        System.arraycopy(((String)this._dataArray).getBytes(), 0, this._data, 0, ((String)this._dataArray).length());
                    } else {
                        this.buildDataObject();
                        int n3 = 0;
                        while (n3 < this.dimSizes[0]) {
                            System.arraycopy(((String[])this._dataArray)[n3].getBytes(), 0, this._data, n, ((String[])this._dataArray)[n3].length());
                            n = (int)((long)n + this.numElements);
                            ++n3;
                        }
                    }
                } else {
                    this._data = this._dataArray;
                }
            } else {
                this._data = this._dataArray;
            }
        } else {
            this.buildDataObject();
            Object[] objectArray = null;
            Object[] objectArray2 = new Object[this.nDims - 1];
            int[] nArray = new int[this.nDims - 1];
            long[] lArray = new long[this.nDims - 1];
            objectArray2[0] = this._dataArray;
            nArray[0] = 0;
            lArray[0] = this.product(this.dimSizes, 0, this.nDims);
            int n = 1;
            while (n < this.nDims - 1) {
                objectArray2[n] = Array.get(objectArray2[n - 1], 0);
                lArray[n] = this.product(this.dimSizes, n, this.nDims);
                nArray[n] = 0;
                ++n;
            }
            n = 0;
            Object object = this._dataArray;
            while ((long)n < this.numValues) {
                int n4;
                int n5;
                if (n != 0) {
                    n5 = 0;
                    while (n5 < this.nDims - 1) {
                        boolean bl;
                        boolean bl2 = false;
                        if ((long)n % lArray[n5] == 0L) {
                            bl2 = true;
                        }
                        if (bl = bl2) {
                            int n6 = n5;
                            nArray[n6] = nArray[n6] + 1;
                            objectArray2[n5] = object = Array.get(object, nArray[n5]);
                            n4 = n5 + 1;
                            while (n4 < this.nDims - 1) {
                                nArray[n4] = 0;
                                objectArray2[n4] = Array.get(objectArray2[n4 - 1], nArray[n4]);
                                ++n4;
                            }
                            break;
                        }
                        object = objectArray2[n5];
                        ++n5;
                    }
                }
                n5 = 0;
                while (n5 < this.dimSizes[this.nDims - 2]) {
                    switch ((int)this._myVar.getDataType()) {
                        case 51: 
                        case 52: {
                            objectArray = (String[])Array.get(objectArray2[this.nDims - 2], n5);
                            n4 = 0;
                            while (n4 < this.dimSizes[this.nDims - 1]) {
                                if (((String[])objectArray)[n4] != null) {
                                    System.arraycopy(((String[])objectArray)[n4].getBytes(), 0, this._data, n, ((String[])objectArray)[n4].length());
                                }
                                n = (int)((long)n + this.numElements);
                                ++n4;
                            }
                            break;
                        }
                        case 1: 
                        case 41: {
                            objectArray = (byte[])Array.get(objectArray2[this.nDims - 2], n5);
                            System.arraycopy(objectArray, 0, this._data, n, this.dimSizes[this.nDims - 1]);
                            n += this.dimSizes[this.nDims - 1];
                            break;
                        }
                        case 2: 
                        case 11: {
                            objectArray = new short[this.dimSizes[this.nDims - 1]];
                            objectArray = (short[])Array.get(objectArray2[this.nDims - 2], n5);
                            System.arraycopy(objectArray, 0, this._data, n, this.dimSizes[this.nDims - 1]);
                            n += this.dimSizes[this.nDims - 1];
                            break;
                        }
                        case 4: 
                        case 12: {
                            objectArray = (int[])Array.get(objectArray2[this.nDims - 2], n5);
                            System.arraycopy(objectArray, 0, this._data, n, this.dimSizes[this.nDims - 1]);
                            n += this.dimSizes[this.nDims - 1];
                            break;
                        }
                        case 14: {
                            objectArray = (long[])Array.get(objectArray2[this.nDims - 2], n5);
                            System.arraycopy(objectArray, 0, this._data, n, this.dimSizes[this.nDims - 1]);
                            n += this.dimSizes[this.nDims - 1];
                            break;
                        }
                        case 8: 
                        case 33: {
                            objectArray = (long[])Array.get(objectArray2[this.nDims - 2], n5);
                            System.arraycopy(objectArray, 0, this._data, n, this.dimSizes[this.nDims - 1]);
                            n += this.dimSizes[this.nDims - 1];
                            break;
                        }
                        case 21: 
                        case 44: {
                            objectArray = (float[])Array.get(objectArray2[this.nDims - 2], n5);
                            System.arraycopy(objectArray, 0, this._data, n, this.dimSizes[this.nDims - 1]);
                            n += this.dimSizes[this.nDims - 1];
                            break;
                        }
                        case 22: 
                        case 31: 
                        case 45: {
                            objectArray = (double[])Array.get(objectArray2[this.nDims - 2], n5);
                            System.arraycopy(objectArray, 0, this._data, n, this.dimSizes[this.nDims - 1]);
                            n += this.dimSizes[this.nDims - 1];
                            break;
                        }
                        case 32: {
                            objectArray = (double[])Array.get(objectArray2[this.nDims - 2], n5);
                            System.arraycopy(objectArray, 0, this._data, n, 2 * this.dimSizes[this.nDims - 1]);
                            n += 2 * this.dimSizes[this.nDims - 1];
                            break;
                        }
                    }
                    ++n5;
                }
            }
        }
    }

    private final void initDimAndSizes() {
        this.numValues = 1L;
        if (this._dataArray != null) {
            this.nDims = this._dataArray.getClass().getName().lastIndexOf("[") + 1;
            if (this._dataArray.getClass().isArray()) {
                Object object = this._dataArray;
                this.dimSizes = new int[this.nDims];
                int n = 0;
                while (n < this.nDims) {
                    this.dimSizes[n] = Array.getLength(object);
                    this.numValues *= (long)this.dimSizes[n];
                    object = Array.get(object, 0);
                    ++n;
                }
            } else {
                this.dimSizes = new int[1];
                this.dimSizes[0] = 1;
            }
            this.numValues *= this.numElements;
        } else {
            int n;
            int n2;
            int n3;
            int n4 = 0;
            if (this.recCount > 1L) {
                n4 = this.nDims = 1;
            }
            if ((n3 = this.dimCounts.length) == 1) {
                if (this.dimCounts[0] > 1L || this.numDims > 0L && this.varDimSizes[0] == 1L) {
                    ++this.nDims;
                }
            } else {
                n2 = 0;
                n = 0;
                while (n < n3) {
                    if (this.dimCounts[n] > 1L || this.varDimSizes[n] == 1L) {
                        ++this.nDims;
                    }
                    ++n;
                }
            }
            this.dimSizes = new int[this.nDims];
            if (this.nDims == 1) {
                this.dimSizes[0] = this.recCount > 1L ? (int)this.recCount : (int)this.dimCounts[0];
            } else if (this.recCount > 1L) {
                n2 = 0;
                this.dimSizes[0] = (int)this.recCount;
                n = 0;
                while ((long)n < this.numDims) {
                    if (this.dimCounts[n] > 1L || this.varDimSizes[n] == 1L) {
                        this.dimSizes[++n2] = (int)this.dimCounts[n];
                    }
                    ++n;
                }
            } else {
                n2 = -1;
                n = 0;
                while ((long)n < this.numDims) {
                    if (this.dimCounts[n] > 1L || this.varDimSizes[n] == 1L) {
                        this.dimSizes[++n2] = (int)this.dimCounts[n];
                    }
                    ++n;
                }
            }
            if (this.nDims > 0) {
                n2 = 0;
                while (n2 < this.nDims) {
                    this.numValues *= (long)this.dimSizes[n2];
                    ++n2;
                }
            }
            this.numValues *= this.numElements;
        }
    }

    private final void buildDataArray() throws CDFException {
        int[] nArray = new int[this.nDims - 1];
        System.arraycopy(this.dimSizes, 0, nArray, 0, this.nDims - 1);
        String string = null;
        switch ((int)this._myVar.getDataType()) {
            case 51: 
            case 52: {
                string = "java.lang.String";
                nArray = this.dimSizes;
                break;
            }
            case 1: 
            case 41: {
                string = "[B";
                break;
            }
            case 2: 
            case 11: {
                string = "[S";
                break;
            }
            case 4: 
            case 12: {
                string = "[I";
                break;
            }
            case 8: 
            case 14: 
            case 33: {
                string = "[J";
                break;
            }
            case 21: 
            case 44: {
                string = "[F";
                break;
            }
            case 22: 
            case 31: 
            case 45: {
                string = "[D";
                break;
            }
            case 32: {
                string = "[D";
                break;
            }
        }
        try {
            Class<?> clazz = Class.forName(string);
            this._dataArray = Array.newInstance(clazz, nArray);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new CDFException(-2022L);
        }
    }

    private final void buildDataObject() throws CDFException {
        int n = (int)this._myVar.getDataType();
        Object object = null;
        if (this._myVar.checkPadValueExistence()) {
            object = this._myVar.getPadValue();
        }
        switch (n) {
            case 51: 
            case 52: {
                this.dataSignature = "[B";
                this._data = new byte[(int)this.numValues];
                if (object == null) {
                    int n2 = 0;
                    while ((long)n2 < this.numValues) {
                        ((byte[])this._data)[n2] = n == 51 ? new Character(' ').toString().getBytes()[0] : new Character(' ').toString().getBytes()[0];
                        ++n2;
                    }
                } else {
                    byte[] byArray = ((String)object).getBytes();
                    int n3 = byArray.length;
                    int n4 = 0;
                    int n5 = 0;
                    while ((long)n4 < this.numValues) {
                        if (n5 == n3) {
                            n5 = 0;
                        }
                        ((byte[])this._data)[n4] = byArray[n5];
                        ++n4;
                        ++n5;
                    }
                }
                break;
            }
            case 1: 
            case 41: {
                if (this.numValues > 1L) {
                    this.dataSignature = "[B";
                    this._data = new byte[(int)this.numValues];
                    if (object == null) {
                        int n6 = 0;
                        while ((long)n6 < this.numValues) {
                            ((byte[])this._data)[n6] = n == 1 ? (byte)0 : 0;
                            ++n6;
                        }
                    } else {
                        int n7 = 0;
                        while ((long)n7 < this.numValues) {
                            ((byte[])this._data)[n7] = (Byte)object;
                            ++n7;
                        }
                    }
                    break;
                }
                this.dataSignature = "Ljava/lang/Byte;";
                if (object == null) {
                    if (n == 1) {
                        this._data = new Byte(0);
                        break;
                    }
                    this._data = new Byte(0);
                    break;
                }
                this._data = new Byte((Byte)object);
                break;
            }
            case 2: 
            case 11: {
                if (this.numValues > 1L) {
                    this.dataSignature = "[S";
                    this._data = new short[(int)this.numValues];
                    if (object == null) {
                        int n8 = 0;
                        while ((long)n8 < this.numValues) {
                            ((short[])this._data)[n8] = n == 2 ? (short)0 : 0;
                            ++n8;
                        }
                    } else {
                        int n9 = 0;
                        while ((long)n9 < this.numValues) {
                            ((short[])this._data)[n9] = (Short)object;
                            ++n9;
                        }
                    }
                    break;
                }
                this.dataSignature = "Ljava/lang/Short;";
                if (object == null) {
                    if (n == 2) {
                        this._data = new Short(0);
                        break;
                    }
                    this._data = new Short(0);
                    break;
                }
                this._data = new Short((Short)object);
                break;
            }
            case 4: 
            case 12: {
                if (this.numValues > 1L) {
                    this.dataSignature = "[I";
                    this._data = new int[(int)this.numValues];
                    if (object == null) {
                        int n10 = 0;
                        while ((long)n10 < this.numValues) {
                            ((int[])this._data)[n10] = n == 4 ? 0 : 0;
                            ++n10;
                        }
                    } else {
                        int n11 = 0;
                        while ((long)n11 < this.numValues) {
                            ((int[])this._data)[n11] = (Integer)object;
                            ++n11;
                        }
                    }
                    break;
                }
                this.dataSignature = "Ljava/lang/Integer;";
                if (object == null) {
                    if (n == 4) {
                        this._data = new Integer(0);
                        break;
                    }
                    this._data = new Integer(0);
                    break;
                }
                this._data = new Integer((Integer)object);
                break;
            }
            case 8: 
            case 14: 
            case 33: {
                if (this.numValues > 1L) {
                    this.dataSignature = "[J";
                    this._data = new long[(int)this.numValues];
                    if (object == null) {
                        int n12 = 0;
                        while ((long)n12 < this.numValues) {
                            ((long[])this._data)[n12] = n == 14 ? 0L : 0L;
                            ++n12;
                        }
                    } else {
                        int n13 = 0;
                        while ((long)n13 < this.numValues) {
                            ((long[])this._data)[n13] = (Long)object;
                            ++n13;
                        }
                    }
                    break;
                }
                this.dataSignature = "Ljava/lang/Long;";
                if (object == null) {
                    this._data = new Long(n == 14 ? 0L : 0L);
                    break;
                }
                this._data = new Long((Long)object);
                break;
            }
            case 21: 
            case 44: {
                if (this.numValues > 1L) {
                    this.dataSignature = "[F";
                    this._data = new float[(int)this.numValues];
                    if (object == null) {
                        int n14 = 0;
                        while ((long)n14 < this.numValues) {
                            ((float[])this._data)[n14] = n == 21 ? 0.0f : 0.0f;
                            ++n14;
                        }
                    } else {
                        int n15 = 0;
                        while ((long)n15 < this.numValues) {
                            ((float[])this._data)[n15] = ((Float)object).floatValue();
                            ++n15;
                        }
                    }
                    break;
                }
                this.dataSignature = "Ljava/lang/Float;";
                if (object == null) {
                    if (n == 21) {
                        this._data = new Float(0.0f);
                        break;
                    }
                    this._data = new Float(0.0f);
                    break;
                }
                this._data = new Float(((Float)object).floatValue());
                break;
            }
            case 22: 
            case 31: 
            case 45: {
                if (this.numValues > 1L) {
                    this.dataSignature = "[D";
                    this._data = new double[(int)this.numValues];
                    if (object == null) {
                        int n16 = 0;
                        while ((long)n16 < this.numValues) {
                            ((double[])this._data)[n16] = n == 22 ? 0.0 : (n == 45 ? 0.0 : 0.0);
                            ++n16;
                        }
                    } else {
                        int n17 = 0;
                        while ((long)n17 < this.numValues) {
                            ((double[])this._data)[n17] = (Double)object;
                            ++n17;
                        }
                    }
                    break;
                }
                this.dataSignature = "Ljava/lang/Double;";
                if (object == null) {
                    if (n == 22) {
                        this._data = new Double(0.0);
                        break;
                    }
                    if (n == 45) {
                        this._data = new Double(0.0);
                        break;
                    }
                    this._data = new Double(0.0);
                    break;
                }
                this._data = new Double((Double)object);
                break;
            }
            case 32: {
                this.dataSignature = "[D";
                this._data = new double[2 * (int)this.numValues];
                if (object == null) {
                    int n18 = 0;
                    while ((long)n18 < this.numValues) {
                        ((double[])this._data)[2 * n18] = 0.0;
                        ((double[])this._data)[2 * n18 + 1] = 0.0;
                        ++n18;
                    }
                } else {
                    int n19 = 0;
                    while ((long)n19 < this.numValues) {
                        ((double[])this._data)[2 * n19] = ((double[])object)[0];
                        ((double[])this._data)[2 * n19 + 1] = ((double[])object)[1];
                        ++n19;
                    }
                }
                break;
            }
        }
    }

    public void dumpData() {
        if (this.nDims <= 1 || this.numValues == 1L) {
            if (this.nDims == 0 || this.numValues == 1L) {
                if (this._myVar.getDataType() == 31L) {
                    Double d = (Double)this._dataArray;
                    System.out.println(Epoch.encode(d));
                } else if (this._myVar.getDataType() == 32L) {
                    double[] dArray = (double[])this._dataArray;
                    System.out.println(Epoch16.encode(dArray));
                } else if (this._myVar.getDataType() == 33L) {
                    Long l = (Long)this._dataArray;
                    System.out.println(CDFTT2000.toUTCstring((long)l));
                } else {
                    System.out.println(this._dataArray.toString());
                }
            } else {
                System.out.print("[");
                int n = (int)this._myVar.getDataType();
                switch (n) {
                    case 51: 
                    case 52: {
                        int n2 = 0;
                        while (n2 < this.dimSizes[this.nDims - 1]) {
                            if (n2 > 0) {
                                System.out.print(",");
                            }
                            System.out.print(((String[])this._dataArray)[n2]);
                            ++n2;
                        }
                        break;
                    }
                    case 1: 
                    case 41: {
                        int n3 = 0;
                        while (n3 < this.dimSizes[this.nDims - 1]) {
                            if (n3 > 0) {
                                System.out.print(",");
                            }
                            System.out.print(((byte[])this._dataArray)[n3]);
                            ++n3;
                        }
                        break;
                    }
                    case 2: {
                        int n4 = 0;
                        while (n4 < this.dimSizes[this.nDims - 1]) {
                            if (n4 > 0) {
                                System.out.print(",");
                            }
                            System.out.print(((short[])this._dataArray)[n4]);
                            ++n4;
                        }
                        break;
                    }
                    case 11: {
                        int n5 = 0;
                        while (n5 < this.dimSizes[this.nDims - 1]) {
                            if (n5 > 0) {
                                System.out.print(",");
                            }
                            if (((short[])this._dataArray)[n5] >= 0) {
                                System.out.print(((short[])this._dataArray)[n5]);
                            } else {
                                short s = (short)(((short[])this._dataArray)[n5] + 256);
                                System.out.print(s);
                            }
                            ++n5;
                        }
                        break;
                    }
                    case 4: {
                        int n6 = 0;
                        while (n6 < this.dimSizes[this.nDims - 1]) {
                            if (n6 > 0) {
                                System.out.print(",");
                            }
                            System.out.print(((int[])this._dataArray)[n6]);
                            ++n6;
                        }
                        break;
                    }
                    case 12: {
                        int n7 = 0;
                        while (n7 < this.dimSizes[this.nDims - 1]) {
                            if (n7 > 0) {
                                System.out.print(",");
                            }
                            if (((int[])this._dataArray)[n7] >= 0) {
                                System.out.print(((int[])this._dataArray)[n7]);
                            } else {
                                int n8 = ((int[])this._dataArray)[n7] + 65536;
                                System.out.print(n8);
                            }
                            ++n7;
                        }
                        break;
                    }
                    case 14: {
                        int n9 = 0;
                        while (n9 < this.dimSizes[this.nDims - 1]) {
                            if (n9 > 0) {
                                System.out.print(",");
                            }
                            if (((long[])this._dataArray)[n9] >= 0L) {
                                System.out.print(((long[])this._dataArray)[n9]);
                            } else {
                                long l = ((long[])this._dataArray)[n9] + 0x100000000L;
                                System.out.print(l);
                            }
                            ++n9;
                        }
                        break;
                    }
                    case 8: 
                    case 33: {
                        int n10 = 0;
                        while (n10 < this.dimSizes[this.nDims - 1]) {
                            if (n10 > 0) {
                                System.out.print(",");
                            }
                            if (n == 8) {
                                System.out.print(((long[])this._dataArray)[n10]);
                            } else {
                                System.out.print(CDFTT2000.toUTCstring(((long[])this._dataArray)[n10]));
                            }
                            ++n10;
                        }
                        break;
                    }
                    case 21: 
                    case 44: {
                        int n11 = 0;
                        while (n11 < this.dimSizes[this.nDims - 1]) {
                            if (n11 > 0) {
                                System.out.print(",");
                            }
                            System.out.print(((float[])this._dataArray)[n11]);
                            ++n11;
                        }
                        break;
                    }
                    case 22: 
                    case 45: {
                        int n12 = 0;
                        while (n12 < this.dimSizes[this.nDims - 1]) {
                            if (n12 > 0) {
                                System.out.print(",");
                            }
                            System.out.print(((double[])this._dataArray)[n12]);
                            ++n12;
                        }
                        break;
                    }
                    case 31: {
                        int n13 = 0;
                        while (n13 < this.dimSizes[this.nDims - 1]) {
                            if (n13 > 0) {
                                System.out.print(",");
                            }
                            System.out.print(Epoch.encode(((double[])this._dataArray)[n13]));
                            ++n13;
                        }
                        break;
                    }
                    case 32: {
                        double[] dArray = new double[2];
                        int n14 = 0;
                        while (n14 < this.dimSizes[this.nDims - 1]) {
                            if (n14 > 0) {
                                System.out.print(",");
                            }
                            dArray[0] = ((double[])this._dataArray)[2 * n14];
                            dArray[1] = ((double[])this._dataArray)[2 * n14 + 1];
                            System.out.print(Epoch16.encode(dArray));
                            ++n14;
                        }
                        break;
                    }
                }
                System.out.println("]");
            }
        } else {
            Object[] objectArray = null;
            Object[] objectArray2 = new Object[this.nDims - 1];
            int[] nArray = new int[this.nDims - 1];
            long[] lArray = new long[this.nDims - 1];
            objectArray2[0] = this._dataArray;
            nArray[0] = 0;
            lArray[0] = this.product(this.dimSizes, 0, this.nDims);
            int n = 1;
            while (n < this.nDims - 1) {
                objectArray2[n] = Array.get(objectArray2[n - 1], 0);
                lArray[n] = this.product(this.dimSizes, n, this.nDims);
                nArray[n] = 0;
                ++n;
            }
            n = 0;
            Object object = this._dataArray;
            while ((long)n < lArray[0]) {
                int n15;
                int n16;
                if (n != 0) {
                    n16 = 0;
                    while (n16 < this.nDims - 1) {
                        boolean bl;
                        boolean bl2 = false;
                        if ((long)n % lArray[n16] == 0L) {
                            bl2 = true;
                        }
                        if (bl = bl2) {
                            int n17 = n16;
                            nArray[n17] = nArray[n17] + 1;
                            objectArray2[n16] = object = Array.get(object, nArray[n16]);
                            n15 = n16 + 1;
                            while (n15 < this.nDims - 1) {
                                nArray[n15] = 0;
                                objectArray2[n15] = Array.get(objectArray2[n15 - 1], nArray[n15]);
                                ++n15;
                            }
                            break;
                        }
                        object = objectArray2[n16];
                        ++n16;
                    }
                }
                n16 = 0;
                while (n16 < this.dimSizes[this.nDims - 2]) {
                    System.out.print("[");
                    n15 = (int)this._myVar.getDataType();
                    switch (n15) {
                        case 51: 
                        case 52: {
                            objectArray = (String[])Array.get(objectArray2[this.nDims - 2], n16);
                            int n18 = 0;
                            while (n18 < this.dimSizes[this.nDims - 1]) {
                                if (n18 > 0) {
                                    System.out.print(",");
                                }
                                System.out.print(objectArray[n18]);
                                ++n18;
                            }
                            break;
                        }
                        case 1: 
                        case 41: {
                            objectArray = (byte[])Array.get(objectArray2[this.nDims - 2], n16);
                            int n19 = 0;
                            while (n19 < this.dimSizes[this.nDims - 1]) {
                                if (n19 > 0) {
                                    System.out.print(",");
                                }
                                System.out.print(((byte[])objectArray)[n19]);
                                ++n19;
                            }
                            break;
                        }
                        case 2: {
                            objectArray = (short[])Array.get(objectArray2[this.nDims - 2], n16);
                            int n20 = 0;
                            while (n20 < this.dimSizes[this.nDims - 1]) {
                                if (n20 > 0) {
                                    System.out.print(",");
                                }
                                System.out.print(((short[])objectArray)[n20]);
                                ++n20;
                            }
                            break;
                        }
                        case 11: {
                            objectArray = (short[])Array.get(objectArray2[this.nDims - 2], n16);
                            int n21 = 0;
                            while (n21 < this.dimSizes[this.nDims - 1]) {
                                if (n21 > 0) {
                                    System.out.print(",");
                                }
                                if (((short[])objectArray)[n21] >= 0) {
                                    System.out.print(((short[])objectArray)[n21]);
                                } else {
                                    short s = (short)(((short[])objectArray)[n21] + 256);
                                    System.out.print(s);
                                }
                                ++n21;
                            }
                            break;
                        }
                        case 4: {
                            objectArray = (int[])Array.get(objectArray2[this.nDims - 2], n16);
                            int n22 = 0;
                            while (n22 < this.dimSizes[this.nDims - 1]) {
                                if (n22 > 0) {
                                    System.out.print(",");
                                }
                                System.out.print(((int[])objectArray)[n22]);
                                ++n22;
                            }
                            break;
                        }
                        case 12: {
                            objectArray = (int[])Array.get(objectArray2[this.nDims - 2], n16);
                            int n23 = 0;
                            while (n23 < this.dimSizes[this.nDims - 1]) {
                                if (n23 > 0) {
                                    System.out.print(",");
                                }
                                if (((int[])objectArray)[n23] >= 0) {
                                    System.out.print(((int[])objectArray)[n23]);
                                } else {
                                    int n24 = ((int[])objectArray)[n23] + 65536;
                                    System.out.print(n24);
                                }
                                ++n23;
                            }
                            break;
                        }
                        case 14: {
                            objectArray = (long[])Array.get(objectArray2[this.nDims - 2], n16);
                            int n25 = 0;
                            while (n25 < this.dimSizes[this.nDims - 1]) {
                                if (n25 > 0) {
                                    System.out.print(",");
                                }
                                if (((long[])objectArray)[n25] >= 0L) {
                                    System.out.print(((long[])objectArray)[n25]);
                                } else {
                                    long l = ((long[])objectArray)[n25] + 0x100000000L;
                                    System.out.print(l);
                                }
                                ++n25;
                            }
                            break;
                        }
                        case 8: 
                        case 33: {
                            objectArray = (long[])Array.get(objectArray2[this.nDims - 2], n16);
                            int n26 = 0;
                            while (n26 < this.dimSizes[this.nDims - 1]) {
                                if (n26 > 0) {
                                    System.out.print(",");
                                }
                                if (n15 == 8) {
                                    System.out.print(((long[])objectArray)[n26]);
                                } else {
                                    System.out.print(CDFTT2000.toUTCstring(((long[])objectArray)[n26]));
                                }
                                ++n26;
                            }
                            break;
                        }
                        case 21: 
                        case 44: {
                            objectArray = (float[])Array.get(objectArray2[this.nDims - 2], n16);
                            int n27 = 0;
                            while (n27 < this.dimSizes[this.nDims - 1]) {
                                if (n27 > 0) {
                                    System.out.print(",");
                                }
                                System.out.print(((float[])objectArray)[n27]);
                                ++n27;
                            }
                            break;
                        }
                        case 22: 
                        case 45: {
                            objectArray = (double[])Array.get(objectArray2[this.nDims - 2], n16);
                            int n28 = 0;
                            while (n28 < this.dimSizes[this.nDims - 1]) {
                                if (n28 > 0) {
                                    System.out.print(",");
                                }
                                System.out.print(((double[])objectArray)[n28]);
                                ++n28;
                            }
                            break;
                        }
                        case 31: {
                            objectArray = (double[])Array.get(objectArray2[this.nDims - 2], n16);
                            int n29 = 0;
                            while (n29 < this.dimSizes[this.nDims - 1]) {
                                if (n29 > 0) {
                                    System.out.print(",");
                                }
                                System.out.print(Epoch.encode(((double[])objectArray)[n29]));
                                ++n29;
                            }
                            break;
                        }
                        case 32: {
                            double[] dArray = new double[2];
                            objectArray = (double[])Array.get(objectArray2[this.nDims - 2], n16);
                            int n30 = 0;
                            while (n30 < this.dimSizes[this.nDims - 1]) {
                                if (n30 > 0) {
                                    System.out.print(",");
                                }
                                dArray[0] = ((double[])objectArray)[2 * n30];
                                dArray[1] = ((double[])objectArray)[2 * n30 + 1];
                                System.out.print(Epoch16.encode(dArray));
                                ++n30;
                            }
                            break;
                        }
                    }
                    System.out.println("]");
                    n += this.dimSizes[this.nDims - 1];
                    ++n16;
                }
            }
        }
    }

    public void dump() {
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        System.err.println("Data dump for " + this._myVar + ": ");
        stringBuffer.append(CDFUtils.getStringDataType(this._myVar.getDataType()));
        stringBuffer.append("/");
        stringBuffer.append(this._myVar.getNumElements());
        int n = 12 - stringBuffer.length();
        int n2 = 0;
        while (n2 < n) {
            stringBuffer.append(" ");
            ++n2;
        }
        stringBuffer2.append(stringBuffer.toString());
        stringBuffer.setLength(0);
        stringBuffer2.append(String.valueOf(this.nDims));
        stringBuffer2.append(":[");
        n2 = 0;
        while (n2 < this.nDims) {
            if (n2 > 0) {
                stringBuffer2.append(",");
            }
            stringBuffer2.append(String.valueOf(this.dimSizes[n2]));
            ++n2;
        }
        stringBuffer2.append("]\t");
        stringBuffer2.append(String.valueOf(this.recStart));
        stringBuffer2.append("/");
        stringBuffer2.append(String.valueOf(this.recCount));
        stringBuffer2.append("/");
        stringBuffer2.append(String.valueOf(this.recInterval));
        stringBuffer2.append("/[");
        n2 = 0;
        while (n2 < this.dimIndices.length) {
            if (n2 > 0) {
                stringBuffer2.append(",");
            }
            stringBuffer2.append(String.valueOf(this.dimIndices[n2]));
            ++n2;
        }
        stringBuffer2.append("]/[");
        n2 = 0;
        while (n2 < this.dimCounts.length) {
            if (n2 > 0) {
                stringBuffer2.append(",");
            }
            stringBuffer2.append(String.valueOf(this.dimCounts[n2]));
            ++n2;
        }
        stringBuffer2.append("]/[");
        n2 = 0;
        while (n2 < this.dimIntervals.length) {
            if (n2 > 0) {
                stringBuffer2.append(",");
            }
            stringBuffer2.append(String.valueOf(this.dimIntervals[n2]));
            ++n2;
        }
        stringBuffer2.append("]/");
        stringBuffer2.append(this._dataArray.getClass().getName());
        System.err.println(stringBuffer2.toString());
        this.dumpData();
    }

    public String getName() {
        return "Data";
    }

    public void rename(String string) throws CDFException {
    }

    public void delete() throws CDFException {
    }

    private final /* synthetic */ void this() {
        this.nDims = 0;
    }

    private CDFData(Variable variable) {
        this.this();
        this._dataArray = null;
        this._data = null;
        this._myVar = variable;
        this.id = this._myVar.getID();
        this.cdfID = this._myVar.getMyCDF().getID();
        this.dataType = this._myVar.getDataType();
        this.numElements = this._myVar.getNumElements();
        this.numDims = this._myVar.getNumDims();
        this.varDimSizes = this._myVar.getDimSizes();
    }
}

