/*
 * Decompiled with CFR 0.152.
 */
package dods.servlet;

import dods.dap.Attribute;
import dods.dap.AttributeTable;
import dods.dap.BaseType;
import dods.dap.BaseTypePrimitiveVector;
import dods.dap.DAS;
import dods.dap.DArray;
import dods.dap.DConstructor;
import dods.dap.DODSException;
import dods.dap.DString;
import dods.dap.DVector;
import dods.dap.PrimitiveVector;
import dods.dap.Server.ServerDDS;
import dods.dap.parser.ParseException;
import dods.servlet.GuardedDataset;
import dods.servlet.ReqState;
import dods.util.dasTools;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.Enumeration;

public class dodsINFO {
    private static final boolean _Debug = true;
    private String infoDir = null;

    public void sendINFO(PrintStream pw, GuardedDataset gds, ReqState rs) throws DODSException, ParseException {
        System.out.println("dods.servlet.dodsINFO.sendINFO() reached.");
        String responseDoc = null;
        ServerDDS myDDS = null;
        DAS myDAS = null;
        myDDS = gds.getDDS();
        myDAS = gds.getDAS();
        this.infoDir = rs.getInitParameter("INFOcache");
        if (this.infoDir == null) {
            this.infoDir = rs.getINFOCache();
        }
        if ((responseDoc = this.loadOverrideDoc(this.infoDir, rs.getDataSet())) != null) {
            System.out.println("override document: " + responseDoc);
            pw.print(responseDoc);
        } else {
            String user_html = this.get_user_supplied_docs(rs.getServerName(), rs.getDataSet());
            String global_attrs = this.buildGlobalAttributes(myDAS, myDDS);
            String variable_sum = this.buildVariableSummaries(myDAS, myDDS);
            pw.println("<html><head><title>Dataset Information</title>");
            pw.println("<style type=\"text/css\">");
            pw.println("<!-- ul {list-style-type: none;} -->");
            pw.println("</style>");
            pw.println("</head>");
            pw.println("<body>");
            if (global_attrs.length() > 0) {
                pw.println(global_attrs);
                pw.println("<hr>");
            }
            pw.println(variable_sum);
            pw.println("<hr>");
            pw.println(user_html);
            pw.println("</body></html>");
            pw.flush();
        }
    }

    public String loadOverrideDoc(String infoDir, String dataSet) throws DODSException {
        String userDoc = "";
        String overrideFile = dataSet + ".ovr";
        try {
            File fin = new File(infoDir + overrideFile);
            BufferedReader svIn = new BufferedReader(new InputStreamReader(new FileInputStream(fin)));
            boolean done = false;
            while (!done) {
                String line = svIn.readLine();
                if (line == null) {
                    done = true;
                    continue;
                }
                userDoc = userDoc + line + "\n";
            }
            svIn.close();
        }
        catch (FileNotFoundException fnfe) {
            userDoc = userDoc + "<h2>No Could Not Open Override Document.</h2><hr>";
            return null;
        }
        catch (IOException ioe) {
            throw new DODSException(0, ioe.getMessage());
        }
        return userDoc;
    }

    private String get_user_supplied_docs(String serverName, String dataSet) throws DODSException {
        String userDoc = "";
        try {
            File fin = new File(this.infoDir + dataSet + ".html");
            BufferedReader svIn = new BufferedReader(new InputStreamReader(new FileInputStream(fin)));
            boolean done = false;
            while (!done) {
                String line = svIn.readLine();
                if (line == null) {
                    done = true;
                    continue;
                }
                userDoc = userDoc + line + "\n";
            }
            svIn.close();
        }
        catch (FileNotFoundException fnfe) {
            userDoc = userDoc + "<h2>No Dataset Specific Information Available.</h2><hr>";
        }
        catch (IOException ioe) {
            throw new DODSException(0, ioe.getMessage());
        }
        userDoc = userDoc + "<hr>\n";
        try {
            String serverFile = this.infoDir + serverName + ".html";
            System.out.println("Server Info File: " + serverFile);
            File fin = new File(serverFile);
            BufferedReader svIn = new BufferedReader(new InputStreamReader(new FileInputStream(fin)));
            boolean done = false;
            while (!done) {
                String line = svIn.readLine();
                if (line == null) {
                    done = true;
                    continue;
                }
                userDoc = userDoc + line + "\n";
            }
            svIn.close();
        }
        catch (FileNotFoundException fnfe) {
            userDoc = userDoc + "<h2>No Server Specific Information Available.</h2><hr>";
        }
        catch (IOException ioe) {
            throw new DODSException(0, ioe.getMessage());
        }
        return userDoc;
    }

    private String buildGlobalAttributes(DAS das, ServerDDS dds) {
        boolean found = false;
        String ga = "<h3>Dataset Information</h3>\n<table>\n";
        Enumeration edas = das.getNames();
        while (edas.hasMoreElements()) {
            AttributeTable attr;
            String name = (String)edas.nextElement();
            if (dasTools.nameInKillFile(name) || !dasTools.nameIsGlobal(name) && dasTools.nameInDDS(name, dds) || (attr = das.getAttributeTable(name)) == null) continue;
            Enumeration e = attr.getNames();
            while (e.hasMoreElements()) {
                String aName = (String)e.nextElement();
                Attribute a = attr.getAttribute(aName);
                found = true;
                ga = ga + "\n<tr><td align=right valign=top><b>";
                ga = ga + aName + "</b>:</td>\n";
                ga = ga + "<td align=left>";
                Enumeration es = a.getValues();
                while (es.hasMoreElements()) {
                    String val = (String)es.nextElement();
                    ga = ga + val + "<br>";
                }
                ga = ga + "</td></tr>\n";
            }
        }
        ga = ga + "</table>\n<p>\n";
        if (!found) {
            ga = "";
        }
        return ga;
    }

    private String buildVariableSummaries(DAS das, ServerDDS dds) {
        String vs = "<h3>Variables in this Dataset</h3>\n<table>\n";
        Enumeration e = dds.getVariables();
        while (e.hasMoreElements()) {
            BaseType bt = (BaseType)e.nextElement();
            vs = vs + "<tr>";
            vs = vs + this.summarizeVariable(bt, das);
            vs = vs + "</tr>";
        }
        vs = vs + "</table>\n<p>\n";
        return vs;
    }

    private String summarizeAttributes(AttributeTable attr, String vOut) {
        if (attr != null) {
            Enumeration e = attr.getNames();
            while (e.hasMoreElements()) {
                String name = (String)e.nextElement();
                Attribute a = attr.getAttribute(name);
                if (a.isContainer()) {
                    vOut = vOut + "<li> <b> " + name + ": </b> </li>\n";
                    vOut = vOut + "<ul>\n";
                    vOut = vOut + this.summarizeAttributes(a.getContainer(), "");
                    vOut = vOut + "</ul>\n";
                    continue;
                }
                vOut = vOut + "<li> <b> " + name + ": </b> ";
                Enumeration es = a.getValues();
                while (es.hasMoreElements()) {
                    String val = (String)es.nextElement();
                    vOut = vOut + val;
                    if (!es.hasMoreElements()) continue;
                    vOut = vOut + ", ";
                }
                vOut = vOut + " </li>\n";
            }
        }
        return vOut;
    }

    private String summarizeVariable(BaseType bt, DAS das) {
        String vOut = "<td align=right valign=top><b>" + bt.getName();
        vOut = vOut + "</b>:</td>\n";
        vOut = vOut + "<td align=left valign=top>" + dasTools.fancyTypeName(bt);
        AttributeTable attr = das.getAttributeTable(bt.getName());
        String s = "";
        vOut = vOut + "\n<ul>\n";
        vOut = vOut + this.summarizeAttributes(attr, s);
        vOut = vOut + "\n</ul>\n";
        if (bt instanceof DConstructor) {
            vOut = vOut + "<table>\n";
            DConstructor dc = (DConstructor)bt;
            Enumeration e = dc.getVariables();
            while (e.hasMoreElements()) {
                BaseType bt2 = (BaseType)e.nextElement();
                vOut = vOut + "<tr>\n";
                vOut = vOut + this.summarizeVariable(bt2, das);
                vOut = vOut + "</tr>\n";
            }
            vOut = vOut + "</table>\n";
        } else if (bt instanceof DVector) {
            BaseType bt2;
            DVector da = (DVector)bt;
            PrimitiveVector pv = da.getPrimitiveVector();
            if (pv instanceof BaseTypePrimitiveVector && !((bt2 = pv.getTemplate()) instanceof DArray) && !(bt2 instanceof DString)) {
                vOut = vOut + "<table>\n";
                vOut = vOut + "<tr>\n";
                vOut = vOut + this.summarizeVariable(bt2, das);
                vOut = vOut + "</tr>\n";
                vOut = vOut + "</table>\n";
            }
        } else {
            vOut = vOut + "</td>\n";
        }
        return vOut;
    }
}

