/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.extractor;

import java.io.IOException;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.poi.POIOLE2TextExtractor;
import org.apache.poi.hpsf.DocumentSummaryInformation;
import org.apache.poi.hpsf.SummaryInformation;
import org.apache.poi.hssf.eventusermodel.FormatTrackingHSSFListener;
import org.apache.poi.hssf.eventusermodel.HSSFEventFactory;
import org.apache.poi.hssf.eventusermodel.HSSFListener;
import org.apache.poi.hssf.eventusermodel.HSSFRequest;
import org.apache.poi.hssf.model.FormulaParser;
import org.apache.poi.hssf.record.BOFRecord;
import org.apache.poi.hssf.record.BoundSheetRecord;
import org.apache.poi.hssf.record.CellValueRecordInterface;
import org.apache.poi.hssf.record.FormulaRecord;
import org.apache.poi.hssf.record.LabelRecord;
import org.apache.poi.hssf.record.LabelSSTRecord;
import org.apache.poi.hssf.record.NoteRecord;
import org.apache.poi.hssf.record.NumberRecord;
import org.apache.poi.hssf.record.Record;
import org.apache.poi.hssf.record.SSTRecord;
import org.apache.poi.hssf.record.StringRecord;
import org.apache.poi.hssf.usermodel.HSSFDateUtil;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;

public class EventBasedExcelExtractor
extends POIOLE2TextExtractor {
    private POIFSFileSystem fs;
    private boolean includeSheetNames = true;
    private boolean formulasNotResults = false;

    public EventBasedExcelExtractor(POIFSFileSystem fs) throws IOException {
        super(null);
        this.fs = fs;
    }

    public DocumentSummaryInformation getDocSummaryInformation() {
        throw new IllegalStateException("Metadata extraction not supported in streaming mode, please use ExcelExtractor");
    }

    public SummaryInformation getSummaryInformation() {
        throw new IllegalStateException("Metadata extraction not supported in streaming mode, please use ExcelExtractor");
    }

    public void setIncludeSheetNames(boolean includeSheetNames) {
        this.includeSheetNames = includeSheetNames;
    }

    public void setFormulasNotResults(boolean formulasNotResults) {
        this.formulasNotResults = formulasNotResults;
    }

    public String getText() {
        String text = null;
        try {
            TextListener tl = this.triggerExtraction();
            text = tl.text.toString();
            if (!text.endsWith("\n")) {
                text = text + "\n";
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return text;
    }

    private TextListener triggerExtraction() throws IOException {
        TextListener tl = new TextListener();
        FormatTrackingHSSFListener ft = new FormatTrackingHSSFListener(tl);
        tl.ft = ft;
        HSSFEventFactory factory = new HSSFEventFactory();
        HSSFRequest request = new HSSFRequest();
        request.addListenerForAllRecords(ft);
        factory.processWorkbookEvents(request, this.fs);
        return tl;
    }

    private class TextListener
    implements HSSFListener {
        private FormatTrackingHSSFListener ft;
        private SSTRecord sstRecord;
        private List sheetNames = new ArrayList();
        private StringBuffer text = new StringBuffer();
        private int sheetNum = -1;
        private int rowNum;
        private boolean outputNextStringValue = false;
        private int nextRow = -1;

        private TextListener() {
        }

        public void processRecord(Record record) {
            String thisText = null;
            int thisRow = -1;
            switch (record.getSid()) {
                case 133: {
                    BoundSheetRecord sr = (BoundSheetRecord)record;
                    this.sheetNames.add(sr.getSheetname());
                    break;
                }
                case 2057: {
                    BOFRecord bof = (BOFRecord)record;
                    if (bof.getType() != 16) break;
                    ++this.sheetNum;
                    this.rowNum = -1;
                    if (!EventBasedExcelExtractor.this.includeSheetNames) break;
                    if (this.text.length() > 0) {
                        this.text.append("\n");
                    }
                    this.text.append(this.sheetNames.get(this.sheetNum));
                    break;
                }
                case 252: {
                    this.sstRecord = (SSTRecord)record;
                    break;
                }
                case 6: {
                    FormulaRecord frec = (FormulaRecord)record;
                    thisRow = frec.getRow();
                    if (EventBasedExcelExtractor.this.formulasNotResults) {
                        thisText = FormulaParser.toFormulaString(null, frec.getParsedExpression());
                        break;
                    }
                    if (Double.isNaN(frec.getValue())) {
                        this.outputNextStringValue = true;
                        this.nextRow = frec.getRow();
                        break;
                    }
                    thisText = this.formatNumberDateCell(frec, frec.getValue());
                    break;
                }
                case 519: {
                    if (!this.outputNextStringValue) break;
                    StringRecord srec = (StringRecord)record;
                    thisText = srec.getString();
                    thisRow = this.nextRow;
                    this.outputNextStringValue = false;
                    break;
                }
                case 516: {
                    LabelRecord lrec = (LabelRecord)record;
                    thisRow = lrec.getRow();
                    thisText = lrec.getValue();
                    break;
                }
                case 253: {
                    LabelSSTRecord lsrec = (LabelSSTRecord)record;
                    thisRow = lsrec.getRow();
                    if (this.sstRecord == null) {
                        throw new IllegalStateException("No SST record found");
                    }
                    thisText = this.sstRecord.getString(lsrec.getSSTIndex()).toString();
                    break;
                }
                case 28: {
                    NoteRecord nrec = (NoteRecord)record;
                    thisRow = nrec.getRow();
                    break;
                }
                case 515: {
                    NumberRecord numrec = (NumberRecord)record;
                    thisRow = numrec.getRow();
                    thisText = this.formatNumberDateCell(numrec, numrec.getValue());
                    break;
                }
            }
            if (thisText != null) {
                if (thisRow != this.rowNum) {
                    this.rowNum = thisRow;
                    if (this.text.length() > 0) {
                        this.text.append("\n");
                    }
                } else {
                    this.text.append("\t");
                }
                this.text.append(thisText);
            }
        }

        private String formatNumberDateCell(CellValueRecordInterface cell, double value) {
            int formatIndex = this.ft.getFormatIndex(cell);
            String formatString = this.ft.getFormatString(cell);
            if (formatString == null) {
                return Double.toString(value);
            }
            if (HSSFDateUtil.isADateFormat(formatIndex, formatString) && HSSFDateUtil.isValidExcelDate(value)) {
                formatString = formatString.replace('m', 'M');
                formatString = formatString.replaceAll("\\\\-", "-");
                Date d = HSSFDateUtil.getJavaDate(value, false);
                SimpleDateFormat df = new SimpleDateFormat(formatString);
                return df.format(d);
            }
            if (formatString == "General") {
                return Double.toString(value);
            }
            DecimalFormat df = new DecimalFormat(formatString);
            return df.format(value);
        }
    }
}

