/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record.formula.functions;

import org.apache.poi.hssf.record.formula.eval.ErrorEval;
import org.apache.poi.hssf.record.formula.eval.Eval;
import org.apache.poi.hssf.record.formula.eval.EvaluationException;
import org.apache.poi.hssf.record.formula.eval.OperandResolver;
import org.apache.poi.hssf.record.formula.eval.StringEval;
import org.apache.poi.hssf.record.formula.eval.ValueEval;
import org.apache.poi.hssf.record.formula.functions.TextFunction;

public final class Trim
extends TextFunction {
    public Eval evaluate(Eval[] args, int srcCellRow, short srcCellCol) {
        if (args.length != 1) {
            return ErrorEval.VALUE_INVALID;
        }
        try {
            ValueEval veval = OperandResolver.getSingleValue(args[0], srcCellRow, srcCellCol);
            String str = OperandResolver.coerceValueToString(veval);
            str = str.trim();
            if (str.length() < 1) {
                return StringEval.EMPTY_INSTANCE;
            }
            return new StringEval(str);
        }
        catch (EvaluationException e) {
            return e.getErrorEval();
        }
    }
}

