/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.jemmy;

import java.awt.Component;
import java.awt.Frame;
import java.awt.Window;
import org.netbeans.jemmy.ComponentChooser;
import org.netbeans.jemmy.JemmyProperties;
import org.netbeans.jemmy.QueueTool;
import org.netbeans.jemmy.Timeoutable;
import org.netbeans.jemmy.Timeouts;
import org.netbeans.jemmy.Waiter;

public class WindowWaiter
extends Waiter
implements Timeoutable {
    private static final long WAIT_TIME = 60000L;
    private static final long AFTER_WAIT_TIME = 0L;
    private ComponentChooser chooser;
    private Window owner = null;
    private int index = 0;
    private Timeouts timeouts;

    public WindowWaiter() {
        this.setTimeouts(JemmyProperties.getProperties().getTimeouts());
    }

    public static Window getWindow(Window owner, ComponentChooser cc, int index) {
        return WindowWaiter.getAWindow(owner, new IndexChooser(cc, index));
    }

    public static Window getWindow(Window owner, ComponentChooser cc) {
        return WindowWaiter.getWindow(owner, cc, 0);
    }

    public static Window getWindow(ComponentChooser cc, int index) {
        return WindowWaiter.getAWindow(new IndexChooser(cc, index));
    }

    public static Window getWindow(ComponentChooser cc) {
        return WindowWaiter.getWindow(cc, 0);
    }

    public void setTimeouts(Timeouts timeouts) {
        this.timeouts = timeouts;
        Timeouts times = timeouts.cloneThis();
        times.setTimeout("Waiter.WaitingTime", timeouts.getTimeout("WindowWaiter.WaitWindowTimeout"));
        times.setTimeout("Waiter.AfterWaitingTime", timeouts.getTimeout("WindowWaiter.AfterWindowTimeout"));
        super.setTimeouts(times);
    }

    public Timeouts getTimeouts() {
        return this.timeouts;
    }

    public Object actionProduced(Object obj) {
        return WindowWaiter.getWindow(this.owner, this.chooser, this.index);
    }

    public Window waitWindow(ComponentChooser ch, int index) throws InterruptedException {
        this.chooser = ch;
        this.owner = null;
        this.index = index;
        return this.waitWindow();
    }

    public Window waitWindow(ComponentChooser ch) throws InterruptedException {
        return this.waitWindow(ch, 0);
    }

    public Window waitWindow(Window o, ComponentChooser ch, int index) throws InterruptedException {
        this.owner = o;
        this.chooser = ch;
        this.index = index;
        return (Window)this.waitAction(null);
    }

    public Window waitWindow(Window o, ComponentChooser ch) throws InterruptedException {
        return this.waitWindow(o, ch, 0);
    }

    public String getDescription() {
        return this.chooser.getDescription();
    }

    protected void setComponentChooser(ComponentChooser ch) {
        this.chooser = ch;
    }

    protected ComponentChooser getComponentChooser() {
        return this.chooser;
    }

    protected void setOwner(Window owner) {
        this.owner = owner;
    }

    protected Window getOwner() {
        return this.owner;
    }

    protected String getWaitingStartedMessage() {
        return "Start to wait window \"" + this.chooser.getDescription() + "\" opened";
    }

    protected String getTimeoutExpiredMessage(long timeSpent) {
        return "Window \"" + this.chooser.getDescription() + "\" has not been opened in " + new Long(timeSpent).toString() + " milliseconds";
    }

    protected String getActionProducedMessage(long timeSpent, final Object result) {
        String resultToString = result instanceof Component ? (String)new QueueTool().invokeSmoothly(new QueueTool.QueueAction("result.toString()"){

            public Object launch() {
                return result.toString();
            }
        }) : result.toString();
        return "Window \"" + this.chooser.getDescription() + "\" has been opened in " + new Long(timeSpent).toString() + " milliseconds" + "\n    " + resultToString;
    }

    protected String getGoldenWaitingStartedMessage() {
        return "Start to wait window \"" + this.chooser.getDescription() + "\" opened";
    }

    protected String getGoldenTimeoutExpiredMessage() {
        return "Window \"" + this.chooser.getDescription() + "\" has not been opened";
    }

    protected String getGoldenActionProducedMessage() {
        return "Window \"" + this.chooser.getDescription() + "\" has been opened";
    }

    private static Window getAWindow(Window owner, ComponentChooser cc) {
        if (owner == null) {
            return WindowWaiter.getAWindow(cc);
        }
        Window result = null;
        Window[] windows = owner.getOwnedWindows();
        for (int i = 0; i < windows.length; ++i) {
            if (cc.checkComponent(windows[i])) {
                return windows[i];
            }
            result = WindowWaiter.getWindow(windows[i], cc);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    private static Window getAWindow(ComponentChooser cc) {
        Window result = null;
        Frame[] frames = Frame.getFrames();
        for (int i = 0; i < frames.length; ++i) {
            if (cc.checkComponent(frames[i])) {
                return frames[i];
            }
            result = WindowWaiter.getWindow(frames[i], cc);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    private Window waitWindow() throws InterruptedException {
        return (Window)this.waitAction(null);
    }

    private Window waitWindow(Window o) throws InterruptedException {
        this.owner = o;
        return (Window)this.waitAction(null);
    }

    static {
        Timeouts.initDefault("WindowWaiter.WaitWindowTimeout", 60000L);
        Timeouts.initDefault("WindowWaiter.AfterWindowTimeout", 0L);
    }

    private static class IndexChooser
    implements ComponentChooser {
        private int curIndex = 0;
        private int index;
        private ComponentChooser chooser;

        public IndexChooser(ComponentChooser ch, int i) {
            this.index = i;
            this.chooser = ch;
            this.curIndex = 0;
        }

        public boolean checkComponent(Component comp) {
            if (comp.isShowing() && comp.isVisible() && this.chooser.checkComponent(comp)) {
                if (this.curIndex == this.index) {
                    return true;
                }
                ++this.curIndex;
            }
            return false;
        }

        public String getDescription() {
            return this.chooser.getDescription();
        }
    }
}

