/*
 * Decompiled with CFR 0.152.
 */
package jsyntaxpane.actions;

import java.awt.event.ActionEvent;
import java.util.Map;
import java.util.regex.Pattern;
import javax.swing.JEditorPane;
import javax.swing.text.EditorKit;
import javax.swing.text.JTextComponent;
import jsyntaxpane.DefaultSyntaxKit;
import jsyntaxpane.SyntaxDocument;
import jsyntaxpane.Token;
import jsyntaxpane.actions.ActionUtils;
import jsyntaxpane.actions.DefaultSyntaxAction;

public class IndentAction
extends DefaultSyntaxAction {
    private Pattern wordsPattern = Pattern.compile("\\w+");
    private boolean insertTab = true;

    public IndentAction() {
        super("insert-tab");
    }

    @Override
    public void actionPerformed(JTextComponent target, SyntaxDocument sDoc, int dot, ActionEvent e) {
        String selected = target.getSelectedText();
        EditorKit kit = ((JEditorPane)target).getEditorKit();
        Map<String, String> abbrvs = ((DefaultSyntaxKit)kit).getAbbreviations();
        if (selected == null) {
            Token abbrToken = sDoc.getWordAt(dot, this.wordsPattern);
            Integer tabStop = ActionUtils.getTabSize(target);
            int lineStart = sDoc.getParagraphElement(dot).getStartOffset();
            int column = dot - lineStart;
            int needed = tabStop - column % tabStop;
            if (abbrvs == null || abbrToken == null) {
                if (this.insertTab) {
                    target.replaceSelection("\t");
                } else {
                    target.replaceSelection("                ".substring(0, needed));
                }
            } else {
                String abbr = abbrToken.getString(sDoc);
                if (abbrvs.containsKey(abbr)) {
                    target.select(abbrToken.start, abbrToken.end());
                    abbr = abbrvs.get(abbr);
                    String[] abbrLines = abbr.split("\n");
                    if (abbrLines.length > 1) {
                        ActionUtils.insertLinesTemplate(target, abbrLines);
                    } else {
                        ActionUtils.insertSimpleTemplate(target, abbr);
                    }
                } else if (this.insertTab) {
                    target.replaceSelection("\t");
                } else {
                    target.replaceSelection("                ".substring(0, needed));
                }
            }
        } else {
            String[] lines = ActionUtils.getSelectedLines(target);
            int start = target.getSelectionStart();
            StringBuilder sb = new StringBuilder();
            for (String line : lines) {
                sb.append(ActionUtils.getTab(target));
                sb.append(line);
                sb.append('\n');
            }
            target.replaceSelection(sb.toString());
            target.select(start, start + sb.length());
        }
    }

    public void setWordRegex(String regex) {
        this.wordsPattern = Pattern.compile(regex);
    }

    public Pattern getWordRegex() {
        return this.wordsPattern;
    }

    public boolean getInsertTab() {
        return this.insertTab;
    }

    public void setInsertTab(boolean insertTab) {
        this.insertTab = insertTab;
    }
}

