/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans.formcomponents;

import com.install4j.api.context.UserCanceledException;
import com.install4j.api.screens.Console;
import com.install4j.runtime.beans.formcomponents.SpinnerComponent;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.JSpinner;
import javax.swing.SpinnerDateModel;
import javax.swing.SpinnerModel;

public class DateSpinnerComponent
extends SpinnerComponent {
    private String dateFormatPattern = "";
    private Date initialValue;

    public String getDateFormatPattern() {
        return this.dateFormatPattern;
    }

    public void setDateFormatPattern(String dateFormatPattern) {
        this.dateFormatPattern = dateFormatPattern;
    }

    public Date getInitialValue() {
        return this.initialValue;
    }

    public void setInitialValue(Date initialValue) {
        this.initialValue = initialValue;
    }

    @Override
    protected SpinnerModel createSpinnerModel() {
        SpinnerDateModel model = new SpinnerDateModel();
        this.initValue(model);
        return model;
    }

    @Override
    protected void adjustEditor(JSpinner spinner) {
        if (this.dateFormatPattern.trim().length() > 0) {
            spinner.setEditor(new JSpinner.DateEditor(spinner, this.dateFormatPattern));
        }
    }

    @Override
    protected void initValue(SpinnerModel model) {
        Date initValue = (Date)this.getInitValue(this.getInitialValue(), this.getVariableName(), Date.class);
        if (initValue != null) {
            model.setValue(initValue);
        }
    }

    @Override
    public boolean handleConsole(Console console) throws UserCanceledException {
        JSpinner spinner = this.getSpinner();
        SpinnerDateModel model = (SpinnerDateModel)spinner.getModel();
        JSpinner.DateEditor editor = (JSpinner.DateEditor)spinner.getEditor();
        SimpleDateFormat format = editor.getFormat();
        boolean oldLenient = format.isLenient();
        format.setLenient(false);
        Object oldValue = model.getValue();
        while (true) {
            model.setValue(oldValue);
            String res = console.askString(this.getConsoleLabelText(true) + " [" + format.toLocalizedPattern() + "]", editor.getTextField().getText());
            try {
                Date date = format.parse(res);
                model.setValue(date);
                format.setLenient(oldLenient);
                return true;
            }
            catch (ParseException parseException) {
                continue;
            }
            break;
        }
    }
}

