/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.helper.fileinst;

import com.install4j.api.context.UninstallMode;
import com.install4j.runtime.installer.ContextImpl;
import com.install4j.runtime.installer.helper.XmlHelper;
import com.install4j.runtime.installer.helper.fileinst.BackupPair;
import com.install4j.runtime.installer.helper.fileinst.FileInstallerState;
import com.install4j.runtime.installer.helper.fileinst.InstallFile;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.w3c.dom.Element;

class FileLogger
implements Serializable {
    public static final int ALL = -1;
    private SortedSet<InstallFile> createdDirs = new TreeSet<InstallFile>(new ReverseComparator());
    private Set<InstallFile> createdFiles = new HashSet<InstallFile>();
    private List<BackupPair> replacedFiles = new ArrayList<BackupPair>();
    private static final String ELEMENT_FILELOG = "fileLog";
    private static final String ELEMENT_CREATED_FILES = "createdFiles";
    private static final String ELEMENT_CREATED_DIRS = "createdDirs";
    private static final String ELEMENT_ENTRY = "entry";
    private static final String ATTRIBUTE_NAME = "name";
    private static final String ATTRIBUTE_SHARED = "shared";
    private static final String ATTRIBUTE_DONT_UNINSTALL = "dontUninstall";
    private static final String ATTRIBUTE_UNINSTALL_MODE = "uninstallMode";

    FileLogger() {
    }

    public void write(File logFile, FileLogger oldFileLogger) throws IOException {
        if (oldFileLogger != null) {
            for (InstallFile shareableFile : oldFileLogger.getCreatedFiles(-1)) {
                this.addCreatedFile(shareableFile, -1);
            }
            for (InstallFile installFile : oldFileLogger.getCreatedDirs(-1)) {
                this.addCreatedDir(installFile, -1);
            }
        }
        for (BackupPair backupPair : this.replacedFiles) {
            UninstallMode uninstallMode = backupPair.getOriginalFile().getUninstallMode();
            if (uninstallMode == UninstallMode.ALWAYS || uninstallMode == UninstallMode.ALWAYS_BUT_NOT_FOR_UPDATE) {
                this.addCreatedFile(backupPair.getOriginalFile(), -1);
                continue;
            }
            if (backupPair.isPreviouslyCreated()) continue;
            this.addOverwrittenFile(backupPair.getOriginalFile(), -1);
        }
        RandomAccessFile raFile = new RandomAccessFile(logFile, "rw");
        raFile.setLength(0L);
        raFile.close();
        PrintWriter pw = new PrintWriter(new OutputStreamWriter((OutputStream)new BufferedOutputStream(new FileOutputStream(logFile, true)), "UTF-8"));
        pw.println("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?>");
        pw.println("<fileLog>");
        pw.println("<createdFiles>");
        this.addEntries(pw, this.createdFiles);
        pw.println("</createdFiles>");
        pw.println("<createdDirs>");
        this.addEntries(pw, this.createdDirs);
        pw.println("</createdDirs>");
        pw.println("</fileLog>");
        pw.close();
    }

    private void addEntries(PrintWriter pw, Collection<InstallFile> col) {
        for (InstallFile file : col) {
            this.addEntry(pw, file);
        }
    }

    private void addEntry(PrintWriter pw, File file) {
        pw.print("<entry name=\"");
        String path = file.getAbsolutePath();
        String installationDirectory = ContextImpl.getSingleContextInt().getInstallationDirectory().getPath();
        if (path.startsWith(installationDirectory + File.separator)) {
            int startIndex;
            for (startIndex = installationDirectory.length(); startIndex < path.length() && path.charAt(startIndex) == File.separatorChar; ++startIndex) {
            }
            path = path.substring(startIndex);
        } else if (Objects.equals(path, installationDirectory)) {
            path = ".";
        }
        pw.print(path.replaceAll("&", "&amp;"));
        pw.print("\" shared=\"");
        boolean shared = false;
        UninstallMode uninstallMode = UninstallMode.IF_CREATED;
        if (file instanceof InstallFile) {
            InstallFile installFile = (InstallFile)file;
            uninstallMode = installFile.getUninstallMode();
            shared = installFile.isShared();
        }
        pw.print(shared);
        pw.print("\" uninstallMode=\"");
        pw.print(uninstallMode.getIntValue());
        pw.println("\"/>");
    }

    public void read(File logFile) throws IOException {
        Element rootElement = XmlHelper.parseFile(logFile).getDocumentElement();
        for (Element element : XmlHelper.childElements(rootElement)) {
            if (Objects.equals(element.getTagName(), ELEMENT_CREATED_FILES)) {
                this.readEntries(element, this.createdFiles);
                continue;
            }
            if (!Objects.equals(element.getTagName(), ELEMENT_CREATED_DIRS)) continue;
            this.readEntries(element, this.createdDirs);
        }
    }

    private void readEntries(Element parent, Collection<InstallFile> col) {
        for (Element element : XmlHelper.childElements(parent)) {
            int uninstallMode = XmlHelper.readAttribute(element, ATTRIBUTE_UNINSTALL_MODE, -1);
            if (uninstallMode == -1) {
                boolean dontUninstall = XmlHelper.readAttribute(element, ATTRIBUTE_DONT_UNINSTALL, false);
                uninstallMode = dontUninstall ? 1 : 0;
            }
            String fileName = XmlHelper.readAttribute(element, ATTRIBUTE_NAME, "");
            File installationDirectory = ContextImpl.getSingleContextInt().getInstallationDirectory().getAbsoluteFile();
            if (Objects.equals(fileName, ".")) {
                fileName = installationDirectory.getPath();
            } else if (!new File(fileName).isAbsolute()) {
                File absoluteFile = new File(installationDirectory, fileName);
                fileName = absoluteFile.getPath();
            }
            col.add(new InstallFile(fileName, XmlHelper.readAttribute(element, ATTRIBUTE_SHARED, false), UninstallMode.getFromIntValue(uninstallMode)));
        }
    }

    public Collection<InstallFile> getCreatedDirs(int id) {
        Set<Integer> rolledBackIds = FileInstallerState.getInstance().getRolledBackIds();
        ArrayList<InstallFile> list = new ArrayList<InstallFile>();
        for (InstallFile installFile : this.createdDirs) {
            if (installFile.getRollbackId() < id || rolledBackIds.contains(new Integer(installFile.getRollbackId()))) continue;
            list.add(installFile);
        }
        return list;
    }

    public Collection<InstallFile> getCreatedFiles(int id) {
        Set<Integer> rolledBackIds = FileInstallerState.getInstance().getRolledBackIds();
        ArrayList<InstallFile> list = new ArrayList<InstallFile>();
        for (InstallFile installFile : this.createdFiles) {
            if (installFile.getRollbackId() < id || rolledBackIds.contains(new Integer(installFile.getRollbackId()))) continue;
            list.add(installFile);
        }
        return list;
    }

    public List<BackupPair> getReplacedFiles(int id) {
        Set<Integer> rolledBackIds = FileInstallerState.getInstance().getRolledBackIds();
        ArrayList<BackupPair> list = new ArrayList<BackupPair>();
        for (BackupPair backupPair : this.replacedFiles) {
            if (backupPair.getRollbackId() < id || rolledBackIds.contains(new Integer(backupPair.getRollbackId()))) continue;
            list.add(backupPair);
        }
        return list;
    }

    public void addCreatedDir(InstallFile createdFile, int id) {
        createdFile = new InstallFile(createdFile.getAbsoluteFile(), createdFile.isShared(), createdFile.getUninstallMode());
        createdFile.setRollbackId(id);
        this.createdDirs.add(createdFile);
    }

    public void addCreatedFile(InstallFile createdFile, int id) {
        createdFile = new InstallFile(createdFile.getAbsoluteFile(), createdFile.isShared(), createdFile.getUninstallMode());
        createdFile.setRollbackId(id);
        this.createdFiles.add(createdFile);
    }

    private void addOverwrittenFile(InstallFile file, int id) {
        file = new InstallFile(file.getAbsoluteFile(), file.isShared(), UninstallMode.NEVER);
        file.setRollbackId(id);
        this.createdFiles.add(file);
    }

    public void addReplacedFile(BackupPair backupPair, int id) {
        backupPair.setRollbackId(id);
        this.replacedFiles.add(backupPair);
    }

    public boolean containsCreatedFile(File file) {
        return this.createdFiles.contains(file.getAbsoluteFile());
    }

    public boolean hasFiles() {
        return this.createdDirs.size() > 0 || this.createdFiles.size() > 0 || this.replacedFiles.size() > 0;
    }

    private static class ReverseComparator
    implements Comparator<InstallFile>,
    Serializable {
        private ReverseComparator() {
        }

        @Override
        public int compare(InstallFile o1, InstallFile o2) {
            return -o1.compareTo(o2);
        }
    }
}

