/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.filter;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import java.util.HashMap;
import java.util.Map;
import ucar.ma2.Array;
import ucar.ma2.DataType;
import ucar.ma2.IndexIterator;
import ucar.nc2.filter.Filter;
import ucar.nc2.filter.FilterProvider;

public class ScaleOffset
extends Filter {
    private static Map<String, DataType> dTypeMap = new HashMap<String, DataType>();
    private final double offset;
    private final int scale;
    private final ByteOrder dtypeOrder;
    private final DataType dtype;
    private final DataType astype;
    private final ByteOrder astypeOrder;

    public ScaleOffset(Map<String, Object> properties) {
        this.offset = ((Number)properties.get("offset")).doubleValue();
        this.scale = (Integer)properties.get("scale");
        String type = (String)properties.get("dtype");
        this.dtype = ScaleOffset.parseDataType(type);
        if (this.dtype == null) {
            throw new RuntimeException("ScaleOffset error: could not parse dtype");
        }
        this.dtypeOrder = ScaleOffset.parseByteOrder(type, ByteOrder.LITTLE_ENDIAN);
        String aType = (String)properties.getOrDefault("astype", type);
        this.astype = ScaleOffset.parseDataType(aType);
        this.astypeOrder = ScaleOffset.parseByteOrder(aType, this.dtypeOrder);
    }

    @Override
    public byte[] encode(byte[] dataIn) {
        Array in = Array.factory(this.dtype, new int[]{dataIn.length / this.dtype.getSize()}, this.convertToType(dataIn, this.dtype, this.dtypeOrder));
        Array out = this.applyScaleOffset(in);
        return this.arrayToBytes(out, this.astype, this.astypeOrder);
    }

    @Override
    public byte[] decode(byte[] dataIn) {
        Array in = Array.factory(this.astype, new int[]{dataIn.length / this.astype.getSize()}, this.convertToType(dataIn, this.astype, this.astypeOrder));
        Array out = this.removeScaleOffset(in);
        return this.arrayToBytes(out, this.dtype, this.dtypeOrder);
    }

    private Array applyScaleOffset(Array in) {
        DataType outType = this.astype;
        if (this.astype.getSignedness() == DataType.Signedness.UNSIGNED) {
            outType = this.nextLarger(this.astype).withSignedness(DataType.Signedness.UNSIGNED);
        }
        Array out = Array.factory(outType, in.getShape());
        IndexIterator iterIn = in.getIndexIterator();
        IndexIterator iterOut = out.getIndexIterator();
        while (iterIn.hasNext()) {
            Number value = (Number)iterIn.getObjectNext();
            value = this.convertUnsigned(value, this.dtype.getSignedness());
            value = this.applyScaleOffset(value);
            iterOut.setObjectNext(value);
        }
        return out;
    }

    private Array removeScaleOffset(Array in) {
        DataType outType = this.dtype;
        if (this.dtype.getSignedness() == DataType.Signedness.UNSIGNED) {
            outType = this.nextLarger(this.dtype).withSignedness(DataType.Signedness.UNSIGNED);
        }
        Array out = Array.factory(outType, in.getShape());
        IndexIterator iterIn = in.getIndexIterator();
        IndexIterator iterOut = out.getIndexIterator();
        while (iterIn.hasNext()) {
            Number value = (Number)iterIn.getObjectNext();
            value = this.convertUnsigned(value, this.astype.getSignedness());
            value = this.removeScaleOffset(value);
            iterOut.setObjectNext(value);
        }
        return out;
    }

    private static DataType parseDataType(String dtype) {
        dtype = dtype.replace(">", "");
        dtype = dtype.replace("<", "");
        dtype = dtype.replace("|", "");
        return dTypeMap.getOrDefault(dtype, null);
    }

    private static ByteOrder parseByteOrder(String dtype, ByteOrder defaultOrder) {
        if (dtype.startsWith(">")) {
            return ByteOrder.BIG_ENDIAN;
        }
        if (dtype.startsWith("<")) {
            return ByteOrder.LITTLE_ENDIAN;
        }
        if (dtype.startsWith("|")) {
            return ByteOrder.nativeOrder();
        }
        return defaultOrder;
    }

    private DataType nextLarger(DataType dataType) {
        switch (dataType) {
            case BYTE: {
                return DataType.SHORT;
            }
            case UBYTE: {
                return DataType.USHORT;
            }
            case SHORT: {
                return DataType.INT;
            }
            case USHORT: {
                return DataType.UINT;
            }
            case INT: {
                return DataType.LONG;
            }
            case UINT: {
                return DataType.ULONG;
            }
            case LONG: 
            case ULONG: {
                return DataType.DOUBLE;
            }
        }
        return dataType;
    }

    private Number convertUnsigned(Number value, DataType.Signedness signedness) {
        if (signedness == DataType.Signedness.UNSIGNED) {
            return DataType.widenNumberIfNegative(value);
        }
        return value;
    }

    private Object convertToType(byte[] dataIn, DataType wantType, ByteOrder bo) {
        if (wantType.getSize() == 1) {
            return dataIn;
        }
        ByteBuffer bb = ByteBuffer.wrap(dataIn);
        bb.order(bo);
        switch (wantType) {
            case SHORT: 
            case USHORT: {
                ShortBuffer sb = bb.asShortBuffer();
                short[] shortArray = new short[sb.limit()];
                sb.get(shortArray);
                return shortArray;
            }
            case INT: 
            case UINT: {
                IntBuffer ib = bb.asIntBuffer();
                int[] intArray = new int[ib.limit()];
                ib.get(intArray);
                return intArray;
            }
            case LONG: 
            case ULONG: {
                LongBuffer lb = bb.asLongBuffer();
                long[] longArray = new long[lb.limit()];
                lb.get(longArray);
                return longArray;
            }
            case FLOAT: {
                FloatBuffer fb = bb.asFloatBuffer();
                float[] floatArray = new float[fb.limit()];
                fb.get(floatArray);
                return floatArray;
            }
            case DOUBLE: {
                DoubleBuffer db = bb.asDoubleBuffer();
                double[] doubleArray = new double[db.limit()];
                db.get(doubleArray);
                return doubleArray;
            }
        }
        return bb.array();
    }

    private int applyScaleOffset(Number value) {
        double convertedValue = value.doubleValue();
        return (int)Math.round((convertedValue - this.offset) * (double)this.scale);
    }

    private double removeScaleOffset(Number value) {
        double convertedValue = value.doubleValue();
        return convertedValue / (double)this.scale + this.offset;
    }

    private byte[] arrayToBytes(Array arr, DataType type, ByteOrder order) {
        ByteBuffer bb = ByteBuffer.allocate((int)arr.getSize() * type.getSize());
        bb.order(order);
        IndexIterator ii = arr.getIndexIterator();
        while (ii.hasNext()) {
            switch (type) {
                case BYTE: 
                case UBYTE: {
                    bb.put(ii.getByteNext());
                    break;
                }
                case SHORT: 
                case USHORT: {
                    bb.putShort(ii.getShortNext());
                    break;
                }
                case INT: 
                case UINT: {
                    bb.putInt(ii.getIntNext());
                    break;
                }
                case LONG: 
                case ULONG: {
                    bb.putLong(ii.getLongNext());
                    break;
                }
                case FLOAT: {
                    bb.putFloat(ii.getFloatNext());
                    break;
                }
                case DOUBLE: {
                    bb.putDouble(ii.getDoubleNext());
                }
            }
        }
        return bb.array();
    }

    static {
        dTypeMap.put("i1", DataType.BYTE);
        dTypeMap.put("u1", DataType.UBYTE);
        dTypeMap.put("i2", DataType.SHORT);
        dTypeMap.put("u2", DataType.USHORT);
        dTypeMap.put("i4", DataType.INT);
        dTypeMap.put("f4", DataType.FLOAT);
        dTypeMap.put("u4", DataType.UINT);
        dTypeMap.put("i8", DataType.LONG);
        dTypeMap.put("f8", DataType.DOUBLE);
        dTypeMap.put("u8", DataType.ULONG);
    }

    public static class Provider
    implements FilterProvider {
        private static final String name = "fixedscaleoffset";
        private static final int id = -1;

        @Override
        public String getName() {
            return name;
        }

        @Override
        public int getId() {
            return -1;
        }

        @Override
        public Filter create(Map<String, Object> properties) {
            return new ScaleOffset(properties);
        }
    }
}

