/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.arc.pds.tools.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StrUtils {
    public static final int DEFAULT_TRUNCATE_LENGTH = 100;
    public static final String JS_NEWLINE = "\n";
    public static final String HTML_NEWLINE = "<br />";
    public static final int DEFAULT_STACK_LINES = 4;
    public static final Pattern NORMALIZE_WHITE_SPACE_REGEX = Pattern.compile("\\s+", 8);
    public static final Pattern URL_BASE_REGEX = Pattern.compile("^(https?://[^/]+)(([^\\?]*/).*)?");
    public static final String ASCII_CHAR_RANGE = "\\r\\n\\t -~";
    public static final Pattern ASCII_CHARS_REGEX = Pattern.compile("^[\\r\\n\\t -~]*$", 8);
    public static final Pattern STRIP_ASCII_REGEX = Pattern.compile("[\\r\\n\\t -~]+", 8);
    public static final Pattern NUMERIC_REGEX = Pattern.compile("^[+-]?\\d{1,3}(((,\\d{3})*(\\.\\d+)?)|((\\.\\d{3})*(,\\d+)?))?$");
    public static final Pattern SIMPLE_NUMERIC_REGEX = Pattern.compile("^[+-]?((\\d+((,|\\.)\\d*)?)|((,|\\.)\\d+))$");
    public static final Pattern STATEMENT_REGEX = Pattern.compile("^[^;]+;\n", 40);
    public static final Pattern STRIP_PADDING = Pattern.compile("[ \\t\\x0B]*([^ \\t\\x0B\\n\\r\\f]([^\\n\\r\\f]*[^ \\t\\x0B\\n\\r\\f])?)[ \\t\\x0B]*", 8);
    public static final String[] REGEX_SPECIAL_CHARS = new String[]{"\\", "/", ".", "*", "+", "?", "|", "(", ")", "[", "]", "{", "}"};

    public static String safeJS(String string) {
        String returnString = string;
        returnString = returnString.replaceAll("(\"|'|\\\\)", "\\\\$1");
        return returnString;
    }

    public static String dequote(String string) {
        return string.replaceFirst("^\"(.*)\"$", "$1");
    }

    public static String toString(List<?> list, Boolean isJS) {
        String lineBreak = null;
        String returnString = "";
        lineBreak = isJS == null || isJS == false ? HTML_NEWLINE : JS_NEWLINE;
        Iterator<?> it = list.iterator();
        while (it.hasNext()) {
            Object element = it.next();
            returnString = returnString + element.toString();
            if (!it.hasNext()) continue;
            returnString = returnString + lineBreak;
        }
        return returnString;
    }

    public static String toString(Exception e, Boolean isJS, Integer lines) {
        String stackString;
        int i;
        String newline = isJS == null || isJS == false ? HTML_NEWLINE : JS_NEWLINE;
        StackTraceElement[] stackTrace = e.getStackTrace();
        StackTraceElement[] causeTrace = null;
        Throwable causeE = e.getCause();
        if (causeE != null) {
            causeTrace = causeE.getStackTrace();
        }
        Integer numLines = lines == null ? stackTrace.length : lines;
        String message = e.getMessage();
        if (message == null) {
            message = e.toString();
        }
        if (numLines > 0) {
            for (i = 0; i < numLines; ++i) {
                stackString = stackTrace[i].toString();
                if (stackString.equals("")) continue;
                message = message + newline + stackString;
            }
        }
        if (causeTrace != null) {
            numLines = causeTrace.length;
            message = message + newline + "Caused by";
            if (numLines > 0) {
                for (i = 0; i < numLines; ++i) {
                    stackString = causeTrace[i].toString();
                    if (stackString.equals("")) continue;
                    message = message + newline + stackString;
                }
            }
        }
        return message;
    }

    public static String toString(Exception e, Boolean isJS) {
        return StrUtils.toString(e, isJS, 4);
    }

    public static String toString(List<?> list) {
        return StrUtils.toString(list, null);
    }

    public static String toString(Object[] list) {
        return StrUtils.toString(Arrays.asList(list), (Boolean)false);
    }

    public static String toString(Object[] list, Boolean isJS) {
        return StrUtils.toString(Arrays.asList(list), isJS);
    }

    public static String toString(String[] list, Boolean isJS) {
        return StrUtils.toString(Arrays.asList(list), isJS);
    }

    public static String toString(InputStream is) throws IOException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(is));
        StringBuilder sb = new StringBuilder();
        String line = null;
        while ((line = reader.readLine()) != null) {
            sb.append(line + JS_NEWLINE);
        }
        is.close();
        return sb.toString();
    }

    public static String toString(Object object) {
        return object == null ? null : object.toString();
    }

    public static String escapeRegex(String regexSource) {
        String returnString = regexSource;
        for (String specialChar : REGEX_SPECIAL_CHARS) {
            returnString = returnString.replaceAll("\\" + specialChar, "\\\\\\" + specialChar);
        }
        return returnString;
    }

    public static String truncate(String string) {
        return StrUtils.truncate(string, null);
    }

    public static String truncate(String string, Integer length) {
        Integer truncateLength = length == null ? 100 : length;
        if (string == null || string.length() <= truncateLength) {
            return string;
        }
        return string.substring(0, truncateLength) + "...";
    }

    public static String normalize(String string) {
        String returnString = string.trim();
        Matcher matcher = NORMALIZE_WHITE_SPACE_REGEX.matcher(returnString);
        return matcher.replaceAll(" ");
    }

    public static String getURLBase(String string) {
        Matcher matcher = URL_BASE_REGEX.matcher(string);
        if (matcher.matches()) {
            String urlBase = matcher.group(1);
            String pastDomain = matcher.group(3);
            if (pastDomain != null && pastDomain.length() > 0) {
                return urlBase + pastDomain;
            }
            return urlBase + "/";
        }
        return null;
    }

    public static String getURLFilename(String url) {
        URL URLObj = null;
        try {
            URLObj = new URL(url);
        }
        catch (MalformedURLException e) {
            return null;
        }
        return StrUtils.getURLFilename(URLObj);
    }

    public static String getURIFilename(URI uri) {
        try {
            return StrUtils.getURLFilename(uri.toURL());
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    public static String getURLFilename(URL url) {
        String filename = url.getFile();
        int paramIndex = filename.lastIndexOf("?");
        if (paramIndex != -1) {
            filename = filename.substring(0, paramIndex);
        }
        filename = filename.substring(filename.lastIndexOf("/") + 1, filename.length());
        return filename;
    }

    public static boolean isASCII(String string) {
        if (string.length() == 0) {
            return true;
        }
        Matcher matcher = ASCII_CHARS_REGEX.matcher(string);
        return matcher.matches();
    }

    public static String getNonASCII(String string) {
        Matcher matcher = STRIP_ASCII_REGEX.matcher(string);
        String returnString = matcher.replaceAll("");
        return returnString;
    }

    public static String toSeparatedString(List<?> list) {
        String returnString = "";
        Iterator<?> it = list.iterator();
        while (it.hasNext()) {
            Object element = it.next();
            String val = null;
            val = element.toString();
            returnString = returnString + val;
            if (!it.hasNext()) continue;
            returnString = returnString + ", ";
        }
        return returnString;
    }

    public static String toSeparatedString(Object[] array) {
        if (array == null) {
            return "";
        }
        List<Object> list = Arrays.asList(array);
        return StrUtils.toSeparatedString(list);
    }

    public static boolean isNumber(String string) {
        if (string == null) {
            return false;
        }
        Matcher simpleMatcher = SIMPLE_NUMERIC_REGEX.matcher(string);
        if (simpleMatcher.matches()) {
            return true;
        }
        Matcher complexMatcher = NUMERIC_REGEX.matcher(string);
        return complexMatcher.matches();
    }

    public static Number getNumber(String string, Locale locale) {
        try {
            if (!StrUtils.isNumber(string)) {
                return null;
            }
            return NumberFormat.getInstance(locale).parse(string.replaceAll("\\+", ""));
        }
        catch (ParseException e) {
            return null;
        }
    }

    public static Number getNumber(String string) {
        Locale locale = new Locale("en_us");
        return StrUtils.getNumber(string, locale);
    }

    public static Number getNumberLoose(String string) {
        String numberVal = string.replaceAll("[^0-9]", "");
        try {
            return NumberFormat.getInstance(new Locale("en_us")).parse(numberVal);
        }
        catch (ParseException e) {
            return null;
        }
    }

    public static List<String> toStatements(String sql) {
        ArrayList<String> statements = new ArrayList<String>();
        Matcher matcher = STATEMENT_REGEX.matcher(sql);
        while (matcher.find()) {
            String currentMatch = sql.substring(matcher.start(), matcher.end());
            statements.add(currentMatch);
        }
        return Collections.unmodifiableList(statements);
    }

    public static boolean nullOrEmpty(String string) {
        return string == null || string.trim().equals("");
    }

    public static String stripPadding(String string) {
        if (string == null) {
            return null;
        }
        String temp = string.replaceAll("^[ \\t\\x0B]*(\\r\\n|\r|\n)", "");
        temp = temp.replaceAll("[ \\t\\x0B]*([^ \\t\\x0B\\n\\r\\f]([^\\n\\r\\f]*[^ \\t\\x0B\\n\\r\\f])?)[ \\t\\x0B]*", "$1");
        return temp.replaceAll("(\\r\\n|\\n\\r|\r|\n)", " ");
    }

    public static String toUpper(String string) {
        String out = "";
        String source = string.toLowerCase();
        String[] parts = source.split(" ");
        for (int i = 0; i < parts.length; ++i) {
            String part = parts[i];
            out = out + part.substring(0, 1).toUpperCase() + part.substring(1);
            if (i >= parts.length - 1) continue;
            out = out + " ";
        }
        return out;
    }

    public static String getNice(String string, Boolean capitalize, Boolean replaceUnderscore) {
        String out = string.trim();
        if (replaceUnderscore == null || replaceUnderscore.booleanValue()) {
            out = out.replaceAll("_", " ");
        }
        if (capitalize == null || capitalize.booleanValue()) {
            out = StrUtils.toUpper(out);
        }
        return out;
    }

    public static String getNice(String string) {
        return StrUtils.getNice(string, true, true);
    }

    public static String addWildcards(String string) {
        return string.replaceFirst("^\\**+(.*?)\\**+$", "*$1*");
    }

    public static String getAlternateCaseString(String string) {
        Character character = Character.valueOf(string.charAt(0));
        if (Character.isLowerCase(character.charValue())) {
            return string.toUpperCase();
        }
        return string.toLowerCase();
    }

    public static String getNonNull(Object ... objects) {
        for (Object object : objects) {
            if (object == null) continue;
            return object.toString();
        }
        return null;
    }
}

