/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.pds.label;

import gov.nasa.arc.pds.xml.generated.Array;
import gov.nasa.arc.pds.xml.generated.ByteStream;
import gov.nasa.arc.pds.xml.generated.EncodedByteStream;
import gov.nasa.arc.pds.xml.generated.FileAreaObservational;
import gov.nasa.arc.pds.xml.generated.FileAreaObservationalSupplemental;
import gov.nasa.arc.pds.xml.generated.ParsableByteStream;
import gov.nasa.arc.pds.xml.generated.Product;
import gov.nasa.arc.pds.xml.generated.ProductObservational;
import gov.nasa.arc.pds.xml.generated.TableBinary;
import gov.nasa.arc.pds.xml.generated.TableCharacter;
import gov.nasa.arc.pds.xml.generated.TableDelimited;
import gov.nasa.pds.label.LabelStandard;
import gov.nasa.pds.label.ProductType;
import gov.nasa.pds.label.object.ArrayObject;
import gov.nasa.pds.label.object.DataObject;
import gov.nasa.pds.label.object.GenericObject;
import gov.nasa.pds.label.object.TableObject;
import gov.nasa.pds.objectAccess.ObjectAccess;
import gov.nasa.pds.objectAccess.ParseException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.math.BigInteger;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class Label {
    private ObjectAccess oa;
    private URL parentDir;
    private Product genericProduct;
    private LabelStandard standard;

    private Label(File labelFile) throws ParseException, MalformedURLException {
        this(labelFile.toURI().toURL());
    }

    private Label(URL label) throws ParseException {
        try {
            URI labelUri = label.toURI().normalize();
            this.parentDir = labelUri.getPath().endsWith("/") ? labelUri.resolve("..").toURL() : labelUri.resolve(".").toURL();
            this.oa = new ObjectAccess(this.parentDir);
            this.genericProduct = this.oa.getProduct(labelUri.toURL(), Product.class);
            this.standard = LabelStandard.PDS4;
        }
        catch (Exception e) {
            throw new ParseException(e.getMessage(), e);
        }
    }

    public void close() {
        this.oa = null;
        this.parentDir = null;
        this.genericProduct = null;
    }

    public static Label open(File labelFile) throws ParseException {
        try {
            return new Label(labelFile.toURI().toURL());
        }
        catch (MalformedURLException e) {
            throw new ParseException(e.getMessage(), e);
        }
    }

    public static Label open(URL label) throws ParseException {
        return new Label(label);
    }

    public LabelStandard getLabelStandard() {
        return this.standard;
    }

    public String getStandardVersion() {
        return this.genericProduct.getIdentificationArea().getInformationModelVersion();
    }

    public Class<? extends Product> getProductClass() {
        return this.genericProduct.getClass();
    }

    public ProductType getProductType() {
        return ProductType.typeForClass(this.getProductClass());
    }

    public List<DataObject> getObjects() throws Exception {
        return this.getObjects(DataObject.class);
    }

    public <T extends DataObject> List<T> getObjects(Class<T> clazz) throws Exception {
        if (!(this.genericProduct instanceof ProductObservational)) {
            throw new ClassCastException("Only objects from Product_Observational labels are supported.");
        }
        ArrayList<DataObject> subset = new ArrayList<DataObject>();
        for (DataObject object : this.getObjects((ProductObservational)this.genericProduct)) {
            if (!clazz.isAssignableFrom(object.getClass())) continue;
            subset.add(object);
        }
        return subset;
    }

    private List<DataObject> getObjects(ProductObservational product) throws Exception {
        ArrayList<DataObject> objects = new ArrayList<DataObject>();
        for (FileAreaObservational fileArea : product.getFileAreaObservationals()) {
            for (ByteStream stream : fileArea.getDataObjects()) {
                this.addObject(objects, fileArea.getFile(), stream);
            }
        }
        for (FileAreaObservationalSupplemental supplementalArea : product.getFileAreaObservationalSupplementals()) {
            for (ByteStream stream : supplementalArea.getDataObjects()) {
                this.addObject(objects, supplementalArea.getFile(), stream);
            }
        }
        return objects;
    }

    private void addObject(Collection<DataObject> objects, gov.nasa.arc.pds.xml.generated.File file, ByteStream stream) throws Exception {
        if (stream instanceof TableBinary) {
            objects.add(this.makeTable(file, (TableBinary)stream));
        } else if (stream instanceof TableCharacter) {
            TableCharacter table = (TableCharacter)stream;
            objects.add(this.makeTable(file, table));
        } else if (stream instanceof TableDelimited) {
            objects.add(this.makeTable(file, (TableDelimited)stream));
        } else if (stream instanceof Array) {
            objects.add(this.makeArray(file, (Array)stream));
        } else {
            objects.add(this.makeGenericObject(file, stream));
        }
    }

    private DataObject makeTable(gov.nasa.arc.pds.xml.generated.File file, TableBinary table) throws Exception {
        BigInteger size = table.getRecords().multiply(table.getRecordBinary().getRecordLength().getValue());
        return new TableObject(this.parentDir, file, (Object)table, table.getOffset().getValue().longValueExact(), size.longValueExact());
    }

    private DataObject makeTable(gov.nasa.arc.pds.xml.generated.File file, TableCharacter table) throws Exception {
        BigInteger size = table.getRecords().multiply(table.getRecordCharacter().getRecordLength().getValue());
        return new TableObject(this.parentDir, file, (Object)table, table.getOffset().getValue().longValueExact(), size.longValueExact());
    }

    private DataObject makeTable(gov.nasa.arc.pds.xml.generated.File file, TableDelimited table) throws Exception {
        long offset = 0L;
        if (table.getOffset() != null) {
            offset = table.getOffset().getValue().longValueExact();
        }
        long size = -1L;
        if (file.getFileSize() != null) {
            size = file.getFileSize().getValue().longValue() - offset;
        }
        return new TableObject(this.parentDir, file, (Object)table, offset, size);
    }

    private DataObject makeArray(gov.nasa.arc.pds.xml.generated.File file, Array array) throws FileNotFoundException, IOException {
        return new ArrayObject(this.parentDir, file, array, array.getOffset().getValue().longValueExact());
    }

    private DataObject makeGenericObject(gov.nasa.arc.pds.xml.generated.File file, ByteStream stream) throws IOException {
        long size = -1L;
        long offset = -1L;
        if (stream instanceof EncodedByteStream) {
            EncodedByteStream ebs = (EncodedByteStream)stream;
            size = ebs.getObjectLength().getValue().longValueExact();
            offset = ebs.getOffset().getValue().longValueExact();
        } else if (stream instanceof ParsableByteStream) {
            ParsableByteStream pbs = (ParsableByteStream)stream;
            size = pbs.getObjectLength().getValue().longValueExact();
            offset = pbs.getOffset().getValue().longValueExact();
        }
        return new GenericObject(this.parentDir, file, offset, size);
    }
}

