/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.pds.objectAccess;

import au.com.bytecode.opencsv.CSVWriter;
import gov.nasa.pds.label.object.FieldDescription;
import gov.nasa.pds.label.object.TableRecord;
import gov.nasa.pds.objectAccess.DelimitedTableRecord;
import gov.nasa.pds.objectAccess.FixedTableRecord;
import gov.nasa.pds.objectAccess.InvalidTableException;
import gov.nasa.pds.objectAccess.TableExporter;
import gov.nasa.pds.objectAccess.table.AdapterFactory;
import gov.nasa.pds.objectAccess.table.DelimiterType;
import gov.nasa.pds.objectAccess.table.TableAdapter;
import gov.nasa.pds.objectAccess.table.TableBinaryAdapter;
import gov.nasa.pds.objectAccess.table.TableDelimitedAdapter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TableWriter {
    private Charset charset;
    private OutputStream outputStream;
    private TableAdapter adapter;
    private CSVWriter csvWriter = null;
    private TableRecord record = null;
    private Map<String, Integer> map = new HashMap<String, Integer>();
    private static final Logger LOGGER = LoggerFactory.getLogger(TableExporter.class);
    private static final String US_ASCII = "US-ASCII";

    public TableWriter(Object table, OutputStream outputStream, String charsetName) throws UnsupportedCharsetException, InvalidTableException {
        this.adapter = AdapterFactory.INSTANCE.getTableAdapter(table);
        this.outputStream = outputStream;
        this.setEncoding(charsetName);
        this.createFieldMap();
    }

    public TableWriter(Object table, OutputStream outputStream) throws InvalidTableException {
        this(table, outputStream, US_ASCII);
    }

    public TableWriter(Object table, Writer writer) throws InvalidTableException {
        this.adapter = AdapterFactory.INSTANCE.getTableAdapter(table);
        this.createFieldMap();
        this.csvWriter = new CSVWriter(writer, ((TableDelimitedAdapter)this.adapter).getFieldDelimiter(), '\\', DelimiterType.CARRIAGE_RETURN_LINE_FEED.getRecordDelimiter());
    }

    public TableRecord createRecord() {
        if (this.record == null) {
            this.record = this.adapter instanceof TableDelimitedAdapter ? new DelimitedTableRecord(this.map, this.adapter.getFieldCount()) : new FixedTableRecord(this.adapter.getRecordLength(), this.map, this.adapter.getFields(), this.charset, this.adapter instanceof TableBinaryAdapter);
        } else {
            this.record.clear();
        }
        return this.record;
    }

    public void write(TableRecord record) throws IOException {
        if (this.adapter instanceof TableDelimitedAdapter) {
            this.csvWriter.writeNext(((DelimitedTableRecord)record).getRecordValue());
        } else {
            this.outputStream.write(((FixedTableRecord)record).getRecordValue());
        }
    }

    public void flush() throws IOException {
        if (this.adapter instanceof TableDelimitedAdapter) {
            this.csvWriter.flush();
        } else {
            this.outputStream.flush();
        }
    }

    public void close() throws IOException {
        if (this.adapter instanceof TableDelimitedAdapter) {
            this.csvWriter.close();
        } else {
            this.outputStream.close();
        }
    }

    private void setEncoding(String charsetName) {
        try {
            this.charset = Charset.forName(charsetName);
        }
        catch (UnsupportedCharsetException ex) {
            String msg = "The character set name is not a legal name.";
            LOGGER.error(msg, (Throwable)ex);
            throw new UnsupportedCharsetException(msg);
        }
    }

    private void createFieldMap() {
        this.map = new HashMap<String, Integer>();
        int fieldIndex = 1;
        for (FieldDescription field : this.adapter.getFields()) {
            if (!this.map.containsKey(field.getName())) {
                this.map.put(field.getName(), fieldIndex);
            }
            ++fieldIndex;
        }
    }
}

