/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.pds.objectAccess;

import java.io.IOException;
import java.io.OutputStream;
import jpl.mipl.io.vicar.AlreadyOpenException;
import jpl.mipl.io.vicar.SystemLabel;
import jpl.mipl.io.vicar.VicarInput;
import jpl.mipl.io.vicar.VicarInputImage;
import jpl.mipl.io.vicar.VicarLabel;
import jpl.mipl.io.vicar.VicarLabelItem;
import jpl.mipl.io.vicar.VicarLabelSet;
import jpl.mipl.io.vicar.VicarOutputFile;

public class VicarSystemLabelGenerator {
    private String _outfile;
    private SystemLabel label;
    private int _nl;
    private int _ns;
    private int _nb;
    private String _datatype;
    private int _datatype_code;
    private String _org;
    private String _method = "line";
    private double _linc;
    private double _sinc;
    private double _binc;
    private int _tileHeight;
    private int _tileWidth;
    private int _pixelStride;
    private String _infile = null;

    public void generateFile(OutputStream outputStream) throws AlreadyOpenException, IOException {
        VicarOutputFile voif = new VicarOutputFile();
        if (this._infile != null) {
            voif.setPrimaryInput((VicarInput)new VicarInputImage(this._infile));
        }
        SystemLabel sys = voif.getSystemLabel();
        sys.setOrg(this._org);
        sys.setNL(this._nl);
        sys.setNS(this._ns);
        sys.setNB(this._nb);
        sys.setFormat(this._datatype);
        this._datatype_code = sys.getFormatCode();
        voif.setSystemLabel(sys);
        VicarLabel lbl = voif.getVicarLabel();
        VicarLabelSet task = lbl.createHistoryTask("TestGen");
        task.add(new VicarLabelItem("IVAL", 0.0f));
        task.add(new VicarLabelItem("SINC", this._sinc));
        task.add(new VicarLabelItem("LINC", this._linc));
        task.add(new VicarLabelItem("BINC", this._binc));
        task.add(new VicarLabelItem("MODULO", 0.0f));
        voif.setVicarLabel(lbl);
        voif.open(outputStream);
    }

    public String get_outfile() {
        return this._outfile;
    }

    public void set_outfile(String _outfile) {
        this._outfile = _outfile;
    }

    public int get_nl() {
        return this._nl;
    }

    public void set_nl(int _nl) {
        this._nl = _nl;
    }

    public int get_ns() {
        return this._ns;
    }

    public void set_ns(int _ns) {
        this._ns = _ns;
    }

    public int get_nb() {
        return this._nb;
    }

    public void set_nb(int _nb) {
        this._nb = _nb;
    }

    public String get_datatype() {
        return this._datatype;
    }

    public void set_datatype(String _datatype) {
        this._datatype = _datatype;
    }

    public int get_datatype_code() {
        return this._datatype_code;
    }

    public void set_datatype_code(int _datatype_code) {
        this._datatype_code = _datatype_code;
    }

    public String get_org() {
        return this._org;
    }

    public void set_org(String _org) {
        this._org = _org;
    }

    public String get_method() {
        return this._method;
    }

    public void set_method(String _method) {
        this._method = _method;
    }

    public double get_linc() {
        return this._linc;
    }

    public void set_linc(double _linc) {
        this._linc = _linc;
    }

    public double get_sinc() {
        return this._sinc;
    }

    public void set_sinc(double _sinc) {
        this._sinc = _sinc;
    }

    public double get_binc() {
        return this._binc;
    }

    public void set_binc(double _binc) {
        this._binc = _binc;
    }

    public int get_tileHeight() {
        return this._tileHeight;
    }

    public void set_tileHeight(int _tileHeight) {
        this._tileHeight = _tileHeight;
    }

    public int get_tileWidth() {
        return this._tileWidth;
    }

    public void set_tileWidth(int _tileWidth) {
        this._tileWidth = _tileWidth;
    }

    public int get_pixelStride() {
        return this._pixelStride;
    }

    public void set_pixelStride(int _pixelStride) {
        this._pixelStride = _pixelStride;
    }

    public String get_infile() {
        return this._infile;
    }

    public void set_infile(String _infile) {
        this._infile = _infile;
    }

    public SystemLabel getLabel() {
        return this.label;
    }

    public void setLabel(SystemLabel label) {
        this.label = label;
    }
}

