/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.pds.objectAccess.table;

import gov.nasa.pds.objectAccess.table.FieldAdapter;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.Charset;
import java.util.Arrays;

public class IntegerBinaryFieldAdapter
implements FieldAdapter {
    private int dataLength;
    private boolean isSigned;
    private boolean isBigEndian;

    public IntegerBinaryFieldAdapter(int length, boolean isSigned, boolean isBigEndian) {
        this.dataLength = length;
        this.isSigned = isSigned;
        this.isBigEndian = isBigEndian;
    }

    @Override
    public String getString(byte[] buf, int offset, int length, int startBit, int stopBit) {
        if (length < 8) {
            return Long.toString(this.getFieldValue(buf, offset, length));
        }
        return this.getBigIntegerFieldValue(buf, offset, length).toString();
    }

    @Override
    public String getString(byte[] buf, int offset, int length, int startBit, int stopBit, Charset charset) {
        return Long.toString(this.getFieldValue(buf, offset, length));
    }

    @Override
    public byte getByte(byte[] buf, int offset, int length, int startBit, int stopBit) {
        long value = this.getFieldValue(buf, offset, length);
        if (value < -128L || value > 127L) {
            throw new NumberFormatException("Binary integer value out of range for byte (" + value + ")");
        }
        return (byte)value;
    }

    @Override
    public short getShort(byte[] buf, int offset, int length, int startBit, int stopBit) {
        long value = this.getFieldValue(buf, offset, length);
        if (value < -32768L || value > 32767L) {
            throw new NumberFormatException("Binary integer value out of range for short (" + value + ")");
        }
        return (short)value;
    }

    @Override
    public int getInt(byte[] buf, int offset, int length, int startBit, int stopBit) {
        long value = this.getFieldValue(buf, offset, length);
        if (value < Integer.MIN_VALUE || value > Integer.MAX_VALUE) {
            throw new NumberFormatException("Binary integer value out of range for int (" + value + ")");
        }
        return (int)value;
    }

    @Override
    public long getLong(byte[] buf, int offset, int length, int startBit, int stopBit) {
        return this.getFieldValue(buf, offset, length);
    }

    @Override
    public float getFloat(byte[] buf, int offset, int length, int startBit, int stopBit) {
        return this.getFieldValue(buf, offset, length);
    }

    @Override
    public double getDouble(byte[] buf, int offset, int length, int startBit, int stopBit) {
        return this.getFieldValue(buf, offset, length);
    }

    @Override
    public void setString(String value, int offset, int length, ByteBuffer buffer, boolean isRightJustified) {
        this.setString(value, offset, length, buffer, isRightJustified, Charset.forName("US-ASCII"));
    }

    @Override
    public void setString(String value, int offset, int length, ByteBuffer buffer, boolean isRightJustified, Charset charset) {
        if (value.length() > length) {
            throw new IllegalArgumentException("The size of the value is greater than the field length.");
        }
        buffer.order(this.isBigEndian ? ByteOrder.BIG_ENDIAN : ByteOrder.LITTLE_ENDIAN);
        buffer.position(offset);
        buffer.put(value.getBytes(charset), 0, length);
    }

    @Override
    public void setByte(byte value, int offset, int length, ByteBuffer buffer, boolean isRightJustified) {
        buffer.order(this.isBigEndian ? ByteOrder.BIG_ENDIAN : ByteOrder.LITTLE_ENDIAN);
        buffer.put(offset, value);
    }

    @Override
    public void setShort(short value, int offset, int length, ByteBuffer buffer, boolean isRightJustified) {
        buffer.order(this.isBigEndian ? ByteOrder.BIG_ENDIAN : ByteOrder.LITTLE_ENDIAN);
        buffer.putShort(offset, value);
    }

    @Override
    public void setInt(int value, int offset, int length, ByteBuffer buffer, boolean isRightJustified) {
        buffer.order(this.isBigEndian ? ByteOrder.BIG_ENDIAN : ByteOrder.LITTLE_ENDIAN);
        buffer.putInt(offset, value);
    }

    @Override
    public void setLong(long value, int offset, int length, ByteBuffer buffer, boolean isRightJustified) {
        buffer.order(this.isBigEndian ? ByteOrder.BIG_ENDIAN : ByteOrder.LITTLE_ENDIAN);
        buffer.putLong(offset, value);
    }

    @Override
    public void setFloat(float value, int offset, int length, ByteBuffer buffer, boolean isRightJustified) {
        buffer.order(this.isBigEndian ? ByteOrder.BIG_ENDIAN : ByteOrder.LITTLE_ENDIAN);
        buffer.putFloat(offset, value);
    }

    @Override
    public void setDouble(double value, int offset, int length, ByteBuffer buffer, boolean isRightJustified) {
        buffer.order(this.isBigEndian ? ByteOrder.BIG_ENDIAN : ByteOrder.LITTLE_ENDIAN);
        buffer.putDouble(offset, value);
    }

    private long getFieldValue(byte[] b, int offset, int length) {
        if (this.dataLength != length) {
            throw new IllegalArgumentException("Declared field length does not match data type length (" + length + "!=" + this.dataLength + ")");
        }
        if (offset > b.length) {
            throw new IllegalArgumentException("Field offset '" + offset + "' is greater than the number of bytes in the record '" + b.length + "'");
        }
        if (offset + length > b.length) {
            throw new IllegalArgumentException("Field length '" + length + "' with offset '" + offset + "' exceeds the number of bytes in the record '" + b.length + "'");
        }
        if (this.isBigEndian) {
            return this.getFieldValueBigEndian(b, offset, length);
        }
        return this.getFieldValueLittleEndian(b, offset, length);
    }

    private long getFieldValueBigEndian(byte[] b, int offset, int length) {
        long result = 0L;
        for (int i = 0; i < length; ++i) {
            if (i == 0 && this.isSigned && b[offset + i] < 0) {
                result = -1L;
            }
            result = result << 8 | (long)(b[offset + i] & 0xFF);
        }
        return result;
    }

    private long getFieldValueLittleEndian(byte[] b, int offset, int length) {
        long result = 0L;
        for (int i = offset + length - 1; i >= offset; --i) {
            if (i == offset + length - 1 && this.isSigned && b[i] < 0) {
                result = -1L;
            }
            result = result << 8 | (long)(b[i] & 0xFF);
        }
        return result;
    }

    private BigInteger getBigIntegerFieldValue(byte[] b, int offset, int length) {
        if (this.dataLength != length) {
            throw new IllegalArgumentException("Declared field length does not match data type length (" + length + "!=" + this.dataLength + ")");
        }
        if (offset > b.length) {
            throw new IllegalArgumentException("Field offset '" + offset + "' is greater than the number of bytes in the record '" + b.length + "'");
        }
        if (offset + length > b.length) {
            throw new IllegalArgumentException("Field length '" + length + "' with offset '" + offset + "' exceeds the number of bytes in the record '" + b.length + "'");
        }
        if (this.isBigEndian) {
            return this.getBigIntegerFieldValueBigEndian(b, offset, length);
        }
        return this.getBigIntegerFieldValueLittleEndian(b, offset, length);
    }

    private BigInteger getBigIntegerFieldValueBigEndian(byte[] b, int offset, int length) {
        byte[] temp = new byte[length + 1];
        System.arraycopy(b, offset, temp, 1, length);
        temp[0] = !this.isSigned || b[offset] >= 0 ? 0 : -1;
        return new BigInteger(temp);
    }

    private BigInteger getBigIntegerFieldValueLittleEndian(byte[] b, int offset, int length) {
        byte[] temp = new byte[length + 1];
        for (int i = 1; i < temp.length; ++i) {
            temp[i] = b[offset + length - i];
        }
        temp[0] = !this.isSigned || b[offset + length - 1] >= 0 ? 0 : -1;
        return new BigInteger(temp);
    }

    @Override
    public BigInteger getBigInteger(byte[] buf, int offset, int length, int startBit, int stopBit) {
        return this.getBigIntegerFieldValue(buf, offset, length);
    }

    @Override
    public void setBigInteger(BigInteger value, int offset, int length, ByteBuffer buffer, boolean isRightJustified) {
        byte[] b = this.getBytes(value);
        if (b.length > length) {
            throw new IllegalArgumentException("Value too large to fit in field (value=" + value.toString() + ", length=" + length + ")");
        }
        this.setBigIntegerFieldValue(b, offset, length, buffer);
    }

    private byte[] getBytes(BigInteger value) {
        byte[] b = value.toByteArray();
        if (b.length <= 1 || b[0] != 0) {
            return b;
        }
        byte[] temp = new byte[b.length - 1];
        System.arraycopy(b, 1, temp, 0, temp.length);
        return temp;
    }

    private void setBigIntegerFieldValue(byte[] b, int offset, int length, ByteBuffer buffer) {
        if (this.isBigEndian) {
            this.setBigIntegerFieldValueBigEndian(b, offset, length, buffer);
        } else {
            this.setBigIntegerFieldValueLittleEndian(b, offset, length, buffer);
        }
    }

    private void setBigIntegerFieldValueBigEndian(byte[] b, int offset, int length, ByteBuffer buffer) {
        if (b.length < length) {
            byte[] temp = new byte[length - b.length];
            if (this.isSigned && b[0] < 0) {
                Arrays.fill(temp, (byte)-1);
            }
            buffer.position(offset);
            buffer.put(temp);
        }
        buffer.put(b);
    }

    private void setBigIntegerFieldValueLittleEndian(byte[] b, int offset, int length, ByteBuffer buffer) {
        for (int i = b.length - 1; i >= 0; --i) {
            buffer.put(offset++, b[i]);
        }
        byte fillValue = 0;
        if (this.isSigned && b[0] < 0) {
            fillValue = -1;
        }
        for (int i = b.length; i < length; ++i) {
            buffer.put(offset++, fillValue);
        }
    }
}

