/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.util;

import org.apache.poi.hssf.record.formula.SheetNameFormatter;

public final class CellReference {
    private static final char ABSOLUTE_REFERENCE_MARKER = '$';
    private static final char SHEET_NAME_DELIMITER = '!';
    private static final char SPECIAL_NAME_DELIMITER = '\'';
    private final int _rowIndex;
    private final int _colIndex;
    private final String _sheetName;
    private final boolean _isRowAbs;
    private final boolean _isColAbs;

    public CellReference(String cellRef) {
        String[] parts = CellReference.separateRefParts(cellRef);
        this._sheetName = parts[0];
        String colRef = parts[1];
        if (colRef.length() < 1) {
            throw new IllegalArgumentException("Invalid Formula cell reference: '" + cellRef + "'");
        }
        boolean bl = this._isColAbs = colRef.charAt(0) == '$';
        if (this._isColAbs) {
            colRef = colRef.substring(1);
        }
        this._colIndex = this.convertColStringToNum(colRef);
        String rowRef = parts[2];
        if (rowRef.length() < 1) {
            throw new IllegalArgumentException("Invalid Formula cell reference: '" + cellRef + "'");
        }
        boolean bl2 = this._isRowAbs = rowRef.charAt(0) == '$';
        if (this._isRowAbs) {
            rowRef = rowRef.substring(1);
        }
        this._rowIndex = Integer.parseInt(rowRef) - 1;
    }

    public CellReference(int pRow, int pCol, boolean pAbsRow, boolean pAbsCol) {
        this(null, pRow, pCol, pAbsRow, pAbsCol);
    }

    public CellReference(String pSheetName, int pRow, int pCol, boolean pAbsRow, boolean pAbsCol) {
        if (pRow < -1) {
            throw new IllegalArgumentException("row index may not be negative");
        }
        if (pCol < -1) {
            throw new IllegalArgumentException("column index may not be negative");
        }
        this._sheetName = pSheetName;
        this._rowIndex = pRow;
        this._colIndex = pCol;
        this._isRowAbs = pAbsRow;
        this._isColAbs = pAbsCol;
    }

    public int getRow() {
        return this._rowIndex;
    }

    public short getCol() {
        return (short)this._colIndex;
    }

    public boolean isRowAbsolute() {
        return this._isRowAbs;
    }

    public boolean isColAbsolute() {
        return this._isColAbs;
    }

    public String getSheetName() {
        return this._sheetName;
    }

    private int convertColStringToNum(String ref) {
        int lastIx = ref.length() - 1;
        int retval = 0;
        int pos = 0;
        for (int k = lastIx; k > -1; --k) {
            char thechar = ref.charAt(k);
            retval = pos == 0 ? (retval += Character.getNumericValue(thechar) - 9) : (retval += (Character.getNumericValue(thechar) - 9) * (pos * 26));
            ++pos;
        }
        return retval - 1;
    }

    private static String[] separateRefParts(String reference) {
        char ch;
        int plingPos = reference.lastIndexOf(33);
        String sheetName = CellReference.parseSheetName(reference, plingPos);
        int start = plingPos + 1;
        int length = reference.length();
        int loc = start;
        if (reference.charAt(loc) == '$') {
            ++loc;
        }
        while (loc < length && !Character.isDigit(ch = reference.charAt(loc)) && ch != '$') {
            ++loc;
        }
        return new String[]{sheetName, reference.substring(start, loc), reference.substring(loc)};
    }

    private static String parseSheetName(String reference, int indexOfSheetNameDelimiter) {
        boolean isQuoted;
        if (indexOfSheetNameDelimiter < 0) {
            return null;
        }
        boolean bl = isQuoted = reference.charAt(0) == '\'';
        if (!isQuoted) {
            return reference.substring(0, indexOfSheetNameDelimiter);
        }
        int lastQuotePos = indexOfSheetNameDelimiter - 1;
        if (reference.charAt(lastQuotePos) != '\'') {
            throw new RuntimeException("Mismatched quotes: (" + reference + ")");
        }
        StringBuffer sb = new StringBuffer(indexOfSheetNameDelimiter);
        for (int i = 1; i < lastQuotePos; ++i) {
            char ch = reference.charAt(i);
            if (ch != '\'') {
                sb.append(ch);
                continue;
            }
            if (i < lastQuotePos && reference.charAt(i + 1) == '\'') {
                ++i;
                sb.append(ch);
                continue;
            }
            throw new RuntimeException("Bad sheet name quote escaping: (" + reference + ")");
        }
        return sb.toString();
    }

    protected static String convertNumToColString(int col) {
        String retval = null;
        int mod = col % 26;
        int div = col / 26;
        char small = (char)(mod + 65);
        char big = (char)(div + 64);
        retval = div == 0 ? "" + small : "" + big + "" + small;
        return retval;
    }

    public String formatAsString() {
        StringBuffer sb = new StringBuffer(32);
        if (this._sheetName != null) {
            SheetNameFormatter.appendFormat(sb, this._sheetName);
            sb.append('!');
        }
        this.appendCellReference(sb);
        return sb.toString();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(64);
        sb.append(this.getClass().getName()).append(" [");
        sb.append(this.formatAsString());
        sb.append("]");
        return sb.toString();
    }

    void appendCellReference(StringBuffer sb) {
        if (this._isColAbs) {
            sb.append('$');
        }
        sb.append(CellReference.convertNumToColString(this._colIndex));
        if (this._isRowAbs) {
            sb.append('$');
        }
        sb.append(this._rowIndex + 1);
    }
}

