/*
 * Decompiled with CFR 0.152.
 */
package dods.servlet;

import dods.servlet.BadURLException;
import java.util.Enumeration;
import java.util.StringTokenizer;
import javax.servlet.ServletConfig;
import javax.servlet.http.HttpServletRequest;

public class ReqState {
    private String defaultDDScache = "/usr/local/DODS/datasets/dds";
    private String defaultDAScache = "/usr/local/DODS/datasets/das";
    private String defaultINFOcache = "/usr/local/DODS/datasets/info";
    private String dataSetName;
    private String requestSuffix;
    private String CE;
    private boolean acceptsCompressed;
    private Object obj = null;
    private String serverClassName;
    private ServletConfig myServletConfig;
    private HttpServletRequest myHttpRequest;

    public ReqState(String dataSetName, String requestSuffix, String CE, boolean acceptsCompressed, ServletConfig sc, String serverClassName) {
        this.dataSetName = dataSetName;
        this.requestSuffix = requestSuffix;
        this.CE = CE;
        this.acceptsCompressed = acceptsCompressed;
        this.myServletConfig = sc;
        this.serverClassName = serverClassName;
    }

    public ReqState(HttpServletRequest myRequest, ServletConfig sc, String serverClassName) throws BadURLException {
        this.myServletConfig = sc;
        this.myHttpRequest = myRequest;
        this.serverClassName = serverClassName;
        this.CE = this.prepCE(this.myHttpRequest.getQueryString());
        if (this.CE == null) {
            throw new BadURLException();
        }
        this.processDodsURL();
        String servletPath = this.myHttpRequest.getServletPath();
        this.defaultDDScache = this.myServletConfig.getServletContext().getRealPath("datasets" + servletPath + "/dds") + "/";
        this.defaultDAScache = this.myServletConfig.getServletContext().getRealPath("datasets" + servletPath + "/das") + "/";
        this.defaultINFOcache = this.myServletConfig.getServletContext().getRealPath("datasets" + servletPath + "/info") + "/";
    }

    private String prepCE(String ce) {
        if (ce == null) {
            ce = "";
        } else if (!ce.equals("")) {
            int index = ce.indexOf("%");
            if (index == -1) {
                return ce;
            }
            if (index > ce.length() - 3) {
                return null;
            }
            while (index >= 0) {
                String specChar = ce.substring(index + 1, index + 3);
                char val = (char)Byte.parseByte(specChar, 16);
                if ((index = (ce = ce.substring(0, index) + String.valueOf(val) + ce.substring(index + 3, ce.length())).indexOf("%")) <= ce.length() - 3) continue;
                return null;
            }
        }
        return ce;
    }

    private void processDodsURL() {
        this.dataSetName = this.myHttpRequest.getPathInfo();
        this.requestSuffix = null;
        if (this.dataSetName != null) {
            StringTokenizer st = new StringTokenizer(this.dataSetName, "/");
            String endOPath = "";
            while (st.hasMoreTokens()) {
                endOPath = st.nextToken();
            }
            int index = endOPath.lastIndexOf(46);
            if (index >= 0) {
                this.requestSuffix = endOPath.substring(index + 1);
                this.dataSetName = this.dataSetName.substring(1, this.dataSetName.lastIndexOf(46));
            } else {
                this.requestSuffix = "";
                this.dataSetName = this.dataSetName.substring(1, this.dataSetName.length());
            }
        }
    }

    public boolean getAcceptsCompressed() {
        boolean isTiny = false;
        String Encoding = this.myHttpRequest.getHeader("Accept-Encoding");
        isTiny = Encoding != null ? Encoding.equalsIgnoreCase("deflate") : false;
        return isTiny;
    }

    public String getDataSet() {
        return this.dataSetName;
    }

    public String getServerName() {
        return this.serverClassName;
    }

    public String getServerClassName() {
        return this.serverClassName;
    }

    public String getRequestSuffix() {
        return this.requestSuffix;
    }

    public String getConstraintExpression() {
        return this.CE;
    }

    public String getDDSCache() {
        String cacheDir = this.getInitParameter("DDScache");
        if (cacheDir == null) {
            cacheDir = this.defaultDDScache;
        }
        return cacheDir;
    }

    protected void setDefaultDDSCache(String cachedir) {
        this.defaultDDScache = cachedir;
    }

    public String getDASCache() {
        String cacheDir = this.getInitParameter("DAScache");
        if (cacheDir == null) {
            cacheDir = this.defaultDAScache;
        }
        return cacheDir;
    }

    protected void setDefaultDASCache(String cachedir) {
        this.defaultDAScache = cachedir;
    }

    public String getINFOCache() {
        String cacheDir = this.getInitParameter("INFOcache");
        if (cacheDir == null) {
            cacheDir = this.defaultINFOcache;
        }
        return cacheDir;
    }

    protected void setDefaultINFOCache(String cachedir) {
        this.defaultDAScache = cachedir;
    }

    public Enumeration getInitParameterNames() {
        return this.myServletConfig.getInitParameterNames();
    }

    public String getInitParameter(String name) {
        return this.myServletConfig.getInitParameter(name);
    }

    public Object getUserObject() {
        return this.obj;
    }

    public void setUserObject(Object userObj) {
        this.obj = userObj;
    }

    public String toString() {
        String ts = "ReqState:\n";
        ts = ts + "  dataset name: '" + this.dataSetName + "'\n";
        ts = ts + "  suffix: '" + this.requestSuffix + "'\n";
        ts = ts + "  CE: '" + this.CE + "'\n";
        ts = ts + "  compressOK: " + this.acceptsCompressed + "\n";
        ts = ts + "  InitParameters:\n";
        Enumeration e = this.getInitParameterNames();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            String value = this.getInitParameter(name);
            ts = ts + "    " + name + ": '" + value + "'\n";
        }
        return ts;
    }
}

