/*
 * Decompiled with CFR 0.152.
 */
package org.astrogrid.samp.client;

import java.util.logging.Logger;
import org.astrogrid.samp.Platform;
import org.astrogrid.samp.client.ClientProfile;
import org.astrogrid.samp.web.WebClientProfile;
import org.astrogrid.samp.xmlrpc.StandardClientProfile;

public class DefaultClientProfile {
    private static ClientProfile profile_;
    private static final Logger logger_;
    public static final String HUBLOC_ENV = "SAMP_HUB";
    public static final String HUBLOC_CLASS_PREFIX = "jsamp-class:";

    private DefaultClientProfile() {
    }

    public static ClientProfile getProfile() {
        if (profile_ == null) {
            ClientProfile profile;
            String hubloc = Platform.getPlatform().getEnv(HUBLOC_ENV);
            if (hubloc == null || hubloc.trim().length() == 0) {
                profile = StandardClientProfile.getInstance();
            } else {
                if (hubloc.startsWith(HUBLOC_CLASS_PREFIX)) {
                    Class<?> clazz;
                    String cname = hubloc.substring(HUBLOC_CLASS_PREFIX.length());
                    try {
                        clazz = Class.forName(cname);
                    }
                    catch (ClassNotFoundException e) {
                        throw (IllegalArgumentException)new IllegalArgumentException("No profile class " + cname).initCause(e);
                    }
                    try {
                        profile = (ClientProfile)clazz.newInstance();
                        logger_.info("Using non-standard hub location: SAMP_HUB=" + hubloc);
                    }
                    catch (Throwable e) {
                        throw (RuntimeException)new RuntimeException("Error instantiating custom profile " + clazz.getName()).initCause(e);
                    }
                }
                if (hubloc.startsWith("std-lockurl:")) {
                    profile = StandardClientProfile.getInstance();
                } else if (hubloc.startsWith("web-appname:")) {
                    profile = WebClientProfile.getInstance();
                } else {
                    throw new RuntimeException("Can't make sense of SAMP_HUB=" + hubloc);
                }
            }
            profile_ = profile;
        }
        return profile_;
    }

    public static void setProfile(ClientProfile profile) {
        profile_ = profile;
    }

    static {
        logger_ = Logger.getLogger(DefaultClientProfile.class.getName());
    }
}

