/*
 * Decompiled with CFR 0.152.
 */
package org.eso.fits;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import org.eso.fits.FitsException;
import org.eso.fits.FitsTform;

public class FitsColumn {
    private String stringNull = null;
    private long intNull;
    private boolean intNullDefined = false;
    private int repeat = 1;
    private char dataType = '\u0000';
    private long columnOffset = 0L;
    private int recordSize = 0;
    private FitsTform format;
    private int bytesPerData = 0;
    private long noRows = 0L;
    private boolean binColumn = true;
    private String display;
    private String label;
    private String unit;
    private double zero;
    private double scale;
    private boolean scaling = false;
    private RandomAccessFile dataFile = null;
    private long dataOffset = 0L;
    private boolean isRAFile = true;
    private byte[] dataArray = null;

    public FitsColumn(int n, String string, String string2, int n2) throws FitsException {
        this.format = new FitsTform(string);
        this.dataType = this.format.getDataType();
        this.repeat = this.format.getRepeat();
        this.bytesPerData = this.format.getWidth();
        this.label = string2;
        this.noRows = n2;
        this.binColumn = n == 2;
    }

    public void setData(RandomAccessFile randomAccessFile, long l, int n, int n2) {
        this.dataFile = randomAccessFile;
        this.dataOffset = l;
        this.isRAFile = true;
        this.columnOffset = n;
        this.recordSize = n2;
    }

    public void setData(byte[] byArray, int n, int n2) {
        this.dataArray = byArray;
        this.isRAFile = false;
        this.columnOffset = n;
        this.recordSize = n2;
    }

    public int getInt(int n) {
        int n2 = Integer.MIN_VALUE;
        byte[] byArray = this.getBytes(n);
        try {
            if (this.binColumn) {
                DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(byArray));
                switch (this.dataType) {
                    case 'I': {
                        n2 = dataInputStream.readShort();
                        break;
                    }
                    case 'J': {
                        n2 = dataInputStream.readInt();
                    }
                }
                if (this.intNullDefined && (long)n2 == this.intNull) {
                    n2 = Integer.MIN_VALUE;
                } else if (this.scaling) {
                    n2 = (int)(this.zero + this.scale * (double)n2);
                }
            } else {
                String string = new String(byArray);
                if (this.stringNull == null || !string.startsWith(this.stringNull)) {
                    n2 = Integer.valueOf(string);
                    if (this.scaling) {
                        n2 = (int)(this.zero + this.scale * (double)n2);
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return n2;
    }

    public int[] getInts(int n) {
        int[] nArray = new int[this.repeat];
        byte[] byArray = this.getBytes(n);
        try {
            if (this.binColumn) {
                DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(byArray));
                for (int i = 0; i < this.repeat; ++i) {
                    int n2 = Integer.MIN_VALUE;
                    switch (this.dataType) {
                        case 'I': {
                            n2 = dataInputStream.readShort();
                            break;
                        }
                        case 'J': {
                            n2 = dataInputStream.readInt();
                        }
                    }
                    if (this.intNullDefined && (long)n2 == this.intNull) {
                        n2 = Integer.MIN_VALUE;
                    } else if (this.scaling) {
                        n2 = (int)(this.zero + this.scale * (double)n2);
                    }
                    nArray[i] = n2;
                }
            } else {
                String string = new String(byArray);
                nArray[0] = Integer.MIN_VALUE;
                if (this.stringNull == null || !string.startsWith(this.stringNull)) {
                    nArray[0] = Integer.valueOf(string);
                    if (this.scaling) {
                        nArray[0] = (int)(this.zero + this.scale * (double)nArray[0]);
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return nArray;
    }

    public double getReal(int n) {
        double d = Double.NaN;
        byte[] byArray = this.getBytes(n);
        try {
            if (this.binColumn) {
                DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(byArray));
                switch (this.dataType) {
                    case 'I': {
                        d = dataInputStream.readShort();
                        break;
                    }
                    case 'J': {
                        d = dataInputStream.readInt();
                        break;
                    }
                    case 'E': {
                        d = dataInputStream.readFloat();
                        break;
                    }
                    case 'D': {
                        d = dataInputStream.readDouble();
                    }
                }
                if (this.scaling) {
                    d = this.zero + this.scale * d;
                }
            } else {
                String string = new String(byArray);
                if (this.stringNull == null || !string.startsWith(this.stringNull)) {
                    d = Double.valueOf(string);
                    if (this.scaling) {
                        d = this.zero + this.scale * d;
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return d;
    }

    public double[] getReals(int n) {
        double[] dArray = new double[this.repeat];
        byte[] byArray = this.getBytes(n);
        try {
            if (this.binColumn) {
                DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(byArray));
                for (int i = 0; i < this.repeat; ++i) {
                    switch (this.dataType) {
                        case 'I': {
                            dArray[i] = dataInputStream.readShort();
                            break;
                        }
                        case 'J': {
                            dArray[i] = dataInputStream.readInt();
                            break;
                        }
                        case 'E': {
                            dArray[i] = dataInputStream.readFloat();
                            break;
                        }
                        case 'D': {
                            dArray[i] = dataInputStream.readDouble();
                        }
                    }
                    if (!this.scaling) continue;
                    dArray[i] = this.zero + this.scale * dArray[i];
                }
            } else {
                double d = Double.NaN;
                String string = new String(byArray);
                if (this.stringNull == null || !string.startsWith(this.stringNull)) {
                    dArray[0] = Double.valueOf(string);
                    if (this.scaling) {
                        dArray[0] = this.zero + this.scale * dArray[0];
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return dArray;
    }

    public String getString(int n) {
        byte[] byArray;
        String string = null;
        if (!(this.dataType != 'A' && this.dataType != 'L' || (byArray = this.getBytes(n)) == null || this.stringNull != null && string.startsWith(this.stringNull))) {
            string = new String(byArray);
        }
        return string;
    }

    private byte[] getBytes(int n) {
        if (n < 0 || this.noRows <= (long)n) {
            return null;
        }
        byte[] byArray = new byte[this.getWidth()];
        if (this.isRAFile) {
            try {
                if (this.dataFile == null) {
                    return null;
                }
                this.dataFile.seek(this.dataOffset + this.columnOffset + (long)(n * this.recordSize));
                this.dataFile.read(byArray);
            }
            catch (IOException iOException) {
                return null;
            }
        } else {
            if (this.dataArray == null) {
                return null;
            }
            int n2 = 0;
            int n3 = (int)(this.columnOffset + (long)(n * this.recordSize));
            int n4 = this.getWidth();
            while (0 < n4--) {
                byArray[n2++] = this.dataArray[n3++];
            }
        }
        return byArray;
    }

    public void setNull(String string) {
        this.stringNull = string;
    }

    public void setNull(int n) {
        this.intNull = n;
        this.intNullDefined = true;
    }

    public void setDim(String string) {
    }

    public int getRepeat() {
        return this.repeat;
    }

    public char getDataType() {
        return this.dataType;
    }

    protected int getWidth() {
        return this.repeat * this.bytesPerData;
    }

    public String getDisplay() {
        return this.display;
    }

    public void setDisplay(String string) {
        this.display = string;
    }

    public String getUnit() {
        return this.unit;
    }

    public void setUnit(String string) {
        this.unit = string;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String string) {
        this.label = string;
    }

    public double getZero() {
        return this.zero;
    }

    public void setZero(double d) {
        this.zero = d;
        this.scaling = true;
    }

    public double getScale() {
        return this.scale;
    }

    public void setScale(double d) {
        this.scale = d;
        this.scaling = true;
    }
}

