/*
 * Decompiled with CFR 0.152.
 */
package org.eso.fits;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.RandomAccessFile;
import org.eso.fits.FitsData;
import org.eso.fits.FitsException;
import org.eso.fits.FitsHeader;
import org.eso.fits.FitsMatrix;
import org.eso.fits.FitsRGroup;
import org.eso.fits.FitsTable;

public class FitsHDUnit {
    private FitsHeader header;
    private FitsData data;
    private boolean changeHeader = false;
    private long headerOffset = 0L;
    private RandomAccessFile headerFile = null;

    public FitsHDUnit(DataInput dataInput, boolean bl) throws FitsException {
        if (dataInput instanceof RandomAccessFile) {
            this.headerFile = (RandomAccessFile)dataInput;
            try {
                this.headerOffset = this.headerFile.getFilePointer();
            }
            catch (IOException iOException) {
                throw new FitsException("Cannot read header offset", 1);
            }
        }
        this.header = new FitsHeader(dataInput);
        int n = this.header.getType();
        switch (n) {
            case 1: {
                this.data = new FitsMatrix(this.header, dataInput, bl);
                break;
            }
            case 2: 
            case 3: {
                this.data = new FitsTable(this.header, dataInput, bl);
                break;
            }
            case 4: {
                this.data = new FitsRGroup(this.header, dataInput, bl);
            }
        }
        this.changeHeader = false;
    }

    public FitsHDUnit(FitsHeader fitsHeader, FitsData fitsData) throws FitsException {
        this.header = fitsHeader;
        this.data = fitsData;
        this.changeHeader = true;
    }

    public int getType() {
        return this.header.getType();
    }

    public boolean canSave() {
        if (this.changeHeader || this.headerFile == null) {
            return false;
        }
        int n = this.header.getHeaderSpace() - this.header.getNoKeywords() - 1;
        return n >= 0;
    }

    protected void saveFile(RandomAccessFile randomAccessFile) throws IOException, FitsException {
        if (this.changeHeader) {
            throw new FitsException("HD unit modified", 1);
        }
        if (this.headerFile == null) {
            throw new FitsException("No header file", 1);
        }
        int n = this.header.getHeaderSpace() - this.header.getNoKeywords() - 1;
        if (n < 0) {
            throw new FitsException("No space in FITS header", 6);
        }
        randomAccessFile.seek(this.headerOffset);
        randomAccessFile.write(this.header.toString().getBytes());
        while (0 < n--) {
            randomAccessFile.write("                                                                                ".getBytes());
        }
        randomAccessFile.write("END                                                                             ".getBytes());
    }

    public void writeFile(DataOutput dataOutput) throws IOException, FitsException {
        int n = this.header.getNoKeywords();
        if (n < 2) {
            throw new FitsException("Bad FITS header", 4);
        }
        dataOutput.write(this.header.toString().getBytes());
        int n2 = 36 * (n / 36 + 1) - n - 1;
        while (0 < n2--) {
            dataOutput.write("                                                                                ".getBytes());
        }
        dataOutput.write("END                                                                             ".getBytes());
        this.data.writeFile(dataOutput);
    }

    public void closeFile() {
        this.headerFile = null;
        this.data.closeFile();
    }

    public FitsData getData() {
        return this.data;
    }

    public FitsHeader getHeader() {
        return this.header;
    }
}

