/*
 * Decompiled with CFR 0.152.
 */
package proguard.io;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import proguard.classfile.ClassPool;
import proguard.classfile.Clazz;
import proguard.io.DataEntry;
import proguard.io.DataEntryReader;
import proguard.io.DataEntryWriter;

public class DataEntryRewriter
implements DataEntryReader {
    private final ClassPool classPool;
    private final DataEntryWriter dataEntryWriter;

    public DataEntryRewriter(ClassPool classPool, DataEntryWriter dataEntryWriter) {
        this.classPool = classPool;
        this.dataEntryWriter = dataEntryWriter;
    }

    @Override
    public void read(DataEntry dataEntry) throws IOException {
        try {
            OutputStream outputStream = this.dataEntryWriter.getOutputStream(dataEntry);
            if (outputStream != null) {
                InputStream inputStream = dataEntry.getInputStream();
                this.copyData(inputStream, outputStream);
                dataEntry.closeInputStream();
            }
        }
        catch (IOException iOException) {
            System.err.println("Warning: can't write resource [" + dataEntry.getName() + "] (" + iOException.getMessage() + ")");
        }
    }

    private void copyData(InputStream inputStream, OutputStream outputStream) throws IOException {
        int n;
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(outputStream));
        StringBuffer stringBuffer = new StringBuffer();
        while ((n = ((Reader)bufferedReader).read()) >= 0) {
            char c = (char)n;
            if (Character.isJavaIdentifierPart(c) || c == '.' || c == '-') {
                stringBuffer.append(c);
                continue;
            }
            this.writeUpdatedWord(bufferedWriter, stringBuffer.toString());
            stringBuffer.setLength(0);
            ((Writer)bufferedWriter).write(c);
        }
        this.writeUpdatedWord(bufferedWriter, stringBuffer.toString());
        ((Writer)bufferedWriter).flush();
        outputStream.flush();
    }

    private void writeUpdatedWord(Writer writer, String string) throws IOException {
        if (string.length() > 0) {
            String string2;
            String string3 = string;
            boolean bl = string.indexOf(46) >= 0;
            String string4 = bl ? string.replace('.', '/') : string;
            Clazz clazz = this.classPool.getClass(string4);
            if (clazz != null && !string4.equals(string2 = clazz.getName())) {
                string3 = bl ? string2.replace('/', '.') : string2;
            }
            writer.write(string3);
        }
    }
}

