/*
 * Decompiled with CFR 0.152.
 */
package proguard.retrace;

import java.io.File;
import java.io.IOException;
import proguard.obfuscate.MappingReader;
import proguard.retrace.StackTrace;

public class ReTrace {
    private static final String VERBOSE_OPTION = "-verbose";
    private final boolean verbose;
    private final File mappingFile;
    private final File stackTraceFile;

    public ReTrace(boolean bl, File file) {
        this(bl, file, null);
    }

    public ReTrace(boolean bl, File file, File file2) {
        this.verbose = bl;
        this.mappingFile = file;
        this.stackTraceFile = file2;
    }

    public void execute() throws IOException {
        StackTrace stackTrace = new StackTrace(this.verbose);
        MappingReader mappingReader = new MappingReader(this.mappingFile);
        stackTrace.read(this.stackTraceFile);
        mappingReader.pump(stackTrace);
        stackTrace.print();
    }

    public static void main(String[] stringArray) {
        if (stringArray.length < 1) {
            System.err.println("Usage: java proguard.ReTrace [-verbose] <mapping_file> [<stacktrace_file>]");
            System.exit(-1);
        }
        int n = 0;
        boolean bl = false;
        if (stringArray[n].equals(VERBOSE_OPTION)) {
            bl = true;
            ++n;
            if (stringArray.length < 2) {
                System.err.println("Usage: java proguard.ReTrace [-verbose] <mapping_file> [<stacktrace_file>]");
                System.exit(-1);
            }
        }
        File file = new File(stringArray[n++]);
        File file2 = n < stringArray.length ? new File(stringArray[n]) : null;
        ReTrace reTrace = new ReTrace(bl, file, file2);
        try {
            reTrace.execute();
        }
        catch (IOException iOException) {
            if (bl) {
                iOException.printStackTrace();
            } else {
                System.err.println("Error: " + iOException.getMessage());
            }
            System.exit(1);
        }
        System.exit(0);
    }
}

