/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.asdatasource;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.util.Iterator;
import java.util.NoSuchElementException;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.TargetDataLine;
import org.autoplot.datasource.AbstractDataSource;
import org.autoplot.datasource.capability.Streaming;
import org.autoplot.datasource.capability.Updating;
import org.das2.datum.Units;
import org.das2.qds.MutablePropertyDataSet;
import org.das2.qds.QDataSet;
import org.das2.qds.TagGenDataSet;
import org.das2.qds.buffer.BufferDataSet;
import org.das2.qds.ops.Ops;
import org.das2.util.monitor.NullProgressMonitor;
import org.das2.util.monitor.ProgressMonitor;

public final class AudioSystemDataSource
extends AbstractDataSource
implements Updating {
    ByteBuffer dataBuffer;
    ReadableByteChannel audioChannel;
    int nsamples;
    int spec = -1;
    PropertyChangeSupport pcs = new PropertyChangeSupport((Object)this);

    public AudioSystemDataSource(URI uri) {
        super(uri);
        String sspec = (String)this.getParams().get("spec");
        if (sspec != null) {
            this.spec = Integer.parseInt(sspec);
        }
        this.addCapability(Updating.class, (Object)this);
        if (this.spec == -1) {
            this.addCapability(Streaming.class, new AudioSystemStreamingSource());
        }
    }

    public QDataSet getDataSet(ProgressMonitor mon) throws Exception {
        BufferDataSet ds;
        double lenSeconds = Double.parseDouble(this.getParam("len", "1.0"));
        int sampleRate = Integer.parseInt(this.getParam("rate", "8000"));
        this.nsamples = (int)(lenSeconds * (double)sampleRate);
        int len = this.nsamples * 2;
        int nchannels = Integer.parseInt(this.getParam("channels", "1"));
        if (nchannels < 1 || nchannels > 8) {
            throw new IllegalArgumentException("channels must be between 1 and 8");
        }
        int bitsPerSample = 16;
        int frameSize = nchannels * bitsPerSample / 8;
        this.dataBuffer = ByteBuffer.allocateDirect(this.nsamples * frameSize);
        AudioFormat audioFormat = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, sampleRate, bitsPerSample, nchannels, frameSize, sampleRate, false);
        DataLine.Info info = new DataLine.Info(TargetDataLine.class, audioFormat);
        TargetDataLine targetDataLine = (TargetDataLine)AudioSystem.getLine(info);
        targetDataLine.open(audioFormat);
        AudioInputStream audioInputStream = new AudioInputStream(targetDataLine);
        targetDataLine.start();
        this.audioChannel = Channels.newChannel(audioInputStream);
        mon.setTaskSize((long)len);
        mon.started();
        mon.setProgressMessage("recording from system audio");
        this.dataBuffer.limit(2048);
        this.fillBuffer(mon);
        targetDataLine.close();
        this.dataBuffer.order(ByteOrder.LITTLE_ENDIAN);
        TagGenDataSet t = new TagGenDataSet(this.nsamples, 1.0 / (double)sampleRate, 0.0, Units.seconds);
        t.putProperty("LABEL", (Object)"Seconds Offset");
        if (nchannels > 1) {
            ds = BufferDataSet.makeDataSet((int)2, (int)(2 * nchannels), (int)0, (int)this.nsamples, (int)nchannels, (int)1, (int)1, (ByteBuffer)this.dataBuffer, (Object)BufferDataSet.SHORT);
            String[] cc = new String[nchannels];
            for (int i = 0; i < nchannels; ++i) {
                cc[i] = "ch_" + String.valueOf(i);
            }
            ds.putProperty("DEPEND_1", (Object)Ops.labelsDataset((String[])cc));
        } else {
            ds = BufferDataSet.makeDataSet((int)1, (int)2, (int)0, (int)this.nsamples, (int)1, (int)1, (int)1, (ByteBuffer)this.dataBuffer, (Object)BufferDataSet.SHORT);
        }
        ds.putProperty("DEPEND_0", (Object)t);
        if (this.spec > -1) {
            ds = (MutablePropertyDataSet)Ops.fftPower((QDataSet)ds, (int)this.spec, (ProgressMonitor)mon.getSubtaskMonitor("fftPower"));
        }
        mon.finished();
        return ds;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(listener);
    }

    private void fillBuffer(ProgressMonitor mon) throws IllegalArgumentException, IOException {
        while (!mon.isCancelled() && this.dataBuffer.position() < this.dataBuffer.capacity()) {
            this.audioChannel.read(this.dataBuffer);
            this.dataBuffer.limit(Math.min(this.dataBuffer.position() + 2048, this.dataBuffer.capacity()));
            mon.setTaskProgress((long)this.dataBuffer.position());
        }
    }

    class AudioSystemStreamingSource
    implements Streaming {
        AudioSystemStreamingSource() {
        }

        public Iterator<QDataSet> streamDataSet(final ProgressMonitor mon) throws Exception {
            AudioSystemDataSource.this.nsamples = 2048;
            final int nchannels = Integer.parseInt(AudioSystemDataSource.this.getParam("channels", "1"));
            int bitsPerSample = 16;
            int frameSizeBytes = nchannels * bitsPerSample / 8;
            AudioSystemDataSource.this.dataBuffer = ByteBuffer.allocateDirect(AudioSystemDataSource.this.nsamples * frameSizeBytes);
            final int sampleRate = Integer.parseInt(AudioSystemDataSource.this.getParam("rate", "8000"));
            AudioFormat audioFormat = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, sampleRate, bitsPerSample, nchannels, frameSizeBytes, sampleRate, false);
            DataLine.Info info = new DataLine.Info(TargetDataLine.class, audioFormat);
            TargetDataLine targetDataLine = (TargetDataLine)AudioSystem.getLine(info);
            targetDataLine.open(audioFormat);
            AudioInputStream audioInputStream = new AudioInputStream(targetDataLine);
            targetDataLine.start();
            AudioSystemDataSource.this.audioChannel = Channels.newChannel(audioInputStream);
            mon.setTaskSize(-1L);
            mon.started();
            mon.setProgressMessage("recording from system audio");
            return new Iterator<QDataSet>(){
                int length = 0;
                QDataSet result;

                @Override
                public boolean hasNext() {
                    try {
                        BufferDataSet ds;
                        if (mon.isCancelled()) {
                            return false;
                        }
                        AudioSystemDataSource.this.dataBuffer.limit(AudioSystemDataSource.this.nsamples * 2);
                        AudioSystemDataSource.this.fillBuffer((ProgressMonitor)new NullProgressMonitor());
                        AudioSystemDataSource.this.dataBuffer.order(ByteOrder.LITTLE_ENDIAN);
                        TagGenDataSet t = new TagGenDataSet(AudioSystemDataSource.this.nsamples, 1.0 / (double)sampleRate, 0.0, Units.seconds);
                        t.putProperty("LABEL", (Object)"Seconds Offset");
                        if (nchannels > 1) {
                            ds = BufferDataSet.makeDataSet((int)2, (int)(2 * nchannels), (int)0, (int)AudioSystemDataSource.this.nsamples, (int)nchannels, (int)1, (int)1, (ByteBuffer)AudioSystemDataSource.this.dataBuffer, (Object)BufferDataSet.SHORT);
                            String[] cc = new String[nchannels];
                            for (int i = 0; i < nchannels; ++i) {
                                cc[i] = "ch_" + String.valueOf(i);
                            }
                            ds.putProperty("DEPEND_1", (Object)Ops.labelsDataset((String[])cc));
                        } else {
                            ds = BufferDataSet.makeDataSet((int)1, (int)2, (int)0, (int)AudioSystemDataSource.this.nsamples, (int)1, (int)1, (int)1, (ByteBuffer)AudioSystemDataSource.this.dataBuffer, (Object)BufferDataSet.SHORT);
                        }
                        ds.putProperty("DEPEND_0", (Object)t);
                        this.result = BufferDataSet.copy((QDataSet)ds);
                        AudioSystemDataSource.this.dataBuffer.flip();
                        this.length += ds.length();
                        return true;
                    }
                    catch (IOException | IllegalArgumentException ex) {
                        return false;
                    }
                }

                @Override
                public QDataSet next() {
                    if (this.result == null) {
                        throw new NoSuchElementException();
                    }
                    QDataSet r = this.result;
                    this.result = null;
                    return r;
                }

                @Override
                public void remove() {
                }
            };
        }
    }
}

