/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.asdatasource;

import java.awt.Window;
import java.util.LinkedHashMap;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import org.autoplot.datasource.DataSourceEditorPanel;
import org.autoplot.datasource.URISplit;
import org.das2.util.monitor.ProgressMonitor;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.Binding;
import org.jdesktop.beansbinding.BindingGroup;
import org.jdesktop.beansbinding.Bindings;
import org.jdesktop.beansbinding.ELProperty;
import org.jdesktop.beansbinding.Property;

public class AudioSystemDataSourceEditorPanel
extends JPanel
implements DataSourceEditorPanel {
    private JCheckBox fftCB;
    private JComboBox fftLenComboBox;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JFormattedTextField lenTF;
    private JComboBox<String> samplingRateCB;
    private BindingGroup bindingGroup;

    public AudioSystemDataSourceEditorPanel() {
        this.initComponents();
    }

    private void initComponents() {
        this.bindingGroup = new BindingGroup();
        this.jLabel1 = new JLabel();
        this.lenTF = new JFormattedTextField();
        this.fftCB = new JCheckBox();
        this.fftLenComboBox = new JComboBox();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.samplingRateCB = new JComboBox();
        this.jLabel4 = new JLabel();
        this.jLabel1.setText("Sample Length, Seconds:");
        this.lenTF.setText("1.0");
        this.fftCB.setText("Perform FFT");
        this.fftLenComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"128", "256", "512", "1024"}));
        AutoBinding binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.fftCB, (Property)ELProperty.create((String)"${selected}"), (Object)this.fftLenComboBox, (Property)BeanProperty.create((String)"enabled"));
        this.bindingGroup.addBinding((Binding)binding);
        this.jLabel2.setText("FFT Length:");
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.fftCB, (Property)ELProperty.create((String)"${selected}"), (Object)this.jLabel2, (Property)BeanProperty.create((String)"enabled"));
        this.bindingGroup.addBinding((Binding)binding);
        this.jLabel3.setText("Sampling Rate (1/Seconds):");
        this.samplingRateCB.setEditable(true);
        this.samplingRateCB.setModel(new DefaultComboBoxModel<String>(new String[]{"8000", "16000", "32000", "64000"}));
        this.jLabel4.setFont(this.jLabel4.getFont().deriveFont((float)this.jLabel4.getFont().getSize() + 2.0f));
        this.jLabel4.setText("<html>A computer's audio system often provides a nice source for data.");
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(layout.createSequentialGroup().addGap(12, 12, 12).addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.fftLenComboBox, -2, -1, -2)).addGroup(layout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lenTF, -2, 75, -2)).addComponent(this.fftCB).addGroup(layout.createSequentialGroup().addComponent(this.jLabel3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.samplingRateCB, -2, -1, -2)).addComponent(this.jLabel4, -2, 0, Short.MAX_VALUE)).addContainerGap(-1, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jLabel4, -2, 46, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.lenTF, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.fftCB).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.fftLenComboBox, -2, -1, -2).addComponent(this.jLabel2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent(this.samplingRateCB, -2, -1, -2)).addContainerGap(123, Short.MAX_VALUE)));
        this.bindingGroup.bind();
    }

    public boolean reject(String uri) throws Exception {
        boolean allowDiscovery = false;
        return allowDiscovery;
    }

    public boolean prepare(String uri, Window parent, ProgressMonitor mon) throws Exception {
        return true;
    }

    public void setURI(String uri) {
        String s;
        URISplit split = URISplit.parse((String)uri);
        LinkedHashMap params = URISplit.parseParams((String)split.params);
        String len = (String)params.get("len");
        if (len != null) {
            this.lenTF.setValue(Float.valueOf(Float.parseFloat(len)));
        } else {
            this.lenTF.setValue(Float.valueOf(1.0f));
        }
        String fft = (String)params.get("spec");
        this.fftCB.setSelected(fft != null);
        if (fft != null) {
            this.fftLenComboBox.setSelectedItem(fft);
        }
        if ((s = (String)params.get("rate")) != null) {
            this.samplingRateCB.setSelectedItem(s);
        }
    }

    public void markProblems(List<String> problems) {
    }

    public JPanel getPanel() {
        return this;
    }

    public String getURI() {
        String result = "vap+audiosystem:len=" + this.lenTF.getValue();
        if (this.fftCB.isSelected()) {
            result = result + "&spec=" + this.fftLenComboBox.getSelectedItem();
        }
        if (!this.samplingRateCB.getSelectedItem().equals("8000")) {
            result = result + "&rate=" + this.samplingRateCB.getSelectedItem();
        }
        return result;
    }
}

