/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.asdatasource;

import java.util.LinkedHashMap;
import org.autoplot.datasource.DataSourceFormat;
import org.autoplot.datasource.URISplit;
import org.das2.graph.Auralizor;
import org.das2.qds.QDataSet;
import org.das2.qds.SemanticOps;
import org.das2.qds.ops.Ops;
import org.das2.util.monitor.ProgressMonitor;

public class AudioSystemDataSourceFormat
implements DataSourceFormat {
    public void formatData(String uri, QDataSet data, ProgressMonitor mon) throws Exception {
        if (data == null) {
            throw new IllegalArgumentException("data is null");
        }
        if (SemanticOps.isRank2Waveform((QDataSet)data)) {
            data = Ops.flattenWaveform((QDataSet)data);
        }
        Auralizor auralizor = new Auralizor(data);
        URISplit split = URISplit.parse((String)uri);
        LinkedHashMap params = URISplit.parseParams((String)split.params);
        boolean doscale = !"F".equals(params.get("scale"));
        auralizor.setScale(doscale);
        auralizor.playSound();
    }

    public boolean canFormat(QDataSet ds) {
        return ds.rank() == 1 || SemanticOps.isRank2Waveform((QDataSet)ds);
    }

    public String getDescription() {
        return "stream data to audio system";
    }
}

