/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.asdatasource;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import org.autoplot.asdatasource.AudioSystemDataSource;
import org.autoplot.datasource.AbstractDataSourceFactory;
import org.autoplot.datasource.CompletionContext;
import org.autoplot.datasource.DataSource;
import org.autoplot.datasource.URISplit;
import org.das2.util.monitor.ProgressMonitor;

public class AudioSystemDataSourceFactory
extends AbstractDataSourceFactory {
    public DataSource getDataSource(URI uri) throws Exception {
        return new AudioSystemDataSource(uri);
    }

    public boolean reject(String surl, List<String> problems, ProgressMonitor mon) {
        URISplit split = URISplit.parse((String)surl);
        LinkedHashMap params = URISplit.parseParams((String)split.params);
        if (params.get("len") == null) {
            return true;
        }
        return super.reject(surl, problems, mon);
    }

    public List<CompletionContext> getCompletions(CompletionContext cc, ProgressMonitor mon) throws Exception {
        if (cc.context == CompletionContext.CONTEXT_PARAMETER_NAME) {
            ArrayList<CompletionContext> result = new ArrayList<CompletionContext>();
            result.add(new CompletionContext(CompletionContext.CONTEXT_PARAMETER_NAME, "len=", "sample length in seconds"));
            result.add(new CompletionContext(CompletionContext.CONTEXT_PARAMETER_NAME, "spec=", "make spectrogram using FFT"));
            result.add(new CompletionContext(CompletionContext.CONTEXT_PARAMETER_NAME, "rate=", "sampling rate in samples per second"));
            return result;
        }
        if (cc.context == CompletionContext.CONTEXT_PARAMETER_VALUE) {
            String paramName = CompletionContext.get((Object)CompletionContext.CONTEXT_PARAMETER_NAME, (CompletionContext)cc);
            if (paramName.equals("spec")) {
                ArrayList<CompletionContext> result = new ArrayList<CompletionContext>();
                result.add(new CompletionContext(CompletionContext.CONTEXT_PARAMETER_VALUE, "128"));
                result.add(new CompletionContext(CompletionContext.CONTEXT_PARAMETER_VALUE, "256"));
                result.add(new CompletionContext(CompletionContext.CONTEXT_PARAMETER_VALUE, "512"));
                result.add(new CompletionContext(CompletionContext.CONTEXT_PARAMETER_VALUE, "1024"));
                result.add(new CompletionContext(CompletionContext.CONTEXT_PARAMETER_VALUE, "2048"));
                return result;
            }
            if (paramName.equals("len")) {
                ArrayList<CompletionContext> result = new ArrayList<CompletionContext>();
                result.add(new CompletionContext(CompletionContext.CONTEXT_PARAMETER_VALUE, "1.0"));
                return result;
            }
            if (paramName.equals("rate")) {
                ArrayList<CompletionContext> result = new ArrayList<CompletionContext>();
                result.add(new CompletionContext(CompletionContext.CONTEXT_PARAMETER_VALUE, "8000"));
                result.add(new CompletionContext(CompletionContext.CONTEXT_PARAMETER_VALUE, "16000"));
                result.add(new CompletionContext(CompletionContext.CONTEXT_PARAMETER_VALUE, "32000"));
                result.add(new CompletionContext(CompletionContext.CONTEXT_PARAMETER_VALUE, "64000"));
                return result;
            }
            return Collections.emptyList();
        }
        return Collections.emptyList();
    }

    public boolean isFileResource() {
        return false;
    }
}

