/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.bookmarks;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.GZIPInputStream;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.autoplot.bookmarks.BookmarksException;
import org.autoplot.bookmarks.MalformedRemoteBookmarksException;
import org.autoplot.bookmarks.RemoteStatus;
import org.autoplot.datasource.DataSetURI;
import org.autoplot.datasource.DataSourceUtil;
import org.das2.util.Base64;
import org.das2.util.LoggerManager;
import org.das2.util.monitor.NullProgressMonitor;
import org.das2.util.monitor.ProgressMonitor;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSOutput;
import org.w3c.dom.ls.LSSerializer;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public abstract class Bookmark {
    public static final String TITLE_ERROR_OCCURRED = "Error Occurred";
    public static final String MSG_NO_REMOTE = "[remote*]";
    public static final String TOOLTIP_NO_REMOTE = "Using cached version because <br>remote folder based on contents of remote URL <br>%{URL}<br>which is not available. ";
    public static final String MSG_REMOTE = "";
    public static final String TOOLTIP_REMOTE = "Bookmark folder based on contents of remote URL <br>%{URL}";
    public static final String MSG_NOT_LOADED = "[loading...]";
    public static final String TOOLTIP_NOT_LOADED = "Checking to see if remote bookmark list has changed.<br>%{URL}";
    public static final int REMOTE_BOOKMARK_DEPTH_LIMIT = 5;
    private static final Logger logger = LoggerManager.getLogger((String)"autoplot.bookmarks");
    private static int seq = 0;
    private String title = "";
    protected PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    String id = "";
    protected String description = "";
    protected URL descriptionUrl = null;
    protected ImageIcon icon = null;
    public static final String PROP_ICON = "icon";
    private boolean hidden = false;
    public static final String PROP_PARENT = "parent";
    private Folder parent = null;

    public static List<Bookmark> parseBookmarks(String data) throws IOException, SAXException, BookmarksException {
        return Bookmark.parseBookmarks(data, 0);
    }

    public static List<Bookmark> parseBookmarks(String data, int depth) throws IOException, SAXException, BookmarksException {
        try {
            BufferedReader in = new BufferedReader(new StringReader(data));
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            InputSource source = new InputSource(in);
            Document document = builder.parse(source);
            List<Bookmark> books = Bookmark.parseBookmarks(document.getDocumentElement(), depth);
            return books;
        }
        catch (ParserConfigurationException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static List<Bookmark> parseBookmarks(URL url) throws IOException, SAXException, BookmarksException {
        try {
            File file = DataSetURI.downloadResourceAsTempFile((URL)url, (ProgressMonitor)new NullProgressMonitor());
            BufferedReader in = new BufferedReader(new FileReader(file));
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            InputSource source = new InputSource(in);
            Document document = builder.parse(source);
            return Bookmark.parseBookmarks(document.getDocumentElement());
        }
        catch (ParserConfigurationException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static Bookmark parseBookmark(String data) throws IOException, SAXException, BookmarksException {
        try {
            BufferedReader in = new BufferedReader(new StringReader(data));
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            InputSource source = new InputSource(in);
            Document document = builder.parse(source);
            String vers = document.getDocumentElement().getAttribute("version");
            return Bookmark.parseBookmark(document.getDocumentElement(), vers, 1);
        }
        catch (ParserConfigurationException ex) {
            throw new RuntimeException(ex);
        }
    }

    private static boolean checkForUnresolved(List<Bookmark> contents) {
        for (Bookmark book : contents) {
            if (!(book instanceof Folder)) continue;
            Folder bf = (Folder)book;
            if (bf.remoteStatus == -1) {
                return true;
            }
            if (!Bookmark.checkForUnresolved(bf.getBookmarks())) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static RemoteStatus getRemoteBookmarks(String remoteUrl, int remoteLevel, boolean startAtRoot, List<Bookmark> contents) throws MalformedRemoteBookmarksException {
        InputStream in = null;
        boolean remoteRemote = false;
        boolean offline = false;
        RemoteStatus result = new RemoteStatus();
        logger.log(Level.FINE, "getRemoteBookmarks({0},...)", remoteUrl);
        logger.log(Level.FINEST, "  remoteLevel={0}  startAtRoot={1}", new Object[]{remoteLevel, startAtRoot});
        try {
            String remoteUrl2;
            URL rurl = new URL(remoteUrl);
            logger.log(Level.FINE, "Using downloadResourceAsTempFile route.  Files are cached for up to 3600 seconds");
            in = new FileInputStream(DataSetURI.downloadResourceAsTempFile((URL)rurl, (int)3600, (ProgressMonitor)new NullProgressMonitor()));
            if (remoteUrl.endsWith(".gz")) {
                logger.fine("bookmarks stream is uncompressed because of .gz");
                in = new GZIPInputStream(in);
            }
            logger.fine("  got it...");
            ByteArrayOutputStream boas = new ByteArrayOutputStream();
            WritableByteChannel dest = Channels.newChannel(boas);
            ReadableByteChannel src = Channels.newChannel(in);
            DataSourceUtil.transfer((ReadableByteChannel)src, (WritableByteChannel)dest);
            in.close();
            in = null;
            String sin = new String(boas.toByteArray());
            if (!sin.startsWith("<book") && !sin.startsWith("<?xml")) {
                logger.log(Level.WARNING, "not a bookmark xml file: {0}", rurl);
                throw new IllegalArgumentException("not a bookmark xml file: " + rurl);
            }
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            InputSource source = new InputSource(new StringReader(sin));
            Document document = builder.parse(source);
            XPathFactory factory = XPathFactory.newInstance();
            XPath xpath = factory.newXPath();
            Object o = startAtRoot ? xpath.evaluate("/bookmark-list", document, XPathConstants.NODESET) : xpath.evaluate("/bookmark-list/bookmark-folder/bookmark-list", document, XPathConstants.NODESET);
            NodeList nl = (NodeList)o;
            NodeList bfs = (NodeList)xpath.evaluate("/bookmark-list/bookmark-folder", document, XPathConstants.NODESET);
            for (int i = 0; i < bfs.getLength(); ++i) {
                Element bf = (Element)bfs.item(i);
                String url = bf.getAttribute("remoteUrl");
                if (url.contains("%3A%2F%2F")) {
                    url = URLDecoder.decode(url, "US-ASCII");
                }
                if (!url.equals(remoteUrl)) continue;
                bf.removeAttribute("remoteUrl");
            }
            if (nl.getLength() > 1) {
                throw new MalformedRemoteBookmarksException("remote bookmarks file can only contain one root bookmark folder: " + remoteUrl);
            }
            Element flist = (Element)nl.item(0);
            if (flist == null) {
                remoteUrl2 = (String)xpath.evaluate("//bookmark-list/bookmark-folder/@remoteUrl", document, XPathConstants.STRING);
                if (remoteUrl2.length() > 0) {
                    logger.log(Level.FINE, "another remote folder: {0} at {1}", new Object[]{remoteUrl2, remoteLevel});
                    remoteRemote = true;
                }
            } else {
                remoteUrl2 = (String)xpath.evaluate("//bookmark-list/bookmark-folder/@remoteUrl", document, XPathConstants.STRING);
                if (remoteUrl2.length() > 0) {
                    logger.log(Level.FINE, "another remote folder: {0} at {1}", new Object[]{remoteUrl2, remoteLevel});
                    remoteRemote = true;
                }
                String vers1 = (String)xpath.evaluate("/bookmark-list/@version", document, XPathConstants.STRING);
                List<Bookmark> contents1 = Bookmark.parseBookmarks(flist, vers1, remoteLevel - 1);
                remoteRemote = Bookmark.checkForUnresolved(contents1);
                contents.addAll(contents1);
            }
        }
        catch (MalformedRemoteBookmarksException ex) {
            throw ex;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            Item err = new Item(MSG_REMOTE);
            err.description = ex.toString();
            err.setTitle(TITLE_ERROR_OCCURRED);
            try {
                err.setIcon(new ImageIcon(ImageIO.read(Bookmark.class.getResource("/org/autoplot/resources/warning-icon.png"))));
            }
            catch (IOException ex2) {
                logger.log(Level.SEVERE, ex2.getMessage(), ex2);
            }
            result.statusMsg = ex.toString();
            contents.add(err);
            offline = true;
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException ex) {
                    logger.log(Level.SEVERE, ex.getMessage(), ex);
                }
            }
        }
        result.remoteRemote = remoteRemote;
        result.status = offline ? 1 : 0;
        logger.log(Level.FINE, "{0}", result);
        return result;
    }

    private static Node getChildElement(Node element, String name) {
        NodeList nl = element.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            if (!nl.item(i).getNodeName().equals(name)) continue;
            return nl.item(i);
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Bookmark parseBookmark(Node element, String vers, int remoteLevel) throws IOException, BookmarksException {
        boolean hidden;
        URL descriptionUrl;
        String description;
        Node child;
        ImageIcon icon;
        String s;
        Node n;
        String uri = null;
        String title = null;
        if (element.getNodeName().equals("bookmark")) {
            if (vers.equals(MSG_REMOTE)) {
                n = Bookmark.getChildElement(element, "url");
                s = ((Text)n.getFirstChild()).getData();
                try {
                    uri = URLDecoder.decode(s, "UTF-8");
                }
                catch (IllegalArgumentException ex) {
                    throw new IllegalArgumentException(ex.getMessage() + "\nBookmarks file is unversioned, so URLs should be encoded");
                }
            } else {
                n = Bookmark.getChildElement(element, "uri");
                if (n == null) {
                    n = Bookmark.getChildElement(element, "url");
                }
                if (n == null) {
                    logger.log(Level.WARNING, "bookmarks file contains bookmark without uri: {0} {1}", new Object[]{element.getNodeName(), element.getTextContent()});
                    uri = "???";
                } else if (n.getFirstChild() != null) {
                    uri = s = ((Text)n.getFirstChild()).getData();
                } else {
                    logger.log(Level.WARNING, "bookmarks file contains uri element with no child: {0} {1}", new Object[]{element.getNodeName(), element.getTextContent()});
                    uri = "???";
                }
            }
        } else {
            uri = null;
        }
        n = Bookmark.getChildElement(element, "title");
        if (n != null) {
            if (!n.hasChildNodes()) {
                title = uri == null ? "(untitled)" : uri;
            } else {
                s = ((Text)n.getFirstChild()).getData();
                try {
                    title = vers.equals(MSG_REMOTE) ? URLDecoder.decode(s, "UTF-8") : s;
                }
                catch (IllegalArgumentException ex) {
                    throw new IllegalArgumentException(ex.getMessage() + "\nBookmarks file is unversioned, so titles should be encoded");
                }
            }
        } else {
            title = "(untitled)";
        }
        n = Bookmark.getChildElement(element, PROP_ICON);
        if (n != null) {
            s = ((Text)n.getFirstChild()).getData();
            icon = new ImageIcon(Bookmark.decodeImage(s));
        } else {
            icon = null;
        }
        n = Bookmark.getChildElement(element, "description");
        if (n != null) {
            child = n.getFirstChild();
            if (child == null) {
                description = MSG_REMOTE;
            } else {
                s = ((Text)child).getData();
                description = vers.equals(MSG_REMOTE) ? URLDecoder.decode(s, "UTF-8") : s;
            }
        } else {
            description = MSG_REMOTE;
        }
        n = Bookmark.getChildElement(element, "description-url");
        if (n != null) {
            child = n.getFirstChild();
            if (child == null) {
                descriptionUrl = null;
            } else {
                s = ((Text)child).getData();
                try {
                    descriptionUrl = new URL(vers.equals(MSG_REMOTE) ? URLDecoder.decode(s, "UTF-8") : s);
                }
                catch (MalformedURLException ex) {
                    descriptionUrl = null;
                }
            }
        } else {
            descriptionUrl = null;
        }
        if ((n = Bookmark.getChildElement(element, "hidden")) != null) {
            child = n.getFirstChild();
            if (child == null) {
                hidden = false;
            } else {
                s = ((Text)child).getData();
                hidden = s.equals("true");
            }
        } else {
            hidden = false;
        }
        if (element.getNodeName().equals("bookmark")) {
            Item book = new Item(uri);
            book.setTitle(title);
            if (icon != null) {
                book.setIcon(icon);
            }
            if (description != null) {
                book.setDescription(description);
            }
            if (descriptionUrl != null) {
                book.setDescriptionUrl(descriptionUrl);
            }
            book.setHidden(hidden);
            return book;
        }
        if (!element.getNodeName().equals("bookmark-folder")) return null;
        List<Bookmark> contents = Collections.emptyList();
        Node remoteUrlNode = ((Element)element).getAttributes().getNamedItem("remoteUrl");
        String remoteUrl = null;
        int remoteStatus = -1;
        String remoteStatusMsg = MSG_REMOTE;
        if (remoteUrlNode != null) {
            String string = remoteUrl = vers.equals(MSG_REMOTE) ? URLDecoder.decode(remoteUrlNode.getNodeValue(), "UTF-8") : remoteUrlNode.getNodeValue();
            if (remoteLevel > 0) {
                boolean waitAction = false;
                if (!waitAction) {
                    logger.finer(String.format("Reading in remote bookmarks folder \"%s\" from %s", title, remoteUrl));
                    contents = new ArrayList();
                    RemoteStatus rs = Bookmark.getRemoteBookmarks(remoteUrl, remoteLevel, false, contents);
                    if (contents.isEmpty() && !rs.remoteRemote) {
                        logger.log(Level.WARNING, "unable to parse bookmarks at {0}", remoteUrl);
                        logger.fine("Maybe using local copy");
                        remoteStatus = 1;
                        remoteStatusMsg = contents.get(0).getDescription();
                    } else {
                        remoteStatus = rs.status;
                        remoteStatusMsg = rs.statusMsg;
                    }
                    if (rs.remoteRemote) {
                        remoteStatus = -1;
                    }
                }
            } else if (remoteLevel < 0) {
                remoteStatus = 0;
            }
        } else {
            remoteStatus = 0;
        }
        if (remoteUrl == null || remoteStatus == -1 || remoteStatus == 1 || remoteLevel < 0) {
            n = Bookmark.getChildElement(element, "bookmark-list");
            if (n == null) {
                if (remoteStatus != -1 && remoteStatus != 1) throw new IllegalArgumentException("bookmark-folder should contain one bookmark-list");
                contents = Collections.emptyList();
            } else {
                Element flist = (Element)n;
                contents = Bookmark.parseBookmarks(flist, vers, remoteLevel);
            }
        }
        Folder book = new Folder(title);
        if (icon != null) {
            book.setIcon(icon);
        }
        if (remoteUrl != null) {
            book.setRemoteUrl(remoteUrl);
        }
        if (description != null) {
            book.setDescription(description);
        }
        if (descriptionUrl != null) {
            book.setDescriptionUrl(descriptionUrl);
        }
        book.setHidden(hidden);
        book.remoteStatus = remoteStatus;
        book.setRemoteStatusMsg(remoteStatusMsg);
        book.getBookmarks().addAll(contents);
        for (Bookmark content : contents) {
            content.setParent(book);
        }
        return book;
    }

    public static List<Bookmark> parseBookmarks(Element root) throws BookmarksException {
        String vers = root.getAttribute("version");
        return Bookmark.parseBookmarks(root, vers, 1);
    }

    public static List<Bookmark> parseBookmarks(Element root, int remoteLevel) throws BookmarksException {
        logger.log(Level.FINE, "parseBookmarks {0}", remoteLevel);
        String vers = root.getAttribute("version");
        return Bookmark.parseBookmarks(root, vers, remoteLevel);
    }

    public static List<Bookmark> parseBookmarks(Element root, String vers, int remoteLevel) throws BookmarksException {
        if (vers == null) {
            vers = root.getAttribute("version");
        }
        if (!root.getNodeName().equals("bookmark-list")) {
            throw new IllegalArgumentException(String.format("Expected XML element to be \"bookmark-list\" not \"%s\"", root.getNodeName()));
        }
        try {
            ArrayList<Bookmark> result = new ArrayList<Bookmark>();
            NodeList list = root.getChildNodes();
            Bookmark lastBook = null;
            for (int i = 0; i < list.getLength(); ++i) {
                Node n = list.item(i);
                if (!(n instanceof Element)) continue;
                try {
                    Bookmark book = Bookmark.parseBookmark(n, vers, remoteLevel);
                    result.add(book);
                    lastBook = book;
                    continue;
                }
                catch (Exception ex) {
                    try {
                        Bookmark.parseBookmark(n, vers, remoteLevel);
                    }
                    catch (UnsupportedEncodingException ex1) {
                        logger.log(Level.SEVERE, ex1.getMessage(), ex1);
                    }
                    catch (IOException ex1) {
                        logger.log(Level.SEVERE, ex1.getMessage(), ex1);
                    }
                    logger.log(Level.FINE, "## bookmark number={0}", i);
                    logger.log(Level.SEVERE, ex.getMessage(), ex);
                    logger.log(Level.FINE, "last bookmark parsed:{0}", lastBook);
                    throw new BookmarksException(ex);
                }
            }
            return result;
        }
        catch (OutOfMemoryError ex) {
            return Collections.singletonList(new Folder("Out of Memory while reading bookmarks."));
        }
    }

    public static String formatBooksOld(List<Bookmark> bookmarks) {
        StringBuilder buf = new StringBuilder();
        buf.append("<bookmark-list>\n");
        for (Bookmark o : bookmarks) {
            buf.append(Bookmark.formatBookmark(o));
        }
        buf.append("</bookmark-list>\n");
        return buf.toString();
    }

    public static String formatBooks(List<Bookmark> bookmarks) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        Bookmark.formatBooks(baos, bookmarks);
        try {
            return baos.toString("UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static void formatBooks(OutputStream out, List<Bookmark> bookmarks) {
        try {
            Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
            Element e = doc.createElement("bookmark-list");
            e.setAttribute("version", "1.1");
            for (Bookmark o : bookmarks) {
                Bookmark.formatBookmark(doc, e, o);
            }
            doc.appendChild(e);
            DOMImplementationLS ls = (DOMImplementationLS)doc.getImplementation().getFeature("LS", "3.0");
            LSOutput output = ls.createLSOutput();
            output.setEncoding("UTF-8");
            output.setByteStream(out);
            LSSerializer serializer = ls.createLSSerializer();
            try {
                if (serializer.getDomConfig().canSetParameter("format-pretty-print", Boolean.TRUE)) {
                    serializer.getDomConfig().setParameter("format-pretty-print", Boolean.TRUE);
                }
            }
            catch (Error error) {
                logger.log(Level.SEVERE, error.getMessage(), error);
            }
            serializer.write(doc, output);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        catch (ParserConfigurationException ex) {
            throw new RuntimeException(ex);
        }
    }

    private static String encodeImage(BufferedImage image) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)image, "png", out);
        out.size();
        return Base64.getEncoder().encodeToString(out.toByteArray());
    }

    private static BufferedImage decodeImage(String data) throws IOException {
        byte[] bd = Base64.getDecoder().decode(data);
        return ImageIO.read(new ByteArrayInputStream(bd));
    }

    public static void formatBookmark(Document doc, Element parent, Bookmark bookmark) throws IOException {
        if (bookmark instanceof Item) {
            Element desc;
            Item b = (Item)bookmark;
            Element book = doc.createElement("bookmark");
            Element title = doc.createElement("title");
            title.appendChild(doc.createTextNode(b.getTitle()));
            book.appendChild(title);
            Element url = doc.createElement("uri");
            url.appendChild(doc.createTextNode(b.getUri()));
            book.appendChild(url);
            if (b.icon != null) {
                Element icon = doc.createElement(PROP_ICON);
                icon.appendChild(doc.createTextNode(Bookmark.encodeImage((BufferedImage)b.icon.getImage())));
                book.appendChild(icon);
            }
            if (b.description != null && b.description.length() > 0) {
                desc = doc.createElement("description");
                desc.appendChild(doc.createTextNode(b.getDescription()));
                book.appendChild(desc);
            }
            if (b.descriptionUrl != null) {
                desc = doc.createElement("description-url");
                desc.appendChild(doc.createTextNode(b.getDescriptionUrl().toString()));
                book.appendChild(desc);
            }
            if (b.isHidden()) {
                desc = doc.createElement("hidden");
                desc.appendChild(doc.createTextNode("true"));
                book.appendChild(desc);
            }
            parent.appendChild(book);
        } else if (bookmark instanceof Folder) {
            Element desc;
            Folder f = (Folder)bookmark;
            Element folder = doc.createElement("bookmark-folder");
            if (f.getRemoteUrl() != null) {
                folder.setAttribute("remoteUrl", f.getRemoteUrl());
            }
            Element titleEle = doc.createElement("title");
            titleEle.appendChild(doc.createTextNode(f.getTitle()));
            folder.appendChild(titleEle);
            if (f.icon != null) {
                Element icon = doc.createElement(PROP_ICON);
                icon.appendChild(doc.createTextNode(Bookmark.encodeImage((BufferedImage)f.getIcon().getImage())));
                folder.appendChild(icon);
            }
            if (f.description != null && f.description.length() > 0) {
                desc = doc.createElement("description");
                desc.appendChild(doc.createTextNode(f.getDescription()));
                folder.appendChild(desc);
            }
            if (f.descriptionUrl != null) {
                desc = doc.createElement("description-url");
                desc.appendChild(doc.createTextNode(f.getDescriptionUrl().toString()));
                folder.appendChild(desc);
            }
            if (f.isHidden()) {
                desc = doc.createElement("hidden");
                desc.appendChild(doc.createTextNode("true"));
                folder.appendChild(desc);
            }
            Element list = doc.createElement("bookmark-list");
            for (Bookmark book : f.getBookmarks()) {
                Bookmark.formatBookmark(doc, list, book);
            }
            folder.appendChild(list);
            parent.appendChild(folder);
        }
    }

    public static String formatBookmark(Bookmark bookmark) {
        try {
            StringBuilder buf = new StringBuilder();
            if (bookmark instanceof Item) {
                Item b = (Item)bookmark;
                buf.append("  <bookmark>\n");
                buf.append("     <title>").append(URLEncoder.encode(b.getTitle(), "UTF-8")).append("</title>\n");
                if (b.icon != null) {
                    buf.append("     <icon>").append(Bookmark.encodeImage((BufferedImage)b.icon.getImage())).append("</icon>\n");
                }
                if (b.description != null) {
                    buf.append("     <description>").append(URLEncoder.encode(b.getDescription(), "UTF-8")).append("</description>\n");
                }
                if (b.descriptionUrl != null) {
                    buf.append("      <description-url>").append(b.getDescriptionUrl()).append("</description-url>\n");
                }
                buf.append("     <url>").append(URLEncoder.encode(b.getUri(), "UTF-8")).append("</url>\n");
                if (bookmark.isHidden()) {
                    buf.append("     <hidden>true</hidden>\n");
                }
                buf.append("  </bookmark>\n");
            } else if (bookmark instanceof Folder) {
                Folder f = (Folder)bookmark;
                String title = f.getTitle();
                if (f.getRemoteUrl() != null) {
                    buf.append("  <bookmark-folder remoteUrl=\"").append(URLEncoder.encode(f.getRemoteUrl(), "UTF-8")).append("\">\n");
                } else {
                    buf.append("  <bookmark-folder>\n");
                }
                buf.append("    <title>").append(URLEncoder.encode(title, "UTF-8")).append("</title>\n");
                if (f.icon != null) {
                    buf.append("     <icon>").append(Bookmark.encodeImage((BufferedImage)f.icon.getImage())).append("</icon>\n");
                }
                if (bookmark.isHidden()) {
                    buf.append("     <hidden>true</hidden>\n");
                }
                if (f.description != null) {
                    buf.append("     <description>").append(URLEncoder.encode(f.getDescription(), "UTF-8")).append("</description>\n");
                }
                if (f.descriptionUrl != null) {
                    buf.append("      <description-url>").append(f.getDescriptionUrl()).append("</description-url>\n");
                }
                buf.append(Bookmark.formatBooksOld(f.getBookmarks()));
                buf.append("  </bookmark-folder>\n");
            }
            return buf.toString();
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException(ex);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    private Bookmark(String title) {
        this.title = title;
        this.id = String.valueOf(++seq);
    }

    public String toString() {
        return this.title;
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.propertyChangeSupport.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.propertyChangeSupport.removePropertyChangeListener(l);
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        String oldTitle = this.title;
        this.title = title;
        this.propertyChangeSupport.firePropertyChange("title", oldTitle, title);
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        String oldValue = this.description;
        this.description = description;
        this.propertyChangeSupport.firePropertyChange("description", oldValue, description);
    }

    public URL getDescriptionUrl() {
        return this.descriptionUrl;
    }

    public void setDescriptionUrl(URL descriptionUrl) {
        URL oldValue = this.descriptionUrl;
        this.descriptionUrl = descriptionUrl;
        this.propertyChangeSupport.firePropertyChange("descriptionUrl", oldValue, this.description);
    }

    public ImageIcon getIcon() {
        return this.icon;
    }

    public void setIcon(ImageIcon icon) {
        ImageIcon oldIcon = this.icon;
        this.icon = icon;
        this.propertyChangeSupport.firePropertyChange(PROP_ICON, oldIcon, icon);
    }

    public void setHidden(boolean hidden) {
        this.hidden = hidden;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public Folder getParent() {
        return this.parent;
    }

    public void setParent(Folder parent) {
        Folder old = this.parent;
        this.parent = parent;
        this.propertyChangeSupport.firePropertyChange(PROP_PARENT, old, parent);
    }

    public abstract Bookmark copy();

    public static class Item
    extends Bookmark {
        private String uri;

        public Item(String suri) {
            super(suri);
            this.uri = suri;
        }

        public String getUri() {
            return this.uri;
        }

        public void setUri(String uri) {
            String oldUrl = this.uri;
            this.uri = uri;
            this.propertyChangeSupport.firePropertyChange("uri", oldUrl, uri);
        }

        public int hashCode() {
            return this.uri.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj instanceof Item) {
                Item that = (Item)obj;
                return that.uri.equals(this.uri) && (that.getParent() == null || this.getParent() == null || that.getParent().getTitle().equals(this.getParent().getTitle()));
            }
            return false;
        }

        @Override
        public Bookmark copy() {
            Item result = new Item(this.getUri());
            result.setTitle(this.getTitle());
            result.description = this.description;
            return result;
        }
    }

    public static class Folder
    extends Bookmark {
        List<Bookmark> bookmarks;
        String remoteUrl = null;
        public static final int REMOTE_STATUS_NOT_LOADED = -1;
        public static final int REMOTE_STATUS_SUCCESSFUL = 0;
        public static final int REMOTE_STATUS_UNSUCCESSFUL = 1;
        int remoteStatus = -1;
        String remoteStatusMsg = "";

        public void setRemoteUrl(String url) {
            this.remoteUrl = url;
        }

        public String getRemoteUrl() {
            return this.remoteUrl;
        }

        public void setRemoteStatus(int status) {
            this.remoteStatus = status;
        }

        public int getRemoteStatus() {
            return this.remoteStatus;
        }

        public String getRemoteStatusMsg() {
            return this.remoteStatusMsg;
        }

        public void setRemoteStatusMsg(String msg) {
            this.remoteStatusMsg = msg;
        }

        public Folder(String title) {
            super(title);
            this.bookmarks = new ArrayList<Bookmark>();
            this.remoteStatus = 0;
        }

        public Folder(String title, String remoteUrl) {
            super(title);
            this.remoteUrl = remoteUrl;
            this.bookmarks = new ArrayList<Bookmark>();
        }

        public List<Bookmark> getBookmarks() {
            return this.bookmarks;
        }

        public int hashCode() {
            return this.bookmarks.hashCode() + (this.remoteUrl != null ? this.remoteUrl.hashCode() : 0);
        }

        public boolean equals(Object obj) {
            if (obj instanceof Folder) {
                Folder that = (Folder)obj;
                return that.getTitle().equals(this.getTitle()) && (that.getParent() == null || this.getParent() != null && that.getParent().getTitle().equals(this.getParent().getTitle()));
            }
            return false;
        }

        @Override
        public Bookmark copy() {
            Folder result = new Folder(this.getTitle());
            result.description = this.description;
            result.remoteUrl = this.remoteUrl;
            result.remoteStatus = this.remoteStatus;
            result.bookmarks = new ArrayList<Bookmark>(this.bookmarks);
            return result;
        }

        @Override
        public String toString() {
            return this.getTitle() + (this.remoteStatus != 0 ? "*" : Bookmark.MSG_REMOTE);
        }
    }
}

